/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.http.multipart;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.ngrinder.http.multipart.MultipartEntity;

public class MultipartEntityProducer
implements AsyncEntityProducer {
    private static final String BOUNDARY_END = "-----------bGd5dW5vZG1pYm91anl1ZW9nbm55bm5vZ2p1ZQ--\r\n";
    private final List<MultipartEntity> multipartEntities;
    private final ContentType contentType;
    private final long length;
    private final ConcurrentLinkedQueue<MultipartEntity> entityQueue;
    private MultipartEntity currentEntity;
    private final AtomicReference<Exception> exception;

    public MultipartEntityProducer(List<MultipartEntity> multipartEntities) {
        this(multipartEntities, ContentType.MULTIPART_FORM_DATA);
    }

    public MultipartEntityProducer(List<MultipartEntity> multipartEntities, ContentType contentType) {
        this.multipartEntities = multipartEntities;
        this.contentType = contentType;
        this.length = this.calculateLength();
        this.entityQueue = new ConcurrentLinkedQueue<MultipartEntity>(multipartEntities);
        this.exception = new AtomicReference<Object>(null);
        this.currentEntity = (MultipartEntity)this.entityQueue.remove();
    }

    private long calculateLength() {
        long totalContentLength = this.multipartEntities.stream().map(MultipartEntity::getContentLength).reduce(Long::sum).orElse(0L);
        long newLineEachEntity = (long)this.multipartEntities.size() * (long)"\r\n".length();
        long lastBoundary = BOUNDARY_END.length();
        return totalContentLength + newLineEachEntity + lastBoundary;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void failed(Exception cause) {
        if (this.exception.compareAndSet(null, cause)) {
            this.releaseResources();
        }
    }

    public long getContentLength() {
        return this.length;
    }

    public String getContentType() {
        return this.withBoundary(this.contentType);
    }

    private String withBoundary(ContentType contentType) {
        return contentType + "; boundary=" + "---------bGd5dW5vZG1pYm91anl1ZW9nbm55bm5vZ2p1ZQ";
    }

    public String getContentEncoding() {
        return null;
    }

    public boolean isChunked() {
        return false;
    }

    public Set<String> getTrailerNames() {
        return null;
    }

    public int available() {
        return Integer.MAX_VALUE;
    }

    public void produce(DataStreamChannel channel) throws IOException {
        if (this.currentEntity.hasRemaining()) {
            this.currentEntity.produce(channel);
        }
        if (!this.currentEntity.hasRemaining()) {
            this.currentEntity = this.entityQueue.poll();
        }
        if (this.currentEntity == null) {
            channel.write(ByteBuffer.wrap(BOUNDARY_END.getBytes()));
            channel.endStream();
        }
    }

    public void releaseResources() {
        this.multipartEntities.forEach(MultipartEntity::releaseResources);
    }
}

