/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.http.util;

import HTTPClient.NVPair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PairListConvertUtils {
    private PairListConvertUtils() {
    }

    public static <R> List<R> convert(Map<String, String> map, BiFunction<String, String, R> converter) {
        Function<Map.Entry, Object> keyValueMapper = entry -> converter.apply((String)entry.getKey(), (String)entry.getValue());
        return map.entrySet().stream().map(keyValueMapper).collect(Collectors.toList());
    }

    public static <R> List<R> convert(NVPair[] pairs, BiFunction<String, String, R> converter) {
        Function<NVPair, Object> pairMapper = pair -> converter.apply(pair.getName(), pair.getValue());
        return Arrays.stream(pairs).map(pairMapper).collect(Collectors.toList());
    }
}

