/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.sm;

import java.awt.AWTPermission;
import java.io.File;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.kerberos.DelegationPermission;
import javax.security.auth.kerberos.ServicePermission;
import javax.sound.sampled.AudioPermission;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class NGrinderSecurityManager
extends SecurityManager {
    private static final String NGRINDER_CONTROLLER_DEFAULT_FOLDER = ".ngrinder";
    private static final String NGRINDER_CONTROLLER_TEMP_FOLDER = "tmp";
    private static final String NGRINDER_CONTEXT_CONTROLLER = "controller";
    private String workDirectory = System.getProperty("user.dir");
    private String controllerHomeDir = "";
    private String controllerHomeTmpDir = "";
    private String ngrinderContext = "";
    private final String pythonPath = System.getProperty("python.path");
    private final String pythonHome = System.getProperty("python.home");
    private final String pythonCache = System.getProperty("python.cachedir");
    private final String etcHosts = System.getProperty("ngrinder.etc.hosts", "");
    private final String consoleIP = System.getProperty("ngrinder.console.ip", "127.0.0.1");
    private final List<String> allowedHost = new ArrayList<String>();
    private final List<String> writeAllowedDirectory = new ArrayList<String>();
    private final List<String> deleteAllowedDirectory = new ArrayList<String>();
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char OTHER_SEPARATOR = NGrinderSecurityManager.isSystemWindows() ? (char)47 : (char)92;

    public NGrinderSecurityManager() {
        this.init();
        this.checkPermission(new AllPermission());
    }

    void init() {
        this.ngrinderContext = System.getProperty("ngrinder.context", "agent");
        if (this.isControllerContext()) {
            this.controllerHomeDir = this.resolveControllerHomeDir();
            this.controllerHomeTmpDir = this.controllerHomeDir + File.separator + NGRINDER_CONTROLLER_TEMP_FOLDER;
        }
        this.initAccessOfDirectories();
        this.initAccessOfHosts();
    }

    private String resolveControllerHomeDir() {
        String userHomeFromEnv = System.getenv("NGRINDER_HOME");
        String userHomeFromProperty = System.getProperty("ngrinder.home");
        String userHome = StringUtils.defaultIfEmpty((String)userHomeFromProperty, (String)userHomeFromEnv);
        if (StringUtils.isEmpty((String)userHome)) {
            userHome = System.getProperty("user.home") + File.separator + NGRINDER_CONTROLLER_DEFAULT_FOLDER;
        } else if (StringUtils.startsWith((String)userHome, (String)("~" + File.separator))) {
            userHome = System.getProperty("user.home") + File.separator + userHome.substring(2);
        } else if (StringUtils.startsWith((String)userHome, (String)("." + File.separator))) {
            userHome = System.getProperty("user.dir") + File.separator + userHome.substring(2);
        }
        return FilenameUtils.normalize((String)userHome);
    }

    private void initAccessOfDirectories() {
        String logDirectory;
        this.workDirectory = this.normalize(new File(this.workDirectory).getAbsolutePath(), null);
        if (this.workDirectory != null && !this.workDirectory.isEmpty()) {
            logDirectory = this.workDirectory.substring(0, this.workDirectory.lastIndexOf(File.separator));
            logDirectory = logDirectory.substring(0, this.workDirectory.lastIndexOf(File.separator)) + File.separator + "log";
        } else {
            logDirectory = "log";
        }
        if (NGrinderSecurityManager.isNotEmpty(this.pythonCache)) {
            this.writeAllowedDirectory.add(this.pythonCache);
        }
        if (NGrinderSecurityManager.isNotEmpty(this.pythonHome)) {
            this.writeAllowedDirectory.add(this.pythonHome);
        }
        if (NGrinderSecurityManager.isNotEmpty(this.pythonPath)) {
            this.writeAllowedDirectory.add(this.pythonPath);
        }
        if (NGrinderSecurityManager.isNotEmpty(this.pythonCache)) {
            this.writeAllowedDirectory.add(this.pythonCache);
        }
        this.writeAllowedDirectory.add(this.workDirectory);
        this.writeAllowedDirectory.add(logDirectory);
        this.writeAllowedDirectory.add(NGrinderSecurityManager.getTempDirectoryPath());
        this.deleteAllowedDirectory.add(this.workDirectory);
    }

    private static boolean isNotEmpty(String str) {
        return str != null && str.length() != 0;
    }

    private static String getTempDirectoryPath() {
        return System.getProperty("java.io.tmpdir");
    }

    private void initAccessOfHosts() {
        String[] hostsList;
        for (String hosts : hostsList = this.etcHosts.split(",")) {
            String[] addresses = hosts.split(":");
            if (addresses.length > 1) {
                this.allowedHost.add(addresses[0]);
                this.allowedHost.add(addresses[addresses.length - 1]);
                continue;
            }
            this.allowedHost.add(hosts);
        }
        this.allowedHost.add(this.consoleIP);
        try {
            Security.setProperty("networkaddress.cache.ttl", "0");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void checkPermission(Permission permission) {
        if (permission instanceof RuntimePermission) {
            String permissionName = permission.getName();
            if ("setSecurityManager".equals(permissionName)) {
                this.processSetSecurityManagerAction();
            }
        } else {
            if (permission instanceof UnresolvedPermission) {
                throw new SecurityException("java.security.UnresolvedPermission is not allowed.");
            }
            if (permission instanceof AWTPermission) {
                throw new SecurityException("java.awt.AWTPermission is not allowed.");
            }
            if (permission instanceof AuthPermission) {
                throw new SecurityException("javax.security.auth.AuthPermission is not allowed.");
            }
            if (permission instanceof PrivateCredentialPermission) {
                throw new SecurityException("javax.security.auth.PrivateCredentialPermission is not allowed.");
            }
            if (permission instanceof DelegationPermission) {
                throw new SecurityException("javax.security.auth.kerberos.DelegationPermission is not allowed.");
            }
            if (permission instanceof ServicePermission) {
                throw new SecurityException("javax.security.auth.kerberos.ServicePermission is not allowed.");
            }
            if (permission instanceof AudioPermission) {
                throw new SecurityException("javax.sound.sampled.AudioPermission is not allowed.");
            }
        }
    }

    protected void processSetSecurityManagerAction() throws SecurityException {
        throw new SecurityException("java.lang.RuntimePermission: setSecurityManager is not allowed.");
    }

    @Override
    public void checkPermission(Permission permission, Object context) {
        this.checkPermission(permission);
    }

    @Override
    public void checkRead(String file) {
        if (this.isControllerContext() && file != null) {
            this.fileAccessReadAllowed(file);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (this.isControllerContext() && file != null) {
            this.fileAccessReadAllowed(file);
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
    }

    @Override
    public void checkWrite(String file) {
        this.fileAccessWriteAllowed(file);
    }

    @Override
    public void checkDelete(String file) {
        this.fileAccessDeleteAllowed(file);
    }

    @Override
    public void checkExec(String cmd) {
        throw new SecurityException("Cmd execution of " + cmd + " is not allowed.");
    }

    private void fileAccessReadAllowed(String file) {
        String filePath = this.normalize(file, this.workDirectory);
        if (filePath != null && filePath.startsWith(this.controllerHomeDir) && !filePath.startsWith(this.workDirectory) && !filePath.startsWith(this.controllerHomeTmpDir)) {
            throw new SecurityException("File Read access on " + file + "(" + filePath + ") is not allowed.");
        }
    }

    private void fileAccessWriteAllowed(String file) {
        if (this.isAgentWorkerLogFile(file)) {
            return;
        }
        String filePath = this.normalize(file, this.workDirectory);
        for (String dir : this.writeAllowedDirectory) {
            if (filePath == null || !filePath.startsWith(dir)) continue;
            return;
        }
        throw new SecurityException("File write access on " + file + "(" + filePath + ") is not allowed.");
    }

    private void fileAccessDeleteAllowed(String file) {
        if (this.isAgentWorkerLogFile(file)) {
            return;
        }
        String filePath = this.normalize(file, this.workDirectory);
        for (String dir : this.deleteAllowedDirectory) {
            if (filePath == null || !filePath.startsWith(dir)) continue;
            return;
        }
        throw new SecurityException("File delete access on " + file + "(" + filePath + ") is not allowed.");
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        throw new SecurityException("Multicast on " + maddr.toString() + " is not always allowed.");
    }

    @Override
    public void checkConnect(String host, int port) {
        this.netWorkAccessAllowed(host);
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        this.netWorkAccessAllowed(host);
    }

    private boolean isAgentWorkerLogFile(String file) {
        return file != null && (file.contains("log/test_") || file.contains("log\\test_"));
    }

    private String normalize(String filename, String workingDirectory) {
        if (NGrinderSecurityManager.getPrefixLength(filename) == 0 && workingDirectory != null) {
            filename = workingDirectory + File.separator + filename;
        }
        return NGrinderSecurityManager.doNormalize(filename);
    }

    private void netWorkAccessAllowed(String host) {
        if (this.allowedHost.contains(host)) {
            return;
        }
        throw new SecurityException("NetWork access on " + host + " is not allowed. Please add " + host + " on the target host setting.");
    }

    private boolean isControllerContext() {
        return this.ngrinderContext.equalsIgnoreCase(NGRINDER_CONTEXT_CONTROLLER);
    }

    private static boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    private static String doNormalize(String filename) {
        int i;
        if (filename == null) {
            return null;
        }
        int size = filename.length();
        if (size == 0) {
            return filename;
        }
        int prefix = NGrinderSecurityManager.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        char[] array = new char[size + 2];
        filename.getChars(0, filename.length(), array, 0);
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != OTHER_SEPARATOR) continue;
            array[i2] = SYSTEM_SEPARATOR;
        }
        boolean lastIsDirectory = true;
        if (array[size - 1] != SYSTEM_SEPARATOR) {
            array[size++] = SYSTEM_SEPARATOR;
            lastIsDirectory = false;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != SYSTEM_SEPARATOR || array[i - 1] != SYSTEM_SEPARATOR) continue;
            System.arraycopy(array, i, array, i - 1, size - i);
            --size;
            --i;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != SYSTEM_SEPARATOR || array[i - 1] != '.' || i != prefix + 1 && array[i - 2] != SYSTEM_SEPARATOR) continue;
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            System.arraycopy(array, i + 1, array, i - 1, size - i);
            size -= 2;
            --i;
        }
        block3: for (i = prefix + 2; i < size; ++i) {
            if (array[i] != SYSTEM_SEPARATOR || array[i - 1] != '.' || array[i - 2] != '.' || i != prefix + 2 && array[i - 3] != SYSTEM_SEPARATOR) continue;
            if (i == prefix + 2) {
                return null;
            }
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            for (int j = i - 4; j >= prefix; --j) {
                if (array[j] != SYSTEM_SEPARATOR) continue;
                System.arraycopy(array, i + 1, array, j + 1, size - i);
                size -= i - j;
                i = j + 1;
                continue block3;
            }
            System.arraycopy(array, i + 1, array, prefix, size - i);
            size -= i + 1 - prefix;
            i = prefix + 1;
        }
        if (size <= 0) {
            return "";
        }
        if (size <= prefix) {
            return new String(array, 0, size);
        }
        if (lastIsDirectory) {
            return new String(array, 0, size);
        }
        return new String(array, 0, size - 1);
    }

    private static int getPrefixLength(String filename) {
        if (filename == null) {
            return -1;
        }
        int len = filename.length();
        if (len == 0) {
            return 0;
        }
        char ch0 = filename.charAt(0);
        if (ch0 == ':') {
            return -1;
        }
        if (len == 1) {
            if (ch0 == '~') {
                return 2;
            }
            return NGrinderSecurityManager.isSeparator(ch0) ? 1 : 0;
        }
        if (ch0 == '~') {
            int posUnix = filename.indexOf(47, 1);
            int posWin = filename.indexOf(92, 1);
            if (posUnix == -1 && posWin == -1) {
                return len + 1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        char ch1 = filename.charAt(1);
        if (ch1 == ':') {
            if ((ch0 = Character.toUpperCase(ch0)) >= 'A' && ch0 <= 'Z') {
                if (len == 2 || !NGrinderSecurityManager.isSeparator(filename.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (NGrinderSecurityManager.isSeparator(ch0) && NGrinderSecurityManager.isSeparator(ch1)) {
            int posUnix = filename.indexOf(47, 2);
            int posWin = filename.indexOf(92, 2);
            if (posUnix == -1 && posWin == -1 || posUnix == 2 || posWin == 2) {
                return -1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        return NGrinderSecurityManager.isSeparator(ch0) ? 1 : 0;
    }

    private static boolean isSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }
}

