/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import javax.security.cert.CertificateEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.nhind.config.rest.CertificateService;
import org.nhind.config.rest.DNSService;
import org.nhind.config.rest.SettingService;
import org.nhindirect.common.crypto.MutableKeyStoreProtectionManager;
import org.nhindirect.common.crypto.WrappableKeyProtectionManager;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.config.model.Certificate;
import org.nhindirect.config.model.DNSRecord;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.util.DNSRecordUtils;
import org.nhindirect.config.ui.DNSController;
import org.nhindirect.config.ui.SrvRecord;
import org.nhindirect.config.ui.form.CertificateForm;
import org.nhindirect.config.ui.form.DNSEntryForm;
import org.nhindirect.config.ui.form.DNSType;
import org.nhindirect.config.ui.form.SearchDomainForm;
import org.nhindirect.config.ui.form.SettingsForm;
import org.nhindirect.config.ui.form.SimpleForm;
import org.nhindirect.config.ui.util.AjaxUtils;
import org.nhindirect.config.ui.util.PrivateKeyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/dns"})
public class DNSController {
    private static final Logger log = LoggerFactory.getLogger(DNSController.class);
    private static final String DEFAULT_JCE_PROVIDER_STRING = "BC";
    private static final String JCE_PROVIDER_STRING_SYS_PARAM = "org.nhindirect.config.JCEProviderName";
    private CertificateService certService;
    private DNSService dnsService;
    private SettingService settingsService;
    @Autowired(required=false)
    private WrappableKeyProtectionManager keyManager;

    @Autowired
    public void setCertificateService(CertificateService certService) {
        this.certService = certService;
    }

    @Autowired
    public void setDNSService(DNSService dnsService) {
        this.dnsService = dnsService;
    }

    @Autowired
    public void setSettingsService(SettingService settingsService) {
        this.settingsService = settingsService;
    }

    public static String getJCEProviderName() {
        String retVal = System.getProperty("org.nhindirect.config.JCEProviderName");
        if (retVal == null || retVal.isEmpty()) {
            retVal = "BC";
        }
        return retVal;
    }

    public DNSController() {
        if (log.isDebugEnabled()) {
            log.debug("ConfigurationController initialized");
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/navigate"}, method={RequestMethod.GET})
    public ModelAndView navigate(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute DNSEntryForm entryForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: {}", (Object)actionPath);
        }
        ModelAndView mav = new ModelAndView();
        if ("gotodomains".equalsIgnoreCase(actionPath) || "domains".equalsIgnoreCase(actionPath)) {
            SearchDomainForm form2 = (SearchDomainForm)session.getAttribute("searchDomainForm");
            model.addAttribute((Object)(form2 != null ? form2 : new SearchDomainForm()));
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.setViewName("main");
            mav.addObject("privKeyTypeList", (Object)PrivateKeyType.getPrivKeyTypeList());
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        } else if ("gotosettings".equalsIgnoreCase(actionPath) || "settings".equalsIgnoreCase(actionPath)) {
            String action = "add";
            model.addAttribute("action", (Object)"add");
            mav.setViewName("settings");
            mav.addObject("actionPath", (Object)actionPath);
            SettingsForm form = (SettingsForm)session.getAttribute("settingsForm");
            if (form == null) {
                form = new SettingsForm();
            }
            model.addAttribute("settingsForm", (Object)form);
            ArrayList results = null;
            if (this.settingsService != null) {
                try {
                    Collection settings = this.settingsService.getSettings();
                    results = settings != null ? new ArrayList(settings) : new ArrayList();
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
            }
            model.addAttribute("simpleForm", (Object)new SimpleForm());
            model.addAttribute("settingsResults", results);
        } else if (actionPath.equalsIgnoreCase("gotocertificates") || actionPath.equalsIgnoreCase("certificates")) {
            String action = "Update";
            model.addAttribute("action", (Object)"Update");
            mav.setViewName("certificates");
            mav.addObject("actionPath", (Object)actionPath);
            CertificateForm form = (CertificateForm)session.getAttribute("certificateForm");
            if (form == null) {
                form = new CertificateForm();
            }
            model.addAttribute("certificateForm", (Object)form);
            ArrayList results = null;
            if (this.certService != null) {
                try {
                    Collection certs = this.certService.getAllCertificates();
                    if (certs != null) {
                        if (this.keyManager != null && this.keyManager instanceof MutableKeyStoreProtectionManager) {
                            KeyStore keyStore = ((MutableKeyStoreProtectionManager)this.keyManager).getKS();
                            for (Certificate cert : certs) {
                                if (cert.isPrivateKey()) continue;
                                try {
                                    PrivateKey privKey;
                                    X509Certificate checkCert = CertUtils.toX509Certificate((byte[])cert.getData());
                                    String alias = keyStore.getCertificateAlias(checkCert);
                                    if (StringUtils.isEmpty((CharSequence)alias) || (privKey = (PrivateKey)keyStore.getKey(alias, "".toCharArray())) == null) continue;
                                    cert.setPrivateKey(true);
                                }
                                catch (Exception exception) {}
                            }
                        }
                        results = new ArrayList(certs);
                    } else {
                        results = new ArrayList();
                    }
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
            }
            model.addAttribute("simpleForm", (Object)new SimpleForm());
            model.addAttribute("certificatesResults", results);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showDNSEntries(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute DNSEntryForm entryForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (log.isDebugEnabled()) {
            log.debug("Enter");
        }
        ModelAndView mav = new ModelAndView("dns");
        model.addAttribute("dnsEntryForm", (Object)new DNSEntryForm());
        if (this.dnsService != null) {
            this.refreshModelFromService(model);
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addDNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="AdnsForm") DNSEntryForm AdnsForm, @ModelAttribute(value="AAdnsForm") DNSEntryForm AAdnsForm, @ModelAttribute(value="CdnsForm") DNSEntryForm CdnsForm, @ModelAttribute(value="CertdnsForm") DNSEntryForm CertdnsForm, @ModelAttribute(value="SrvdnsForm") DNSEntryForm SrvdnsForm, @ModelAttribute(value="MXdnsForm") DNSEntryForm MXdnsForm, Model model, @RequestParam(value="submitType") String actionPath) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Enter");
        }
        if (AdnsForm != null && !AdnsForm.getName().equalsIgnoreCase("") && AdnsForm.getTtl() != 0L && !AdnsForm.getDest().equalsIgnoreCase("")) {
            AdnsForm.setType("A");
            DNSEntryForm.toDNSRecord((DNSEntryForm)AdnsForm);
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        if (AAdnsForm != null && !AAdnsForm.getName().equalsIgnoreCase("") && AAdnsForm.getTtl() != 0L && !AAdnsForm.getDest().equalsIgnoreCase("")) {
            AAdnsForm.setType("AAAA");
            DNSEntryForm.toDNSRecord((DNSEntryForm)AAdnsForm);
        }
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        if (CdnsForm != null && !CdnsForm.getName().equalsIgnoreCase("") && CdnsForm.getTtl() != 0L && !CdnsForm.getDest().equalsIgnoreCase("")) {
            CdnsForm.setType("CNAME");
            DNSEntryForm.toDNSRecord((DNSEntryForm)CdnsForm);
        }
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        if (MXdnsForm != null && !MXdnsForm.getName().equalsIgnoreCase("") && MXdnsForm.getTtl() != 0L && !MXdnsForm.getDest().equalsIgnoreCase("")) {
            MXdnsForm.setType("MX");
            DNSEntryForm.toDNSRecord((DNSEntryForm)MXdnsForm);
        }
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        if (CertdnsForm != null && !CertdnsForm.getName().equalsIgnoreCase("") && CertdnsForm.getTtl() != 0L && !CertdnsForm.getDest().equalsIgnoreCase("")) {
            CertdnsForm.setType("CERT");
            DNSEntryForm.toDNSRecord((DNSEntryForm)CertdnsForm);
        }
        if (SrvdnsForm != null && !SrvdnsForm.getName().equalsIgnoreCase("") && SrvdnsForm.getTtl() != 0L && !SrvdnsForm.getDest().equalsIgnoreCase("")) {
            SrvdnsForm.setType("SRV");
            DNSEntryForm.toDNSRecord((DNSEntryForm)SrvdnsForm);
        }
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (log.isDebugEnabled()) {
            log.debug("Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addADNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="AdnsForm") DNSEntryForm AdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (log.isDebugEnabled()) {
            log.debug("Enter");
        }
        if (AdnsForm != null && !AdnsForm.getName().equalsIgnoreCase("") && AdnsForm.getTtl() != 0L && !AdnsForm.getDest().equalsIgnoreCase("")) {
            try {
                this.dnsService.addDNSRecord(DNSEntryForm.entityToModelRecord((org.nhindirect.config.store.DNSRecord)DNSRecordUtils.createARecord((String)AdnsForm.getName(), (long)AdnsForm.getTtl(), (String)AdnsForm.getDest())));
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (log.isDebugEnabled()) {
            log.debug("Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addNSDNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addNSSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="NSdnsForm") DNSEntryForm NSdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (log.isDebugEnabled()) {
            log.debug("Enter");
        }
        if (NSdnsForm != null && !NSdnsForm.getName().equalsIgnoreCase("") && NSdnsForm.getTtl() != 0L && !NSdnsForm.getDest().equalsIgnoreCase("")) {
            try {
                this.dnsService.addDNSRecord(DNSEntryForm.createNSRecord((String)NSdnsForm.getName(), (long)NSdnsForm.getTtl(), (String)NSdnsForm.getDest()));
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (log.isDebugEnabled()) {
            log.debug("Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addA4DNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addA4Setting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="AAdnsForm") DNSEntryForm AAdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (log.isDebugEnabled()) {
            log.debug("Enter");
        }
        if (AAdnsForm != null && !AAdnsForm.getName().equalsIgnoreCase("") && AAdnsForm.getTtl() != 0L && !AAdnsForm.getDest().equalsIgnoreCase("")) {
            try {
                this.dnsService.addDNSRecord(DNSEntryForm.createA4Record((String)AAdnsForm.getName(), (long)AAdnsForm.getTtl(), (String)AAdnsForm.getDest()));
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (log.isDebugEnabled()) {
            log.debug("Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addMXDNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addMXSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="MXdnsForm") DNSEntryForm MXdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (log.isDebugEnabled()) {
            log.debug("Enter");
        }
        if (MXdnsForm != null && !MXdnsForm.getName().equalsIgnoreCase("") && MXdnsForm.getTtl() != 0L && !MXdnsForm.getDest().equalsIgnoreCase("")) {
            try {
                this.dnsService.addDNSRecord(DNSEntryForm.entityToModelRecord((org.nhindirect.config.store.DNSRecord)DNSRecordUtils.createMXRecord((String)MXdnsForm.getName(), (String)MXdnsForm.getDest(), (long)MXdnsForm.getTtl(), (int)MXdnsForm.getPriority())));
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (log.isDebugEnabled()) {
            log.debug("Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addCNAMEDNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addCNAMESetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="CdnsForm") DNSEntryForm CdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (log.isDebugEnabled()) {
            log.debug("Enter");
        }
        if (CdnsForm != null && !CdnsForm.getName().equalsIgnoreCase("") && CdnsForm.getTtl() != 0L && !CdnsForm.getDest().equalsIgnoreCase("")) {
            try {
                this.dnsService.addDNSRecord(DNSEntryForm.toDNSRecord((DNSEntryForm)CdnsForm));
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (log.isDebugEnabled()) {
            log.debug("Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addSRVDNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addSRVSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="SrvdnsForm") DNSEntryForm SrvdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (log.isDebugEnabled()) {
            log.debug("Enter");
        }
        if (SrvdnsForm != null && !SrvdnsForm.getName().equalsIgnoreCase("") && SrvdnsForm.getTtl() != 0L && !SrvdnsForm.getDest().equalsIgnoreCase("")) {
            DNSRecord rec = DNSEntryForm.entityToModelRecord((org.nhindirect.config.store.DNSRecord)DNSRecordUtils.createSRVRecord((String)("_" + SrvdnsForm.getService() + "._" + SrvdnsForm.getProtocol() + "." + SrvdnsForm.getName()), (String)SrvdnsForm.getDest(), (long)SrvdnsForm.getTtl(), (int)SrvdnsForm.getPort(), (int)SrvdnsForm.getPriority(), (int)SrvdnsForm.getWeight()));
            try {
                this.dnsService.addDNSRecord(rec);
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        mav.setViewName("dns");
        if (log.isDebugEnabled()) {
            log.debug("Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addCertDNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addCertSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="CertdnsForm") DNSEntryForm CertdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (log.isDebugEnabled()) {
            log.debug("Enter");
        }
        if (CertdnsForm != null && !CertdnsForm.getName().equalsIgnoreCase("") && CertdnsForm.getTtl() != 0L) {
            byte[] certbytes;
            X509Certificate tcert;
            block9: {
                tcert = null;
                certbytes = null;
                try {
                    if (!CertdnsForm.getFileData().isEmpty()) {
                        CertContainer cont;
                        byte[] bytes;
                        certbytes = bytes = CertdnsForm.getFileData().getBytes();
                        if (bytes != null && (cont = this.toCertContainer(bytes)) != null && cont.getCert() != null) {
                            Certificate cert2 = new Certificate();
                            cert2.setData(bytes);
                            tcert = cont.getCert();
                        }
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block9;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            CertdnsForm.setType("CERT");
            CertdnsForm.setCertificate(tcert);
            CertdnsForm.setCertificateData(certbytes);
            try {
                this.dnsService.addDNSRecord(DNSEntryForm.createCertRecord((DNSEntryForm)CertdnsForm));
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (log.isDebugEnabled()) {
            log.debug("Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addSOADNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addSOASetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="SoadnsForm") DNSEntryForm SoadnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (log.isDebugEnabled()) {
            log.debug("Enter");
        }
        if (SoadnsForm != null && !SoadnsForm.getName().equalsIgnoreCase("") && SoadnsForm.getTtl() != 0L) {
            DNSRecord rec = DNSEntryForm.entityToModelRecord((org.nhindirect.config.store.DNSRecord)DNSRecordUtils.createSOARecord((String)SoadnsForm.getName(), (long)SoadnsForm.getTtl(), (String)SoadnsForm.getDomain(), (String)SoadnsForm.getAdmin(), (int)((int)SoadnsForm.getSerial()), (long)SoadnsForm.getRefresh(), (long)SoadnsForm.getRetry(), (long)SoadnsForm.getExpire(), (long)SoadnsForm.getMinimum()));
            try {
                this.dnsService.addDNSRecord(rec);
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        mav.setViewName("dns");
        if (log.isDebugEnabled()) {
            log.debug("Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removesettings"}, method={RequestMethod.POST})
    public ModelAndView removeAnchors(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, @ModelAttribute(value="AdnsForm") DNSEntryForm AdnsForm, @ModelAttribute(value="NSdnsForm") DNSEntryForm NSdnsForm, @ModelAttribute(value="AAdnsForm") DNSEntryForm AAdnsForm, @ModelAttribute(value="CdnsForm") DNSEntryForm CdnsForm, @ModelAttribute(value="CertdnsForm") DNSEntryForm CertdnsForm, @ModelAttribute(value="SrvdnsForm") DNSEntryForm SrvdnsForm, @ModelAttribute(value="SoadnsForm") DNSEntryForm SoadnsForm, @ModelAttribute(value="MXdnsForm") DNSEntryForm MXdnsForm, HttpSession session, Model model, @RequestParam(value="submitType") String actionPath) {
        Collection a4records2;
        Long remid;
        String removeid;
        int x;
        int cnt;
        if (log.isDebugEnabled()) {
            log.debug("Enter domain/removesettings");
        }
        try {
            Collection arecords = null;
            if (this.dnsService != null && AdnsForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deleteADnsEntries") || actionPath.equalsIgnoreCase("Remove Selected As")) && AdnsForm.getRemove() != null) {
                cnt = AdnsForm.getRemove().size();
                arecords = this.dnsService.getDNSRecord(DNSType.A.getValue(), "");
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)AdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : arecords) {
                        if (t.getId() != remid.longValue()) continue;
                        this.dnsService.deleteDNSRecordsByIds(Arrays.asList(remid));
                    }
                }
            }
        }
        catch (ServiceException arecords) {
            // empty catch block
        }
        try {
            a4records2 = null;
            if (this.dnsService != null && AAdnsForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deleteA4DnsEntries") || actionPath.equalsIgnoreCase("Remove Selected A4s")) && AAdnsForm.getRemove() != null) {
                cnt = AAdnsForm.getRemove().size();
                a4records2 = this.dnsService.getDNSRecord(DNSType.AAAA.getValue(), "");
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)AAdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : a4records2) {
                        if (t.getId() != remid.longValue()) continue;
                        this.dnsService.deleteDNSRecordsByIds(Arrays.asList(remid));
                    }
                }
            }
        }
        catch (ServiceException a4records2) {
            // empty catch block
        }
        try {
            a4records2 = null;
            if (this.dnsService != null && CdnsForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deleteCNAMEDnsEntries") || actionPath.equalsIgnoreCase("Remove Selected CNAMEs")) && CdnsForm.getRemove() != null) {
                cnt = AAdnsForm.getRemove().size();
                a4records2 = this.dnsService.getDNSRecord(DNSType.CNAME.getValue(), "");
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)CdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : a4records2) {
                        if (t.getId() != remid.longValue()) continue;
                        this.dnsService.deleteDNSRecordsByIds(Arrays.asList(remid));
                    }
                }
            }
        }
        catch (ServiceException a4records3) {
            // empty catch block
        }
        try {
            a4records2 = null;
            if (this.dnsService != null && MXdnsForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deleteMXDnsEntries") || actionPath.equalsIgnoreCase("Remove Selected MXs")) && MXdnsForm.getRemove() != null) {
                cnt = MXdnsForm.getRemove().size();
                a4records2 = this.dnsService.getDNSRecord(DNSType.MX.getValue(), "");
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)MXdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : a4records2) {
                        if (t.getId() != remid.longValue()) continue;
                        this.dnsService.deleteDNSRecordsByIds(Arrays.asList(remid));
                    }
                }
            }
        }
        catch (ServiceException a4records4) {
            // empty catch block
        }
        try {
            a4records2 = null;
            if (this.dnsService != null && CertdnsForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deleteCERTDnsEntries") || actionPath.equalsIgnoreCase("Remove Selected CERTs")) && CertdnsForm.getRemove() != null) {
                cnt = CertdnsForm.getRemove().size();
                a4records2 = this.dnsService.getDNSRecord(DNSType.CERT.getValue(), "");
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)CertdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : a4records2) {
                        if (t.getId() != remid.longValue()) continue;
                        this.dnsService.deleteDNSRecordsByIds(Arrays.asList(remid));
                    }
                }
            }
        }
        catch (ServiceException a4records5) {
            // empty catch block
        }
        try {
            a4records2 = null;
            if (this.dnsService != null && SrvdnsForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deleteSRVDnsEntries") || actionPath.equalsIgnoreCase("Remove Selected SRVs")) && SrvdnsForm.getRemove() != null) {
                cnt = SrvdnsForm.getRemove().size();
                a4records2 = this.dnsService.getDNSRecord(DNSType.SRV.getValue(), "");
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)SrvdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : a4records2) {
                        if (t.getId() != remid.longValue()) continue;
                        this.dnsService.deleteDNSRecordsByIds(Arrays.asList(remid));
                    }
                }
            }
        }
        catch (ServiceException a4records6) {
            // empty catch block
        }
        try {
            Collection soarecords = null;
            if (this.dnsService != null && SoadnsForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deleteSOADnsEntries") || actionPath.equalsIgnoreCase("Remove Selected SOAs")) && SoadnsForm.getRemove() != null) {
                cnt = SoadnsForm.getRemove().size();
                soarecords = this.dnsService.getDNSRecord(DNSType.SOA.getValue(), "");
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)SoadnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : soarecords) {
                        if (t.getId() != remid.longValue()) continue;
                        this.dnsService.deleteDNSRecordsByIds(Arrays.asList(remid));
                    }
                }
            }
        }
        catch (ServiceException soarecords) {
            // empty catch block
        }
        try {
            Collection nsrecords = null;
            if (this.dnsService != null && NSdnsForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deleteNSDnsEntries") || actionPath.equalsIgnoreCase("Remove Selected NSs")) && NSdnsForm.getRemove() != null) {
                cnt = NSdnsForm.getRemove().size();
                nsrecords = this.dnsService.getDNSRecord(DNSType.NS.getValue(), "");
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)NSdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : nsrecords) {
                        if (t.getId() != remid.longValue()) continue;
                        this.dnsService.deleteDNSRecordsByIds(Arrays.asList(remid));
                    }
                }
            }
        }
        catch (ServiceException nsrecords) {
            // empty catch block
        }
        ModelAndView mav = new ModelAndView("dns");
        if (AdnsForm.getRemove() != null && log.isDebugEnabled()) {
            log.debug("the list of checkboxes checked or not is: {}", (Object)AdnsForm.getRemove().toString());
        }
        this.refreshModelFromService(model);
        model.addAttribute("dnsEntryForm", (Object)new DNSEntryForm());
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        return mav;
    }

    private Collection<DNSRecord> getDnsRecords(int type) {
        Collection arecords = null;
        try {
            arecords = this.dnsService.getDNSRecord(type, "");
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return arecords;
    }

    public void refreshModelFromService(Model model) {
        Collection arecords = null;
        arecords = this.getDnsRecords(DNSType.A.getValue());
        ArrayList<DNSEntryForm> aform = new ArrayList<DNSEntryForm>();
        if (arecords != null) {
            for (DNSRecord t : arecords) {
                try {
                    ARecord newrec = (ARecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getAddress());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    aform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsARecordResults", aform);
        Collection a4records = null;
        a4records = this.getDnsRecords(DNSType.AAAA.getValue());
        ArrayList<DNSEntryForm> a4form = new ArrayList<DNSEntryForm>();
        if (a4records != null) {
            for (DNSRecord t : a4records) {
                try {
                    AAAARecord newrec = (AAAARecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getAddress());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    a4form.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsA4RecordResults", a4form);
        Collection crecords = null;
        crecords = this.getDnsRecords(DNSType.CNAME.getValue());
        ArrayList<DNSEntryForm> cform = new ArrayList<DNSEntryForm>();
        if (crecords != null) {
            for (DNSRecord t : crecords) {
                try {
                    CNAMERecord newrec = (CNAMERecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getTarget());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    cform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsCnameRecordResults", cform);
        Collection mxrecords = null;
        mxrecords = this.getDnsRecords(DNSType.MX.getValue());
        ArrayList<DNSEntryForm> mxform = new ArrayList<DNSEntryForm>();
        if (mxrecords != null) {
            for (DNSRecord t : mxrecords) {
                try {
                    MXRecord newrec = (MXRecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setPriority(newrec.getPriority());
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getTarget());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    mxform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsMxRecordResults", mxform);
        Collection certrecords = null;
        certrecords = this.getDnsRecords(DNSType.CERT.getValue());
        ArrayList<SrvRecord> form = new ArrayList<SrvRecord>();
        if (certrecords != null) {
            for (DNSRecord t : certrecords) {
                SrvRecord srv = new SrvRecord();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(t.getCreateTime().toInstant(), t.getCreateTime().getTimeZone().toZoneId());
                srv.setCreateTime(localDateTime);
                srv.setData(t.getData());
                srv.setDclass(t.getDclass());
                srv.setId(Long.valueOf(t.getId()));
                srv.setName(t.getName());
                srv.setTtl(t.getTtl());
                srv.setType(t.getType());
                srv.setThumb("");
                try {
                    CertContainer cont;
                    CERTRecord newrec = (CERTRecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    String thumb = "";
                    byte[] certData = newrec.getCert();
                    if (certData != null && (cont = this.toCertContainer(certData)) != null && cont.getCert() != null) {
                        Certificate cert2 = new Certificate();
                        cert2.setData(certData);
                        thumb = DNSController.getThumbPrint((X509Certificate)cont.getCert());
                        srv.setThumb(thumb);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                form.add(srv);
            }
        }
        model.addAttribute("dnsCertRecordResults", form);
        Collection srvrecords = null;
        srvrecords = this.getDnsRecords(DNSType.SRV.getValue());
        ArrayList<SrvRecord> form2 = new ArrayList<SrvRecord>();
        if (srvrecords != null) {
            for (DNSRecord t : srvrecords) {
                SrvRecord srv = new SrvRecord();
                try {
                    SRVRecord srv4 = (SRVRecord)SRVRecord.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    LocalDateTime localDateTime = LocalDateTime.ofInstant(t.getCreateTime().toInstant(), t.getCreateTime().getTimeZone().toZoneId());
                    srv.setCreateTime(localDateTime);
                    srv.setData(t.getData());
                    srv.setDclass(t.getDclass());
                    srv.setId(Long.valueOf(t.getId()));
                    srv.setName(t.getName());
                    String name = t.getName();
                    int firstpos = name.indexOf("_");
                    if (firstpos == 0) {
                        int secondpos = name.indexOf("._");
                        int thirdpos = name.indexOf(".", secondpos + 2);
                        String service_ = name.substring(firstpos + 1, secondpos);
                        srv.setService(service_);
                        String protocol_ = name.substring(secondpos + 2, thirdpos);
                        srv.setProtocol(protocol_);
                        int last2pos = name.indexOf(".", thirdpos);
                        String name_ = name.substring(last2pos + 1, name.length());
                        srv.setName(name_);
                    }
                    srv.setTtl(t.getTtl());
                    srv.setType(t.getType());
                    srv.setPort(srv4.getPort());
                    srv.setWeight(srv4.getWeight());
                    srv.setPriority("" + srv4.getPriority());
                    srv.setTarget("" + srv4.getTarget().toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                form2.add(srv);
            }
        }
        model.addAttribute("dnsSrvRecordResults", form2);
        Collection soarecords = null;
        soarecords = this.getDnsRecords(DNSType.SOA.getValue());
        ArrayList<DNSEntryForm> soaform = new ArrayList<DNSEntryForm>();
        if (soarecords != null) {
            for (DNSRecord t : soarecords) {
                try {
                    SOARecord newrec = (SOARecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setAdmin("" + newrec.getAdmin());
                    tmp.setExpire(newrec.getExpire());
                    tmp.setMinimum(newrec.getMinimum());
                    tmp.setRefresh(newrec.getRefresh());
                    tmp.setRetry(newrec.getRetry());
                    tmp.setSerial(newrec.getSerial());
                    tmp.setDest("" + newrec.getHost());
                    tmp.setDomain("" + newrec.getHost());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    soaform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsSOARecordResults", soaform);
        Collection nsrecords = null;
        nsrecords = this.getDnsRecords(DNSType.NS.getValue());
        ArrayList<DNSEntryForm> nsform = new ArrayList<DNSEntryForm>();
        if (nsrecords != null) {
            for (DNSRecord t : nsrecords) {
                try {
                    NSRecord newrec = (NSRecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getTarget());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    nsform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsNSRecordResults", nsform);
        model.addAttribute("NSdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SoadnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
    }

    @ExceptionHandler(value={IOException.class})
    public String handleIOException(IOException ex, HttpServletRequest request) {
        return ClassUtils.getShortName((String)(ex.getClass() + ":" + ex.getMessage()));
    }

    public CertContainer toCertContainer(byte[] data) throws Exception {
        CertContainer certContainer = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", DNSController.getJCEProviderName());
                localKeyStore.load(bais, "".toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, "".toCharArray());
                    if (key != null && key instanceof PrivateKey) {
                        certContainer = new CertContainer(cert, key);
                    }
                }
            }
            catch (Exception localKeyStore) {
                // empty catch block
            }
            if (certContainer == null) {
                bais.reset();
                bais = new ByteArrayInputStream(data);
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
                certContainer = new CertContainer(cert, null);
            }
            bais.close();
        }
        catch (Exception e) {
            throw new ServiceException("Data cannot be converted to a valid X.509 Certificate", (Throwable)e);
        }
        return certContainer;
    }

    public static String getThumbPrint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = null;
        byte[] digest = null;
        try {
            der = cert.getEncoded();
            md.update(der);
            digest = md.digest();
        }
        catch (java.security.cert.CertificateEncodingException e) {
            e.printStackTrace();
        }
        return DNSController.hexify(digest);
    }

    public static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }
}

