/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui.form;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum DNSType {
    A(1),
    CNAME(5),
    SOA(6),
    MX(15),
    AAAA(28),
    SRV(33),
    CERT(37),
    NS(2),
    SPF(99);

    private static final Map<Integer, DNSType> lookup;
    private static final Map<String, DNSType> sLookup;
    private int value;

    private DNSType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static DNSType get(int code) {
        return (DNSType)lookup.get(code);
    }

    public static DNSType get(String value) {
        return (DNSType)sLookup.get(value);
    }

    public static List<DNSType> getAll() {
        ArrayList<DNSType> result = new ArrayList<DNSType>(lookup.values());
        return result;
    }

    static {
        lookup = new HashMap();
        sLookup = new HashMap();
        for (DNSType s : EnumSet.allOf(DNSType.class)) {
            lookup.put(s.getValue(), s);
            sLookup.put(s.toString(), s);
        }
    }
}

