/*
 * Decompiled with CFR 0.152.
 */
package org.nightcode.tools.ber;

import java.io.IOException;
import java.io.OutputStream;
import org.nightcode.tools.ber.BerBuffer;
import org.nightcode.tools.ber.BerFormatter;
import org.nightcode.tools.ber.BerUtil;

public abstract class AbstractBerFormatter
extends BerFormatter {
    protected final boolean printWithSpaces;

    protected AbstractBerFormatter() {
        this(false);
    }

    protected AbstractBerFormatter(boolean printWithSpaces) {
        this.printWithSpaces = printWithSpaces;
    }

    @Override
    byte[] lineFeed() {
        return LINE_FEED;
    }

    @Override
    byte[] linePrefix() {
        return LINE_PREFIX;
    }

    @Override
    byte[] nextPrefix(boolean node) {
        return node ? NODE_NEXT_PREFIX : LEAF_NEXT_PREFIX;
    }

    void writeToStream(OutputStream stream, byte[] buffer, int offset, int length) throws IOException {
        int size = offset + length;
        for (int i = offset; i < size; ++i) {
            stream.write((byte)BerUtil.UPPER_HEX_DIGITS[(buffer[i] & 0xF0) >> 4]);
            stream.write((byte)BerUtil.UPPER_HEX_DIGITS[buffer[i] & 0xF]);
        }
    }

    void writeToStream(OutputStream stream, BerBuffer buffer, int offset, int length) throws IOException {
        if (this.printWithSpaces) {
            this.writeToStreamWithSpaces(stream, buffer, offset, length);
        } else {
            this.writeToStreamSimple(stream, buffer, offset, length);
        }
    }

    private void writeToStreamSimple(OutputStream stream, BerBuffer buffer, int offset, int length) throws IOException {
        int size = offset + length;
        buffer.checkLimit(size);
        for (int i = offset; i < size; ++i) {
            this.writeHex(stream, buffer, i);
        }
    }

    void writeToStreamWithSpaces(OutputStream stream, BerBuffer buffer, int offset, int length) throws IOException {
        int size = offset + length;
        buffer.checkLimit(size);
        this.writeHex(stream, buffer, offset);
        for (int i = offset + 1; i < size; ++i) {
            stream.write(32);
            if ((i - offset) % 8 == 0) {
                stream.write(32);
            }
            this.writeHex(stream, buffer, i);
        }
    }

    private void writeHex(OutputStream out, BerBuffer buffer, int position) throws IOException {
        out.write((byte)BerUtil.UPPER_HEX_DIGITS[(buffer.getByte(position) & 0xF0) >> 4]);
        out.write((byte)BerUtil.UPPER_HEX_DIGITS[buffer.getByte(position) & 0xF]);
    }
}

