/*
 * Decompiled with CFR 0.152.
 */
package org.nightcode.tools.ber;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nightcode.tools.ber.BerBuffer;
import org.nightcode.tools.ber.DirectBerBuffer;
import org.nightcode.tools.ber.HeapBerBuffer;
import org.nightcode.tools.ber.UnsafeBerBuffer;
import sun.misc.Unsafe;

final class BerBufferUtil {
    private static final Logger LOGGER;
    private static final boolean HAS_UNSAFE;

    static BerBuffer create(byte[] src) {
        if (HAS_UNSAFE) {
            return new UnsafeBerBuffer(src);
        }
        return new HeapBerBuffer(src);
    }

    static BerBuffer create(ByteBuffer src) {
        if (HAS_UNSAFE) {
            return new UnsafeBerBuffer(src);
        }
        if (src.hasArray()) {
            return new HeapBerBuffer(src.array());
        }
        return new DirectBerBuffer(src);
    }

    static boolean getBoolean(String key, boolean def) {
        String value = System.getProperty(key);
        if (value == null) {
            return def;
        }
        if ("true".equals(value = value.trim().toLowerCase()) || "yes".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "0".equals(value)) {
            return false;
        }
        return def;
    }

    private BerBufferUtil() {
    }

    static {
        boolean hasUnsafe;
        LOGGER = Logger.getLogger(BerBufferUtil.class.getName());
        boolean noUnsafe = BerBufferUtil.getBoolean("org.nightcode.tools.ber.noUnsafe", false);
        LOGGER.log(Level.FINE, String.format("-Dorg.nightcode.tools.ber.noUnsafe: %s", noUnsafe));
        if (noUnsafe) {
            hasUnsafe = false;
        } else {
            Object result = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                        unsafeField.setAccessible(true);
                        Unsafe unsafe = (Unsafe)unsafeField.get(null);
                        unsafe.getClass().getDeclaredMethod("getByte", Object.class, Long.TYPE);
                        unsafe.getClass().getDeclaredMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
                        unsafe.getClass().getDeclaredMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
                        unsafe.getClass().getDeclaredMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                        return Boolean.TRUE;
                    }
                    catch (Exception ex) {
                        return Boolean.FALSE;
                    }
                }
            });
            hasUnsafe = (Boolean)result;
            LOGGER.log(Level.FINER, String.format("sun.misc.Unsafe available: %s", hasUnsafe));
        }
        HAS_UNSAFE = hasUnsafe;
    }
}

