/*
 * Decompiled with CFR 0.152.
 */
package org.nightcode.tools.ber;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.nightcode.tools.ber.BerBuffer;
import org.nightcode.tools.ber.BerBufferUtil;
import org.nightcode.tools.ber.BerFrame;
import org.nightcode.tools.ber.BerTlv;
import org.nightcode.tools.ber.BerUtil;

public final class BerBuilder {
    private int length = 0;
    private List<BerTlvContainer> containers = new ArrayList<BerTlvContainer>();

    public static BerBuilder newInstance() {
        return new BerBuilder();
    }

    private BerBuilder() {
    }

    public BerBuilder add(BerFrame berFrame) {
        for (BerTlv berTlv : berFrame.getTlvs()) {
            byte[] identifier = new byte[berTlv.identifierLength()];
            berFrame.berBuffer().getBytes(berTlv.identifierPosition(), identifier);
            byte[] content = new byte[berTlv.contentLength()];
            berFrame.berBuffer().getBytes(berTlv.contentPosition(), content);
            this.add(identifier, content);
        }
        return this;
    }

    public BerBuilder add(byte identifier, byte[] content) {
        return this.add(new byte[]{identifier}, content);
    }

    public BerBuilder add(byte b1, byte b2, byte[] content) {
        return this.add(new byte[]{b1, b2}, content);
    }

    public BerBuilder add(byte b1, byte b2, byte b3, byte[] content) {
        return this.add(new byte[]{b1, b2, b3}, content);
    }

    public BerBuilder add(byte b1, byte b2, byte b3, byte b4, byte[] content) {
        return this.add(new byte[]{b1, b2, b3, b4}, content);
    }

    public BerBuilder add(int identifier, byte[] content) {
        byte[] buffer = BerUtil.identifierToByteArray(identifier);
        return this.add(buffer, content);
    }

    public BerBuilder add(long identifier, byte[] content) {
        byte[] buffer = BerUtil.identifierToByteArray(identifier);
        return this.add(buffer, content);
    }

    public BerBuilder add(byte[] identifier, byte[] content) {
        int numberOfLengthOctets = this.calculateNumberOfLengthOctets(content.length);
        BerTlvContainerByteArray container = new BerTlvContainerByteArray(identifier, numberOfLengthOctets, content);
        this.containers.add(container);
        this.length += identifier.length + numberOfLengthOctets + content.length;
        return this;
    }

    public BerBuilder add(byte identifier, BerBuilder builder) {
        return this.add(new byte[]{identifier}, builder);
    }

    public BerBuilder add(byte b1, byte b2, BerBuilder builder) {
        return this.add(new byte[]{b1, b2}, builder);
    }

    public BerBuilder add(byte b1, byte b2, byte b3, BerBuilder builder) {
        return this.add(new byte[]{b1, b2, b3}, builder);
    }

    public BerBuilder add(byte b1, byte b2, byte b3, byte b4, BerBuilder builder) {
        return this.add(new byte[]{b1, b2, b3, b4}, builder);
    }

    public BerBuilder add(int identifier, BerBuilder builder) {
        byte[] buffer = BerUtil.identifierToByteArray(identifier);
        return this.add(buffer, builder);
    }

    public BerBuilder add(long identifier, BerBuilder builder) {
        byte[] buffer = BerUtil.identifierToByteArray(identifier);
        return this.add(buffer, builder);
    }

    public BerBuilder add(byte[] identifier, BerBuilder builder) {
        int numberOfLengthOctets = this.calculateNumberOfLengthOctets(builder.length);
        BerTlvContainerBuilder container = new BerTlvContainerBuilder(identifier, numberOfLengthOctets, builder);
        this.containers.add(container);
        this.length += identifier.length + numberOfLengthOctets + builder.length;
        return this;
    }

    public BerBuilder addAsciiString(byte identifier, String src) {
        return this.addAsciiString(new byte[]{identifier}, src);
    }

    public BerBuilder addAsciiString(byte b1, byte b2, String src) {
        return this.addAsciiString(new byte[]{b1, b2}, src);
    }

    public BerBuilder addAsciiString(byte b1, byte b2, byte b3, String src) {
        return this.addAsciiString(new byte[]{b1, b2, b3}, src);
    }

    public BerBuilder addAsciiString(byte b1, byte b2, byte b3, byte b4, String src) {
        return this.addAsciiString(new byte[]{b1, b2, b3, b4}, src);
    }

    public BerBuilder addAsciiString(int identifier, String src) {
        byte[] buffer = BerUtil.identifierToByteArray(identifier);
        return this.addAsciiString(buffer, src);
    }

    public BerBuilder addAsciiString(long identifier, String src) {
        byte[] buffer = BerUtil.identifierToByteArray(identifier);
        return this.addAsciiString(buffer, src);
    }

    public BerBuilder addAsciiString(byte[] identifier, String src) {
        return this.add(identifier, src.getBytes(BerUtil.ASCII));
    }

    public BerBuilder addHexString(byte identifier, String src) {
        return this.addHexString(new byte[]{identifier}, src);
    }

    public BerBuilder addHexString(byte b1, byte b2, String src) {
        return this.addHexString(new byte[]{b1, b2}, src);
    }

    public BerBuilder addHexString(byte b1, byte b2, byte b3, String src) {
        return this.addHexString(new byte[]{b1, b2, b3}, src);
    }

    public BerBuilder addHexString(byte b1, byte b2, byte b3, byte b4, String src) {
        return this.addHexString(new byte[]{b1, b2, b3, b4}, src);
    }

    public BerBuilder addHexString(int identifier, String src) {
        byte[] buffer = BerUtil.identifierToByteArray(identifier);
        return this.addHexString(buffer, src);
    }

    public BerBuilder addHexString(long identifier, String src) {
        byte[] buffer = BerUtil.identifierToByteArray(identifier);
        return this.addHexString(buffer, src);
    }

    public BerBuilder addHexString(byte[] identifier, String src) {
        return this.add(identifier, BerUtil.hexToByteArray(src));
    }

    public int length() {
        return this.length;
    }

    public void writeTo(byte[] dst) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(dst);
        this.writeTo(byteBuffer);
    }

    public void writeTo(ByteBuffer dstBuffer) {
        this.writeTo(dstBuffer, 0);
    }

    public void writeTo(ByteBuffer dstBuffer, int offset) {
        BerBuffer berBuffer = BerBufferUtil.create(dstBuffer);
        berBuffer.checkLimit(offset + this.length);
        this.writeTo(berBuffer, offset);
    }

    public void writeTo(OutputStream out) throws IOException {
        for (BerTlvContainer container : this.containers) {
            container.writeTo(out);
        }
    }

    private int calculateNumberOfLengthOctets(int contentLength) {
        int numberOfLengthOctets = contentLength < 128 ? 1 : (contentLength < 256 ? 2 : (contentLength < 65536 ? 3 : (contentLength < 0x1000000 ? 4 : 5)));
        return numberOfLengthOctets;
    }

    private void writeTo(BerBuffer buffer, int offset) {
        buffer.checkLimit(offset + this.length);
        int index = offset;
        for (BerTlvContainer container : this.containers) {
            index = container.writeTo(buffer, index);
        }
    }

    private static final class BerTlvContainerBuilder
    extends BerTlvContainer {
        private final byte[] identifier;
        private final int numberOfLengthOctets;
        private final BerBuilder builder;

        private BerTlvContainerBuilder(byte[] identifier, int numberOfLengthOctets, BerBuilder builder) {
            BerUtil.checkIdentifier(identifier);
            this.identifier = identifier;
            this.numberOfLengthOctets = numberOfLengthOctets;
            this.builder = builder;
        }

        @Override
        public int writeTo(BerBuffer buffer, int offset) {
            buffer.putBytes(offset, this.identifier);
            int index = offset + this.identifier.length;
            this.putLengthOctets(buffer, index, this.builder.length);
            this.builder.writeTo(buffer, index += this.numberOfLengthOctets);
            return index + this.builder.length;
        }

        @Override
        void writeTo(OutputStream out) throws IOException {
            out.write(this.identifier);
            this.putLengthOctets(out, this.builder.length);
            this.builder.writeTo(out);
        }
    }

    private static final class BerTlvContainerByteArray
    extends BerTlvContainer {
        private final byte[] identifier;
        private final int numberOfLengthOctets;
        private final byte[] content;

        private BerTlvContainerByteArray(byte[] identifier, int numberOfLengthOctets, byte[] content) {
            BerUtil.checkIdentifier(identifier);
            this.identifier = identifier;
            this.numberOfLengthOctets = numberOfLengthOctets;
            this.content = content;
        }

        @Override
        public int writeTo(BerBuffer buffer, int offset) {
            buffer.putBytes(offset, this.identifier);
            int index = offset + this.identifier.length;
            this.putLengthOctets(buffer, index, this.content.length);
            buffer.putBytes(index += this.numberOfLengthOctets, this.content);
            return index + this.content.length;
        }

        @Override
        void writeTo(OutputStream out) throws IOException {
            out.write(this.identifier);
            this.putLengthOctets(out, this.content.length);
            out.write(this.content);
        }
    }

    private static abstract class BerTlvContainer {
        private BerTlvContainer() {
        }

        void putLengthOctets(OutputStream out, int contentLength) throws IOException {
            if (contentLength < 128) {
                out.write((byte)(contentLength & 0x7F));
            } else if (contentLength < 256) {
                out.write(-127);
                out.write((byte)contentLength);
            } else if (contentLength < 65536) {
                out.write(-126);
                out.write((byte)(contentLength >>> 8));
                out.write((byte)(contentLength >>> 0));
            } else if (contentLength < 0x1000000) {
                out.write(-125);
                out.write((byte)(contentLength >>> 16));
                out.write((byte)(contentLength >>> 8));
                out.write((byte)(contentLength >>> 0));
            } else {
                out.write(-124);
                out.write((byte)(contentLength >>> 24));
                out.write((byte)(contentLength >>> 16));
                out.write((byte)(contentLength >>> 8));
                out.write((byte)(contentLength >>> 0));
            }
        }

        void putLengthOctets(BerBuffer buffer, int offset, int contentLength) {
            if (contentLength < 128) {
                buffer.putByte(offset, (byte)(contentLength & 0x7F));
            } else if (contentLength < 256) {
                buffer.putByte(offset, (byte)-127);
                buffer.putByte(offset + 1, (byte)contentLength);
            } else if (contentLength < 65536) {
                buffer.putByte(offset, (byte)-126);
                buffer.putByte(offset + 1, (byte)(contentLength >>> 8));
                buffer.putByte(offset + 2, (byte)(contentLength >>> 0));
            } else if (contentLength < 0x1000000) {
                buffer.putByte(offset, (byte)-125);
                buffer.putByte(offset + 1, (byte)(contentLength >>> 16));
                buffer.putByte(offset + 2, (byte)(contentLength >>> 8));
                buffer.putByte(offset + 3, (byte)(contentLength >>> 0));
            } else {
                buffer.putByte(offset, (byte)-124);
                buffer.putInt(offset + 1, contentLength);
            }
        }

        abstract int writeTo(BerBuffer var1, int var2);

        abstract void writeTo(OutputStream var1) throws IOException;
    }
}

