/*
 * Decompiled with CFR 0.152.
 */
package org.nightcode.tools.ber;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.nightcode.tools.ber.BerBuffer;
import org.nightcode.tools.ber.BerBufferUtil;
import org.nightcode.tools.ber.BerParser;
import org.nightcode.tools.ber.BerTlv;
import org.nightcode.tools.ber.BerUtil;

public final class BerFrame {
    private final BerBuffer buffer;
    private final int offset;
    private final int limit;
    private final List<BerTlv> tlvs;

    public static BerFrame parseFrom(byte[] src) {
        ByteBuffer buffer = ByteBuffer.wrap(src);
        return BerFrame.parseFrom(buffer, 0, src.length);
    }

    public static BerFrame parseFrom(ByteBuffer srcBuffer) {
        return BerFrame.parseFrom(srcBuffer, 0, srcBuffer.limit());
    }

    public static BerFrame parseFrom(ByteBuffer srcBuffer, int offset, int length) {
        BerBuffer berBuffer = BerBufferUtil.create(srcBuffer);
        return BerParser.parseFrom(berBuffer, offset, length);
    }

    BerFrame(BerBuffer buffer, int offset, int limit, List<BerTlv> tlvs) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit = limit;
        this.tlvs = tlvs;
    }

    public List<byte[]> getAllContents(byte identifier) {
        return this.getAllContents(BerUtil.identifierToByteArray(identifier), this.tlvs);
    }

    public List<byte[]> getAllContents(int identifier) {
        return this.getAllContents(BerUtil.identifierToByteArray(identifier), this.tlvs);
    }

    public List<byte[]> getAllContents(long identifier) {
        return this.getAllContents(BerUtil.identifierToByteArray(identifier), this.tlvs);
    }

    public List<byte[]> getAllContents(byte ... identifier) {
        if (identifier.length == 0) {
            return new ArrayList<byte[]>();
        }
        return this.getAllContents(identifier, this.tlvs);
    }

    @Nullable
    public byte[] getContent(byte identifier) {
        return this.getContent(new byte[]{identifier}, this.tlvs);
    }

    @Nullable
    public byte[] getContent(int identifier) {
        return this.getContent(BerUtil.identifierToByteArray(identifier), this.tlvs);
    }

    @Nullable
    public byte[] getContent(long identifier) {
        return this.getContent(BerUtil.identifierToByteArray(identifier), this.tlvs);
    }

    @Nullable
    public byte[] getContent(byte ... identifier) {
        if (identifier.length == 0) {
            return null;
        }
        return this.getContent(identifier, this.tlvs);
    }

    @Nullable
    public String getContentAsAsciiString(byte identifier) {
        return this.getContentAsAsciiString(new byte[]{identifier});
    }

    @Nullable
    public String getContentAsAsciiString(int identifier) {
        return this.getContentAsAsciiString(BerUtil.identifierToByteArray(identifier));
    }

    @Nullable
    public String getContentAsAsciiString(long identifier) {
        return this.getContentAsAsciiString(BerUtil.identifierToByteArray(identifier));
    }

    @Nullable
    public String getContentAsAsciiString(byte ... identifier) {
        byte[] content = this.getContent(identifier, this.tlvs);
        if (content == null) {
            return null;
        }
        return new String(content, BerUtil.ASCII);
    }

    @Nullable
    public String getContentAsHexString(byte identifier) {
        return this.getContentAsHexString(new byte[]{identifier});
    }

    @Nullable
    public String getContentAsHexString(int identifier) {
        return this.getContentAsHexString(BerUtil.identifierToByteArray(identifier));
    }

    @Nullable
    public String getContentAsHexString(long identifier) {
        return this.getContentAsHexString(BerUtil.identifierToByteArray(identifier));
    }

    @Nullable
    public String getContentAsHexString(byte ... identifier) {
        byte[] content = this.getContent(identifier, this.tlvs);
        if (content == null) {
            return null;
        }
        return BerUtil.byteArrayToHex(content);
    }

    public Iterator<byte[]> getIdentifiers() {
        return new BerTlvIterator(this);
    }

    @Nullable
    public BerFrame getTag(byte identifier) {
        return this.getTag(new byte[]{identifier}, this.tlvs);
    }

    @Nullable
    public BerFrame getTag(int identifier) {
        return this.getTag(BerUtil.identifierToByteArray(identifier), this.tlvs);
    }

    @Nullable
    public BerFrame getTag(long identifier) {
        return this.getTag(BerUtil.identifierToByteArray(identifier), this.tlvs);
    }

    @Nullable
    public BerFrame getTag(byte ... identifier) {
        return this.getTag(identifier, this.tlvs);
    }

    @Nullable
    public byte[] getTagAsByteArray(byte identifier) {
        BerFrame tag = this.getTag(new byte[]{identifier}, this.tlvs);
        if (tag == null) {
            return null;
        }
        return tag.toByteArray();
    }

    @Nullable
    public byte[] getTagAsByteArray(int identifier) {
        BerFrame tag = this.getTag(BerUtil.identifierToByteArray(identifier), this.tlvs);
        if (tag == null) {
            return null;
        }
        return tag.toByteArray();
    }

    @Nullable
    public byte[] getTagAsByteArray(long identifier) {
        BerFrame tag = this.getTag(BerUtil.identifierToByteArray(identifier), this.tlvs);
        if (tag == null) {
            return null;
        }
        return tag.toByteArray();
    }

    @Nullable
    public byte[] getTagAsByteArray(byte ... identifier) {
        BerFrame tag = this.getTag(identifier, this.tlvs);
        if (tag == null) {
            return null;
        }
        return tag.toByteArray();
    }

    public byte[] toByteArray() {
        int length = this.limit - this.offset;
        byte[] bytes = new byte[length];
        this.buffer.getBytes(this.offset, bytes);
        return bytes;
    }

    BerBuffer berBuffer() {
        return this.buffer;
    }

    List<BerTlv> getTlvs() {
        return this.tlvs;
    }

    int limit() {
        return this.limit;
    }

    int offset() {
        return this.offset;
    }

    private boolean contains(byte[] target, int position, int length) {
        if (target.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (target[i] == this.buffer.getByte(position + i)) continue;
            return false;
        }
        return true;
    }

    private List<byte[]> getAllContents(byte[] identifier, List<BerTlv> tlvs) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (BerTlv tlv : tlvs) {
            if (this.contains(identifier, tlv.identifierPosition(), tlv.identifierLength())) {
                byte[] content = new byte[tlv.contentLength()];
                this.buffer.getBytes(tlv.contentPosition(), content);
                result.add(content);
                continue;
            }
            if (!tlv.isConstructed()) continue;
            result.addAll(this.getAllContents(identifier, tlv.children()));
        }
        return result;
    }

    @Nullable
    private byte[] getContent(byte[] identifier, List<BerTlv> tlvs) {
        byte[] result = null;
        for (BerTlv tlv : tlvs) {
            if (this.contains(identifier, tlv.identifierPosition(), tlv.identifierLength())) {
                byte[] content = new byte[tlv.contentLength()];
                this.buffer.getBytes(tlv.contentPosition(), content);
                result = content;
            } else if (tlv.isConstructed()) {
                result = this.getContent(identifier, tlv.children());
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private BerFrame getTag(byte[] identifier, List<BerTlv> tlvs) {
        BerFrame result = null;
        for (BerTlv tlv : tlvs) {
            if (this.contains(identifier, tlv.identifierPosition(), tlv.identifierLength())) {
                result = new BerFrame(this.buffer, tlv.identifierPosition(), tlv.contentPosition() + tlv.contentLength(), Collections.singletonList(tlv));
            } else if (tlv.isConstructed()) {
                result = this.getTag(identifier, tlv.children());
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static final class BerTlvIterator
    implements Iterator<byte[]> {
        private final BerBuffer buffer;
        private final Iterator<BerTlv> iterator;
        private BerTlv next;
        private boolean ready = false;

        private BerTlvIterator(BerFrame source) {
            this.buffer = source.buffer;
            this.iterator = source.tlvs.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.ready || this.tryNext();
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.ready = false;
            byte[] identifier = new byte[this.next.identifierLength()];
            this.buffer.getBytes(this.next.identifierPosition(), identifier);
            return identifier;
        }

        private boolean tryNext() {
            if (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                this.ready = true;
                return true;
            }
            return false;
        }
    }
}

