/*
 * Decompiled with CFR 0.152.
 */
package org.nightcode.tools.ber;

import java.util.ArrayList;
import java.util.List;
import org.nightcode.tools.ber.BerBuffer;
import org.nightcode.tools.ber.BerFrame;
import org.nightcode.tools.ber.BerTlv;
import org.nightcode.tools.ber.DecoderException;

final class BerParser {
    private static final int MASK_CONSTRUCTED = 32;
    private static final int MASK_INDEFINITE_FORM = 128;
    private static final int MASK_DEFINITE_LONG_FORM = 128;

    static BerFrame parseFrom(BerBuffer berBuffer, int offset, int length) {
        int limit = berBuffer.checkLimit(offset + length);
        ArrayList<BerTlv> root = new ArrayList<BerTlv>();
        try {
            BerParser.getLevel(berBuffer, root, offset, limit);
        }
        catch (Exception ex) {
            int undecodedLength;
            if (root.isEmpty()) {
                undecodedLength = length;
            } else {
                BerTlv last = (BerTlv)root.get(root.size() - 1);
                undecodedLength = limit - last.contentPosition() - last.contentLength();
            }
            byte[] undecoded = new byte[undecodedLength];
            berBuffer.getBytes(limit - undecodedLength, undecoded);
            throw new DecoderException(ex, new BerFrame(berBuffer, offset, limit, root), undecoded);
        }
        return new BerFrame(berBuffer, offset, limit, root);
    }

    private static void getLevel(BerBuffer src, List<BerTlv> level, int position, int limit) {
        int index = position;
        while (index < limit) {
            index = BerParser.getBerTlv(src, index, level, limit);
        }
    }

    private static int getBerTlv(BerBuffer src, int identPosition, List<BerTlv> level, int limit) {
        int contentPos;
        boolean constructed;
        int index = identPosition;
        src.checkIndex(index);
        byte firstIdentifier = src.getByte(index++);
        boolean bl = constructed = (firstIdentifier & 0x20) == 32;
        if ((firstIdentifier & 0x1F) == 31) {
            byte b;
            do {
                src.checkIndex(index);
            } while (((b = src.getByte(index++)) & 0x80) == 128);
        }
        int identLength = index - identPosition;
        int contentLength = 0;
        src.checkIndex(index);
        int firstLength = src.getByte(index++) & 0xFF;
        if ((firstLength ^ 0x80) == 0) {
            throw new IllegalStateException("Indefinite form is not supported yet.");
        }
        if ((firstLength & 0x80) == 128) {
            int numberOfSubsequentOctets = firstLength & 0x7F;
            if (numberOfSubsequentOctets > 4) {
                throw new IllegalStateException("Illegal ber packet structure.");
            }
            contentPos = index + numberOfSubsequentOctets;
            for (int i = 0; i < numberOfSubsequentOctets; ++i) {
                src.checkIndex(index);
                contentLength = (contentLength << 8) + (src.getByte(index++) & 0xFF);
            }
        } else {
            contentPos = index;
            contentLength = firstLength;
        }
        if (contentPos + contentLength > limit) {
            throw new IndexOutOfBoundsException(String.format("content bound is beyond content limit (b=%d; l=%d)", contentPos + contentLength, limit));
        }
        BerTlv tlv = new BerTlv(identPosition, identLength, constructed, contentPos, contentLength);
        level.add(tlv);
        if (constructed) {
            BerParser.getLevel(src, tlv.children(), contentPos, contentPos + contentLength);
        }
        return index + contentLength;
    }

    private BerParser() {
    }
}

