/*
 * Decompiled with CFR 0.152.
 */
package org.nightcode.tools.ber;

import java.nio.charset.Charset;
import java.util.Objects;

final class BerUtil {
    static final Charset ASCII = Charset.forName("US-ASCII");
    static final char[] UPPER_HEX_DIGITS = "0123456789ABCDEF".toCharArray();

    static String byteArrayToHex(byte[] bytes) {
        int capacity = bytes.length << 1;
        StringBuilder builder = new StringBuilder(capacity);
        for (byte b : bytes) {
            builder.append(UPPER_HEX_DIGITS[(b & 0xF0) >> 4]);
            builder.append(UPPER_HEX_DIGITS[b & 0xF]);
        }
        return builder.toString();
    }

    static byte[] identifierToByteArray(int identifier) {
        int i = identifier ^ Integer.MIN_VALUE;
        byte[] buffer = i <= -2147483393 ? new byte[]{(byte)(identifier >>> 0)} : (i <= -2147418113 ? new byte[]{(byte)(identifier >>> 8), (byte)(identifier >>> 0)} : (i <= -2130706433 ? new byte[]{(byte)(identifier >>> 16), (byte)(identifier >>> 8), (byte)(identifier >>> 0)} : new byte[]{(byte)(identifier >>> 24), (byte)(identifier >>> 16), (byte)(identifier >>> 8), (byte)(identifier >>> 0)}));
        return buffer;
    }

    static byte[] identifierToByteArray(long identifier) {
        long l = identifier ^ Long.MIN_VALUE;
        byte[] buffer = l <= -9223372036854775553L ? new byte[]{(byte)(identifier >>> 0)} : (l <= -9223372036854710273L ? new byte[]{(byte)(identifier >>> 8), (byte)(identifier >>> 0)} : (l <= -9223372036837998593L ? new byte[]{(byte)(identifier >>> 16), (byte)(identifier >>> 8), (byte)(identifier >>> 0)} : (l <= -9223372032559808513L ? new byte[]{(byte)(identifier >>> 24), (byte)(identifier >>> 16), (byte)(identifier >>> 8), (byte)(identifier >>> 0)} : (l <= -9223370937343148033L ? new byte[]{(byte)(identifier >>> 32), (byte)(identifier >>> 24), (byte)(identifier >>> 16), (byte)(identifier >>> 8), (byte)(identifier >>> 0)} : (l <= -9223090561878065153L ? new byte[]{(byte)(identifier >>> 40), (byte)(identifier >>> 32), (byte)(identifier >>> 24), (byte)(identifier >>> 16), (byte)(identifier >>> 8), (byte)(identifier >>> 0)} : (l <= -9151314442816847873L ? new byte[]{(byte)(identifier >>> 48), (byte)(identifier >>> 40), (byte)(identifier >>> 32), (byte)(identifier >>> 24), (byte)(identifier >>> 16), (byte)(identifier >>> 8), (byte)(identifier >>> 0)} : new byte[]{(byte)(identifier >>> 56), (byte)(identifier >>> 48), (byte)(identifier >>> 40), (byte)(identifier >>> 32), (byte)(identifier >>> 24), (byte)(identifier >>> 16), (byte)(identifier >>> 8), (byte)(identifier >>> 0)}))))));
        return buffer;
    }

    static byte[] hexToByteArray(String hex) {
        Objects.requireNonNull(hex, "hexadecimal string");
        int length = hex.length();
        if ((length & 1) != 0) {
            throw new IllegalStateException(String.format("hexadecimal string <%s> must have an even number of characters.", hex));
        }
        byte[] result = new byte[length >> 1];
        for (int i = 0; i < length; i += 2) {
            int hn = Character.digit(hex.charAt(i), 16);
            int ln = Character.digit(hex.charAt(i + 1), 16);
            result[i >> 1] = (byte)(hn << 4 | ln);
        }
        return result;
    }

    static void checkIdentifier(byte[] identifier) {
        if ((identifier[0] & 0x1F) != 31 && identifier.length > 1) {
            throw new IllegalStateException("Wrong identifier leading octet value: 0x" + Integer.toHexString(identifier[0] & 0xFF));
        }
    }

    private BerUtil() {
        throw new AssertionError((Object)"Utility class");
    }
}

