/*
 * Decompiled with CFR 0.152.
 */
package org.nightcode.tools.ber;

import java.nio.ByteBuffer;
import javax.annotation.CheckReturnValue;
import javax.annotation.meta.When;
import org.nightcode.tools.ber.BerBuffer;

final class DirectBerBuffer
implements BerBuffer {
    private final ByteBuffer buffer;
    private final int capacity;

    DirectBerBuffer(ByteBuffer src) {
        this.buffer = src;
        this.capacity = src.capacity();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    @CheckReturnValue(when=When.NEVER)
    public int checkIndex(int index) {
        if (index >= this.capacity) {
            throw new IndexOutOfBoundsException(String.format("index is beyond bound (i=%d; b=%d)", index, this.capacity - 1));
        }
        return index;
    }

    @Override
    @CheckReturnValue(when=When.NEVER)
    public int checkLimit(int limit) {
        if (limit > this.capacity) {
            throw new IndexOutOfBoundsException(String.format("limit is beyond capacity (l=%d; c=%d)", limit, this.capacity));
        }
        return limit;
    }

    @Override
    public ByteBuffer duplicateByteBuffer() {
        return this.buffer.duplicate();
    }

    @Override
    public byte getByte(int index) {
        return this.buffer.get(index);
    }

    @Override
    public int getBytes(int index, byte[] dst) {
        return this.getBytes(index, dst, 0, dst.length);
    }

    @Override
    public int getBytes(int index, byte[] dst, int offset, int length) {
        int count = Math.min(length, this.capacity - index);
        this.buffer.position(index);
        this.buffer.get(dst, offset, count);
        return count;
    }

    @Override
    public int getBytes(int index, ByteBuffer dstBuffer, int length) {
        int count = Math.min(dstBuffer.remaining(), this.capacity - index);
        count = Math.min(count, length);
        this.buffer.position(index);
        this.buffer.limit(index + count);
        dstBuffer.put(this.buffer.slice());
        return count;
    }

    @Override
    public void putByte(int index, byte value) {
        this.buffer.put(index, value);
    }

    @Override
    public int putBytes(int index, byte[] src) {
        return this.putBytes(index, src, 0, src.length);
    }

    @Override
    public int putBytes(int index, byte[] src, int offset, int length) {
        int count = Math.min(length, this.capacity - index);
        this.buffer.position(index);
        this.buffer.put(src, offset, count);
        return count;
    }

    @Override
    public int putBytes(int index, ByteBuffer srcBuffer, int length) {
        int count = Math.min(srcBuffer.remaining(), this.capacity - index);
        count = Math.min(count, length);
        ByteBuffer src = srcBuffer.duplicate();
        src.limit(length);
        this.buffer.position(index);
        this.buffer.put(src.slice());
        srcBuffer.position(srcBuffer.position() + count);
        return count;
    }

    @Override
    public void putInt(int index, int value) {
        this.buffer.putInt(index, value);
    }
}

