/*
 * Decompiled with CFR 0.152.
 */
package org.nightcode.tools.ber;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.nightcode.tools.ber.AbstractBerFormatter;
import org.nightcode.tools.ber.BerBuffer;
import org.nightcode.tools.ber.BerTlv;
import org.nightcode.tools.ber.BerUtil;

public final class EmvBerFormatter
extends AbstractBerFormatter {
    private final Map<String, String> tags = new HashMap<String, String>();

    public static EmvBerFormatter newInstance() throws IOException {
        return new EmvBerFormatter(false);
    }

    public static EmvBerFormatter newInstanceWithSpaces() throws IOException {
        return new EmvBerFormatter(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmvBerFormatter(boolean printWithSpaces) throws IOException {
        super(printWithSpaces);
        String resourceName = System.getProperty("emv.tags");
        try (InputStream in = null;){
            in = resourceName != null ? new FileInputStream(resourceName) : EmvBerFormatter.class.getResourceAsStream("/emv.tags");
            try (LineNumberReader lnr = new LineNumberReader(new InputStreamReader(in, StandardCharsets.UTF_8.displayName()));){
                while (lnr.readLine() != null) {
                    String tag = this.normalize(lnr.readLine());
                    if (tag == null) continue;
                    String name = this.normalize(lnr.readLine());
                    this.tags.put(tag, name);
                }
            }
        }
    }

    @Override
    public void format(OutputStream stream, BerBuffer buffer, BerTlv tlv, byte[] prefix, int prefixLength, boolean node) throws IOException {
        int contentLength;
        stream.write(prefix, 0, prefixLength);
        stream.write(node ? NODE_PREFIX : LEAF_PREFIX);
        byte[] identifier = new byte[tlv.identifierLength()];
        buffer.getBytes(tlv.identifierPosition(), identifier);
        stream.write(91);
        this.writeToStream(stream, identifier, 0, identifier.length);
        stream.write(93);
        String tag = BerUtil.byteArrayToHex(identifier);
        if (this.tags.containsKey(tag)) {
            stream.write(32);
            stream.write(this.tags.get(tag).getBytes(StandardCharsets.UTF_8));
        }
        if ((contentLength = tlv.contentLength()) > 0) {
            if (this.printWithSpaces) {
                int contentPosition = tlv.contentPosition();
                int limit = contentPosition + contentLength;
                for (int i = contentPosition; i < limit; i += 16) {
                    stream.write(this.lineFeed());
                    this.printContent(stream, buffer, tlv, prefix, prefixLength, node, i, Math.min(16, limit - i));
                }
            } else {
                stream.write(this.lineFeed());
                this.printContent(stream, buffer, tlv, prefix, prefixLength, node, tlv.contentPosition(), contentLength);
            }
        }
    }

    private String normalize(String str) {
        return str != null ? str.trim() : null;
    }

    private void printContent(OutputStream stream, BerBuffer buffer, BerTlv tlv, byte[] prefix, int prefixLength, boolean node, int contentPosition, int contentLength) throws IOException {
        stream.write(prefix, 0, prefixLength);
        stream.write(node ? NODE_NEXT_PREFIX : LEAF_NEXT_PREFIX);
        if (tlv.isConstructed()) {
            stream.write(LIGHT_VERTICAL);
        }
        stream.write(32);
        this.writeToStream(stream, buffer, contentPosition, contentLength);
    }
}

