/*
 * Decompiled with CFR 0.152.
 */
package org.nightcode.tools.ber;

import java.nio.ByteBuffer;
import javax.annotation.CheckReturnValue;
import javax.annotation.meta.When;
import org.nightcode.tools.ber.BerBuffer;

final class HeapBerBuffer
implements BerBuffer {
    private final byte[] array;
    private final int capacity;

    static byte[] intTobByteArray(int src) {
        byte[] buffer = new byte[]{(byte)(src >>> 24), (byte)(src >>> 16), (byte)(src >>> 8), (byte)(src >>> 0)};
        return buffer;
    }

    HeapBerBuffer(byte[] src) {
        this.array = src;
        this.capacity = this.array.length;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    @CheckReturnValue(when=When.NEVER)
    public int checkIndex(int index) {
        if (index >= this.capacity) {
            throw new IndexOutOfBoundsException(String.format("index is beyond bound (i=%d; b=%d)", index, this.capacity - 1));
        }
        return index;
    }

    @Override
    @CheckReturnValue(when=When.NEVER)
    public int checkLimit(int limit) {
        if (limit > this.capacity) {
            throw new IndexOutOfBoundsException(String.format("limit is beyond capacity (l=%d; c=%d)", limit, this.capacity));
        }
        return limit;
    }

    @Override
    public ByteBuffer duplicateByteBuffer() {
        return ByteBuffer.wrap(this.array);
    }

    @Override
    public byte getByte(int index) {
        return this.array[index];
    }

    @Override
    public int getBytes(int index, byte[] dst) {
        return this.getBytes(index, dst, 0, dst.length);
    }

    @Override
    public int getBytes(int index, byte[] dst, int offset, int length) {
        int count = Math.min(length, this.capacity - index);
        System.arraycopy(this.array, index, dst, offset, length);
        return count;
    }

    @Override
    public int getBytes(int index, ByteBuffer dstBuffer, int length) {
        int count = Math.min(dstBuffer.remaining(), this.capacity - index);
        count = Math.min(count, length);
        dstBuffer.put(this.array, index, count);
        return count;
    }

    @Override
    public void putByte(int index, byte value) {
        this.array[index] = value;
    }

    @Override
    public int putBytes(int index, byte[] src) {
        return this.putBytes(index, src, 0, src.length);
    }

    @Override
    public int putBytes(int index, byte[] src, int offset, int length) {
        int count = Math.min(length, this.capacity - index);
        System.arraycopy(src, offset, this.array, index, count);
        return count;
    }

    @Override
    public int putBytes(int index, ByteBuffer srcBuffer, int length) {
        int count = Math.min(srcBuffer.remaining(), this.capacity - index);
        count = Math.min(count, length);
        srcBuffer.get(this.array, index, count);
        return count;
    }

    @Override
    public void putInt(int index, int value) {
        byte[] src = HeapBerBuffer.intTobByteArray(value);
        System.arraycopy(src, 0, this.array, index, 4);
    }
}

