/*
 * Decompiled with CFR 0.152.
 */
package org.nightcode.tools.ber;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.nightcode.tools.ber.BerBuffer;
import org.nightcode.tools.ber.BerFormatter;
import org.nightcode.tools.ber.BerFrame;
import org.nightcode.tools.ber.BerPrinter;
import org.nightcode.tools.ber.BerTlv;
import org.nightcode.tools.ber.DefaultBerFormatter;

public class StreamBerPrinter
implements BerPrinter {
    private final OutputStream stream;
    private final BerFormatter formatter;
    private byte[] tmpBuffer;

    public StreamBerPrinter(OutputStream stream) {
        this(stream, new DefaultBerFormatter());
    }

    public StreamBerPrinter(OutputStream stream, BerFormatter formatter) {
        this.stream = stream;
        this.formatter = formatter;
        this.tmpBuffer = new byte[1024];
    }

    @Override
    public void print(BerFrame berFrame) throws IOException {
        BerBuffer buffer = berFrame.berBuffer();
        this.printImpl(buffer, berFrame.getTlvs(), this.formatter.linePrefix(), this.formatter.linePrefix().length);
        this.stream.flush();
    }

    private void printImpl(BerBuffer berBuffer, List<BerTlv> tlvs, byte[] prefix, int prefixLength) throws IOException {
        Iterator<BerTlv> i = tlvs.iterator();
        if (i.hasNext()) {
            BerTlv tlv = i.next();
            this.printTlv(berBuffer, tlv, prefix, prefixLength, i.hasNext());
        }
        this.printLevel(berBuffer, i, prefix, prefixLength);
    }

    private void printLevel(BerBuffer berBuffer, Iterator<BerTlv> i, byte[] prefix, int prefixLength) throws IOException {
        while (i.hasNext()) {
            this.stream.write(this.formatter.lineFeed());
            BerTlv tlv = i.next();
            this.printTlv(berBuffer, tlv, prefix, prefixLength, i.hasNext());
        }
    }

    private void printTlv(BerBuffer berBuffer, BerTlv tlv, byte[] prefix, int prefixLength, boolean node) throws IOException {
        this.formatter.format(this.stream, berBuffer, tlv, prefix, prefixLength, node);
        if (tlv.isConstructed()) {
            byte[] addPrefix = this.formatter.nextPrefix(node);
            if (this.tmpBuffer.length < prefixLength + addPrefix.length) {
                this.tmpBuffer = new byte[this.tmpBuffer.length << 1];
            }
            System.arraycopy(prefix, 0, this.tmpBuffer, 0, prefixLength);
            System.arraycopy(addPrefix, 0, this.tmpBuffer, prefixLength, addPrefix.length);
            this.printLevel(berBuffer, tlv.children().iterator(), this.tmpBuffer, prefixLength + addPrefix.length);
        }
    }
}

