/*
 * Decompiled with CFR 0.152.
 */
package org.nightcode.tools.ber;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.nightcode.tools.ber.BerBuffer;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

final class UnsafeBerBuffer
implements BerBuffer {
    private static final Unsafe UNSAFE;
    private static final ByteOrder NATIVE_BYTE_ORDER;
    private static final long BYTE_ARRAY_OFFSET;
    private final byte[] array;
    private final ByteBuffer buffer;
    private final long addressOffset;
    private final int capacity;

    UnsafeBerBuffer(byte[] src) {
        this.addressOffset = BYTE_ARRAY_OFFSET;
        this.array = src;
        this.buffer = null;
        this.capacity = this.array.length;
    }

    UnsafeBerBuffer(ByteBuffer src) {
        if (src.hasArray()) {
            this.addressOffset = BYTE_ARRAY_OFFSET + (long)src.arrayOffset();
            this.array = src.array();
        } else {
            this.addressOffset = ((DirectBuffer)((Object)src)).address();
            this.array = null;
        }
        this.buffer = src;
        this.capacity = src.capacity();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int checkIndex(int index) {
        if (index >= this.capacity) {
            throw new IndexOutOfBoundsException(String.format("index is beyond bound (i=%d; b=%d)", index, this.capacity - 1));
        }
        return index;
    }

    @Override
    public int checkLimit(int limit) {
        if (limit > this.capacity) {
            throw new IndexOutOfBoundsException(String.format("limit is beyond capacity (l=%d; c=%d)", limit, this.capacity));
        }
        return limit;
    }

    @Override
    public ByteBuffer duplicateByteBuffer() {
        return this.buffer != null ? this.buffer.duplicate() : ByteBuffer.wrap(this.array);
    }

    @Override
    public byte getByte(int index) {
        return UNSAFE.getByte(this.array, this.addressOffset + (long)index);
    }

    @Override
    public int getBytes(int index, byte[] dst) {
        return this.getBytes(index, dst, 0, dst.length);
    }

    @Override
    public int getBytes(int index, byte[] dst, int offset, int length) {
        int count = Math.min(length, this.capacity - index);
        UNSAFE.copyMemory(this.array, this.addressOffset + (long)index, dst, BYTE_ARRAY_OFFSET + (long)offset, count);
        return count;
    }

    @Override
    public int getBytes(int index, ByteBuffer dstBuffer, int length) {
        long dstOffset;
        byte[] dstArray;
        int count = Math.min(dstBuffer.remaining(), this.capacity - index);
        count = Math.min(count, length);
        if (dstBuffer.hasArray()) {
            dstArray = dstBuffer.array();
            dstOffset = BYTE_ARRAY_OFFSET + (long)dstBuffer.arrayOffset();
        } else {
            dstArray = null;
            dstOffset = ((DirectBuffer)((Object)dstBuffer)).address();
        }
        UNSAFE.copyMemory(this.array, this.addressOffset + (long)index, dstArray, dstOffset + (long)dstBuffer.position(), count);
        dstBuffer.position(dstBuffer.position() + count);
        return count;
    }

    @Override
    public void putByte(int index, byte value) {
        UNSAFE.putByte(this.array, this.addressOffset + (long)index, value);
    }

    @Override
    public int putBytes(int index, byte[] src) {
        return this.putBytes(index, src, 0, src.length);
    }

    @Override
    public int putBytes(int index, byte[] src, int offset, int length) {
        int count = Math.min(length, this.capacity - index);
        UNSAFE.copyMemory(src, BYTE_ARRAY_OFFSET + (long)offset, this.array, this.addressOffset + (long)index, count);
        return count;
    }

    @Override
    public int putBytes(int index, ByteBuffer srcBuffer, int length) {
        long srcOffset;
        byte[] srcArray;
        int count = Math.min(srcBuffer.remaining(), this.capacity - index);
        count = Math.min(count, length);
        if (srcBuffer.hasArray()) {
            srcArray = srcBuffer.array();
            srcOffset = BYTE_ARRAY_OFFSET + (long)srcBuffer.arrayOffset();
        } else {
            srcArray = null;
            srcOffset = ((DirectBuffer)((Object)srcBuffer)).address();
        }
        UNSAFE.copyMemory(srcArray, srcOffset + (long)srcBuffer.position(), this.array, this.addressOffset + (long)index, count);
        srcBuffer.position(srcBuffer.position() + count);
        return count;
    }

    @Override
    public void putInt(int index, int value) {
        int ordered = value;
        if (NATIVE_BYTE_ORDER == ByteOrder.LITTLE_ENDIAN) {
            ordered = Integer.reverseBytes(value);
        }
        UNSAFE.putInt(this.array, this.addressOffset + (long)index, ordered);
    }

    static {
        NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
        try {
            PrivilegedExceptionAction<Unsafe> action = new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Field field = Unsafe.class.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    return (Unsafe)field.get(null);
                }
            };
            UNSAFE = AccessController.doPrivileged(action);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    }
}

