/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.exceptions;

import org.nineml.coffeegrinder.exceptions.GrammarException;
import org.nineml.coffeegrinder.exceptions.MessageGenerator;

public class CompilerException
extends GrammarException {
    public CompilerException(String code, String message) {
        super(code, message);
    }

    public CompilerException(String code, String message, Throwable cause) {
        super(code, message, cause);
    }

    private static CompilerException getException(String code) {
        return CompilerException.getException(code, new String[0]);
    }

    private static CompilerException getException(String code, String param) {
        return CompilerException.getException(code, new String[]{param});
    }

    private static CompilerException getException(String code, String param1, String param2) {
        return CompilerException.getException(code, new String[]{param1, param2});
    }

    private static CompilerException getException(String code, String[] params) {
        return new CompilerException(code, MessageGenerator.getMessage(code, params));
    }

    public static CompilerException messageDigestError(String hash, String reason) {
        return CompilerException.getException("C001", hash, reason);
    }

    public static CompilerException unexpectedCharacterSet(String charset) {
        return CompilerException.getException("C002", charset);
    }

    public static CompilerException unexpectedTerminalTokenClass(String tokenClass) {
        return CompilerException.getException("C003", tokenClass);
    }

    public static CompilerException invalidNameEscaping(String escape, String name) {
        return CompilerException.getException("C004", escape, name);
    }

    public static CompilerException errorReadingGrammar(String message) {
        return CompilerException.getException("C005", message);
    }

    public static CompilerException notAGrammar(String namespace) {
        return CompilerException.getException("C006", namespace);
    }

    public static CompilerException unexpectedElement(String name) {
        return CompilerException.getException("C007", name);
    }

    public static CompilerException noVersionProvided() {
        return CompilerException.getException("C008");
    }

    public static CompilerException unsupportedVersion(String version) {
        return CompilerException.getException("C009", version);
    }

    public static CompilerException checkumFailed() {
        return CompilerException.getException("C010");
    }

    public static CompilerException missingXmlId(String name) {
        return CompilerException.getException("C011", name);
    }

    public static CompilerException missingAttributeGroup(String id) {
        return CompilerException.getException("C012", id);
    }

    public static CompilerException unexpectedFlag(String flag) {
        return CompilerException.getException("C013", flag);
    }

    public static CompilerException invalidGramamr(String message) {
        return CompilerException.getException("C014", message);
    }

    public static CompilerException textNotAllowed(String text) {
        return CompilerException.getException("C015", text);
    }
}

