/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.exceptions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageGenerator {
    private static final Map<String, String> messageCodes;
    private static final Map<String, String> englishCodes;

    private static Map<String, String> getMessageCodes(String language) {
        Pattern errmsg = Pattern.compile("^([A-Za-z0-9]+):\\s*(.*)$");
        HashMap<String, String> messages = new HashMap<String, String>();
        String name = "/org/nineml/coffeegrinder/" + language + "_messages.txt";
        InputStream stream = MessageGenerator.class.getResourceAsStream(name);
        if (stream != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                String line = reader.readLine();
                while (line != null) {
                    Matcher match = errmsg.matcher(line);
                    if (match.matches()) {
                        messages.put(match.group(1), match.group(2));
                    }
                    line = reader.readLine();
                }
                reader.close();
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return messages;
    }

    protected static String getMessage(String code) {
        return MessageGenerator.getMessage(code, null);
    }

    protected static String getMessage(String code, String[] params) {
        String message = messageCodes.containsKey(code) ? messageCodes.get(code) : (String)englishCodes.getOrDefault(code, null);
        if (message == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unknown error: ").append(code);
            for (String param : params) {
                sb.append(": ").append(param);
            }
            message = sb.toString();
        } else if (params != null) {
            int pnum = 1;
            for (String param : params) {
                String subst = "%" + pnum;
                param = param.replaceAll("\\$", "\\\\\\$");
                message = message.replaceAll(subst, param);
                ++pnum;
            }
        }
        return message;
    }

    static {
        Locale locale = Locale.getDefault();
        messageCodes = MessageGenerator.getMessageCodes(locale.getLanguage());
        englishCodes = "en".equals(locale.getLanguage()) ? messageCodes : MessageGenerator.getMessageCodes(locale.getLanguage());
    }
}

