/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.gll;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.nineml.coffeegrinder.gll.BinarySubtreeNode;
import org.nineml.coffeegrinder.gll.BinarySubtreePrefix;
import org.nineml.coffeegrinder.gll.BinarySubtreeSlot;
import org.nineml.coffeegrinder.parser.ForestNodeGLL;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.ParseForest;
import org.nineml.coffeegrinder.parser.ParseForestGLL;
import org.nineml.coffeegrinder.parser.ParserGrammar;
import org.nineml.coffeegrinder.parser.ParserOptions;
import org.nineml.coffeegrinder.parser.State;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.util.StopWatch;

public class BinarySubtree {
    public static final String logcategory = "GllParser";
    public final HashMap<Integer, HashSet<BinarySubtreePrefix>> bsrPrefixes = new HashMap();
    public final HashMap<Integer, HashSet<BinarySubtreeSlot>> bsrSlots = new HashMap();
    protected final HashMap<Integer, String> regexMatches = new HashMap();
    private final ParserOptions options;
    private ArrayList<BinarySubtreeSlot> roots = null;
    public final NonterminalSymbol seed;
    private int rightExtent = 0;
    private boolean ambiguous = false;

    public BinarySubtree(NonterminalSymbol seed, ParserOptions options) {
        this.options = options;
        this.seed = seed;
        this.rightExtent = 0;
    }

    protected void addEpsilon(State slot, int k) {
        BinarySubtreeSlot bsrnode = new BinarySubtreeSlot(slot, k, k, k);
        this.addSlot(bsrnode);
    }

    public void add(State L, int left, int pivot, int right) {
        if (right > this.rightExtent) {
            this.rightExtent = right;
        }
        if (L.nextSymbol() == null) {
            BinarySubtreeSlot bsrentry = new BinarySubtreeSlot(L, left, pivot, right);
            this.addSlot(bsrentry);
        } else if (L.position > 1) {
            BinarySubtreePrefix bsrentry = new BinarySubtreePrefix(L, left, pivot, right);
            this.addPrefix(bsrentry);
        }
    }

    private void addSlot(BinarySubtreeSlot node) {
        if (!this.bsrSlots.containsKey(node.leftExtent)) {
            this.bsrSlots.put(node.leftExtent, new HashSet());
        }
        assert (node.slot.symbol != null);
        if (!this.ambiguous) {
            for (BinarySubtreeSlot slot : this.bsrSlots.get(node.leftExtent)) {
                if (!node.slot.symbol.equals(slot.slot.symbol) || node.rightExtent != slot.rightExtent) continue;
                this.ambiguous = true;
                break;
            }
        }
        this.bsrSlots.get(node.leftExtent).add(node);
    }

    private void addPrefix(BinarySubtreePrefix node) {
        if (!this.bsrPrefixes.containsKey(node.leftExtent)) {
            this.bsrPrefixes.put(node.leftExtent, new HashSet());
        }
        this.bsrPrefixes.get(node.leftExtent).add(node);
    }

    public int getRightExtent() {
        return this.rightExtent;
    }

    protected boolean succeeded(boolean moreInput) {
        if (this.roots != null) {
            return !this.roots.isEmpty();
        }
        if (moreInput) {
            this.roots = new ArrayList();
            return false;
        }
        return !this.getRoots().isEmpty();
    }

    private List<BinarySubtreeSlot> getRoots() {
        if (this.roots != null) {
            return this.roots;
        }
        this.roots = new ArrayList();
        if (this.bsrSlots.containsKey(0)) {
            for (BinarySubtreeSlot node : this.bsrSlots.get(0)) {
                assert (node.slot.symbol != null);
                if (!node.slot.symbol.equals(this.seed) || node.rightExtent != this.rightExtent) continue;
                this.roots.add(node);
            }
        }
        return this.roots;
    }

    protected ParseForest extractSPPF(ParserGrammar grammar, Token[] inputTokens) {
        ParseForestGLL G = new ParseForestGLL(this.options, grammar, this.rightExtent, inputTokens, this.regexMatches);
        int n = this.rightExtent;
        if (this.getRoots().isEmpty()) {
            return G;
        }
        StopWatch timer = new StopWatch();
        this.options.getLogger().debug(logcategory, "Constructing parse forest", new Object[0]);
        BinarySubtreeNode success = this.getRoots().get(0);
        G.findOrCreate(success.slot, success.slot.symbol, 0, n);
        ForestNodeGLL w = G.extendableLeaf();
        while (w != null) {
            if (w.symbol != null) {
                for (BinarySubtreeNode binarySubtreeNode : this.bsrSlots.get(w.leftExtent)) {
                    if (binarySubtreeNode.rightExtent != w.rightExtent || !w.symbol.equals(binarySubtreeNode.slot.symbol)) continue;
                    w.addEdge(G.mkPN(binarySubtreeNode.slot, binarySubtreeNode.leftExtent, binarySubtreeNode.pivot, binarySubtreeNode.rightExtent));
                }
            } else {
                State u = w.state;
                assert (u != null);
                if (u.position == 1) {
                    w.addEdge(G.mkPN(u, w.leftExtent, w.leftExtent, w.rightExtent));
                } else {
                    for (BinarySubtreePrefix pnode : this.bsrPrefixes.get(w.leftExtent)) {
                        if (pnode.rightExtent != w.rightExtent || !pnode.matches(w)) continue;
                        w.addEdge(G.mkPN(u, pnode.leftExtent, pnode.pivot, pnode.rightExtent));
                    }
                    for (BinarySubtreePrefix pnode : this.bsrPrefixes.get(w.leftExtent)) {
                        if (pnode.rightExtent != w.rightExtent || !pnode.matches(w)) continue;
                        w.addEdge(G.mkPN(u, pnode.leftExtent, pnode.pivot, pnode.rightExtent));
                    }
                }
            }
            w = G.extendableLeaf();
        }
        timer.stop();
        this.options.getLogger().debug(logcategory, "Constructed forest in %dms", timer.duration());
        G.prune();
        return G;
    }
}

