/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.gll;

import java.util.Arrays;
import org.nineml.coffeegrinder.gll.BinarySubtreeNode;
import org.nineml.coffeegrinder.parser.ForestNodeGLL;
import org.nineml.coffeegrinder.parser.State;
import org.nineml.coffeegrinder.parser.Symbol;

public class BinarySubtreePrefix
extends BinarySubtreeNode {
    protected BinarySubtreePrefix(State slot, int left, int pivot, int right) {
        super(slot, left, pivot, right);
    }

    protected boolean matches(ForestNodeGLL fslot) {
        assert (fslot.state != null);
        if (this.slot.position != fslot.state.position) {
            return false;
        }
        for (int pos = 0; pos < this.slot.position; ++pos) {
            if (this.slot.rhs.get(pos).equals(fslot.state.rhs.get(pos))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BinarySubtreePrefix) {
            BinarySubtreePrefix other = (BinarySubtreePrefix)obj;
            if (this.leftExtent != other.leftExtent || this.rightExtent != other.rightExtent || this.pivot != other.pivot || this.slot.position != other.slot.position) {
                return false;
            }
            return this.slot.rhs.equals(other.slot.rhs);
        }
        return false;
    }

    public int hashCode() {
        Object[] prefix = new Symbol[this.slot.position];
        System.arraycopy(this.slot.rhs.symbols, 0, prefix, 0, this.slot.position);
        int code = Arrays.hashCode(prefix);
        return code + 11 * this.leftExtent + 13 * this.pivot + 31 * this.rightExtent;
    }
}

