/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.gll;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.nineml.coffeegrinder.gll.BinarySubtree;
import org.nineml.coffeegrinder.gll.ClusterNode;
import org.nineml.coffeegrinder.gll.CrfNode;
import org.nineml.coffeegrinder.gll.Descriptor;
import org.nineml.coffeegrinder.gll.GllResult;
import org.nineml.coffeegrinder.gll.MBsrAdd;
import org.nineml.coffeegrinder.gll.MCall;
import org.nineml.coffeegrinder.gll.MFollow;
import org.nineml.coffeegrinder.gll.MGoto;
import org.nineml.coffeegrinder.gll.MIncrementCI;
import org.nineml.coffeegrinder.gll.MLabel;
import org.nineml.coffeegrinder.gll.MNextDescriptor;
import org.nineml.coffeegrinder.gll.MStatement;
import org.nineml.coffeegrinder.gll.MTestSelect;
import org.nineml.coffeegrinder.gll.PoppedNode;
import org.nineml.coffeegrinder.parser.GearleyParser;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.ParserGrammar;
import org.nineml.coffeegrinder.parser.ParserOptions;
import org.nineml.coffeegrinder.parser.ParserType;
import org.nineml.coffeegrinder.parser.ProgressMonitor;
import org.nineml.coffeegrinder.parser.Rule;
import org.nineml.coffeegrinder.parser.State;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.parser.TerminalSymbol;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.tokens.TokenCharacter;
import org.nineml.coffeegrinder.tokens.TokenEOF;
import org.nineml.coffeegrinder.tokens.TokenRegex;
import org.nineml.coffeegrinder.util.StopWatch;
import org.nineml.logging.Logger;

public class GllParser
implements GearleyParser {
    public static final String logcategory = "Parser";
    public static final String gllexecution = "GLLExecution";
    public final ParserGrammar grammar;
    private final ArrayList<State> grammarSlots;
    private final HashMap<Rule, List<State>> ruleSlots;
    private Token[] I;
    protected int c_U;
    protected int c_I;
    private HashSet<Descriptor> U;
    private ArrayList<Descriptor> R;
    private HashSet<PoppedNode> P;
    private HashMap<ClusterNode, ArrayList<CrfNode>> crf;
    private HashMap<State, HashMap<Integer, CrfNode>> crfNodes;
    private BinarySubtree bsr;
    private HashMap<NonterminalSymbol, HashMap<Integer, ClusterNode>> clusterNodes;
    private ArrayList<MStatement> compileStatements = null;
    private int instructionPointer = -1;
    private int nextInstruction = -1;
    private boolean moreInput = false;
    private boolean done = false;
    private ParserOptions options = null;
    protected Logger logger = null;
    private int progressSize = 0;
    private int progressCount = 0;
    private int highwater = 0;
    int offset = -1;
    private int lineNumber = -1;
    private int columnNumber = -1;
    protected int tokenCount;
    protected Token lastToken;

    public GllParser(ParserGrammar grammar, ParserOptions options) {
        this.grammar = grammar;
        this.options = options;
        this.logger = options.getLogger();
        this.grammarSlots = new ArrayList();
        this.ruleSlots = new HashMap();
        NonterminalSymbol seed = grammar.getSeed();
        for (Rule rule : grammar.getRulesForSymbol(seed)) {
            List<State> slots = rule.getSlots();
            this.grammarSlots.addAll(slots);
            this.ruleSlots.put(rule, slots);
        }
        for (NonterminalSymbol symbol : grammar.getSymbols()) {
            if (symbol.equals(seed)) continue;
            for (Rule rule : grammar.getRulesForSymbol(symbol)) {
                List<State> slots = rule.getSlots();
                this.grammarSlots.addAll(slots);
                this.ruleSlots.put(rule, slots);
            }
        }
    }

    @Override
    public ParserType getParserType() {
        return ParserType.GLL;
    }

    @Override
    public ParserGrammar getGrammar() {
        return this.grammar;
    }

    public Token[] getTokens() {
        return this.I;
    }

    @Override
    public NonterminalSymbol getSeed() {
        return this.grammar.getSeed();
    }

    @Override
    public GllResult parse(String input) {
        int[] codepoints = input.codePoints().toArray();
        this.I = new Token[codepoints.length + 1];
        for (int pos = 0; pos < codepoints.length; ++pos) {
            this.I[pos] = TokenCharacter.get(codepoints[pos]);
        }
        this.I[input.length()] = TokenEOF.EOF;
        return this.parseInput();
    }

    @Override
    public GllResult parse(Iterator<Token> input) {
        ArrayList<Token> list = new ArrayList<Token>();
        while (input.hasNext()) {
            list.add(input.next());
        }
        this.I = new Token[list.size() + 1];
        for (int pos = 0; pos < list.size(); ++pos) {
            this.I[pos] = (Token)list.get(pos);
        }
        this.I[list.size()] = TokenEOF.EOF;
        return this.parseInput();
    }

    @Override
    public GllResult parse(Token[] input) {
        this.I = new Token[input.length + 1];
        System.arraycopy(input, 0, this.I, 0, input.length);
        this.I[input.length] = TokenEOF.EOF;
        return this.parseInput();
    }

    private GllResult parseInput() {
        this.logger = this.options.getLogger();
        this.U = new HashSet();
        this.R = new ArrayList();
        this.P = new HashSet();
        this.crf = new HashMap();
        this.crfNodes = new HashMap();
        this.crf.put(new ClusterNode(this.grammar.getSeed(), 0), new ArrayList());
        this.bsr = new BinarySubtree(this.grammar.getSeed(), this.options);
        this.clusterNodes = new HashMap();
        this.c_U = 0;
        this.c_I = 0;
        if (this.compileStatements == null) {
            this.compileStatements = new ArrayList();
            this.compile();
            if (State.L0.getInstructionPointer() < 0) {
                State.L0.setInstructionPointer(1);
            }
            this.logger.trace(logcategory, "compiled parser:", new Object[0]);
            for (int pos = 1; pos < this.compileStatements.size(); ++pos) {
                MStatement statement = this.compileStatements.get(pos);
                this.logger.trace(logcategory, "%4d %s", pos, statement);
                if (!(statement instanceof MLabel)) continue;
                State label = ((MLabel)statement).label;
                label.setInstructionPointer(pos + 1);
            }
        }
        this.ntAdd(this.grammar.getSeed(), 0);
        this.options.getLogger().info(logcategory, "Parsing %,d tokens with GLL parser.", this.I.length);
        StopWatch timer = new StopWatch();
        this.execute();
        timer.stop();
        this.moreInput = this.bsr.getRightExtent() + 1 < this.I.length;
        this.tokenCount = this.bsr.getRightExtent();
        if (this.tokenCount < this.I.length) {
            this.lastToken = this.I[this.tokenCount];
        }
        ++this.tokenCount;
        if (this.bsr.succeeded(this.moreInput)) {
            if (timer.duration() == 0L) {
                this.options.getLogger().info(logcategory, "Parse succeeded", new Object[0]);
            } else {
                this.options.getLogger().info(logcategory, "Parse succeeded, %,d tokens in %s (%s tokens/sec)", this.tokenCount, timer.elapsed(), timer.perSecond(this.tokenCount));
            }
        } else if (timer.duration() == 0L) {
            this.options.getLogger().info(logcategory, "Parse failed after %,d tokens", this.tokenCount);
        } else {
            this.options.getLogger().info(logcategory, "Parse failed after %,d tokens in %s (%s tokens/sec)", this.tokenCount, timer.elapsed(), timer.perSecond(this.tokenCount));
        }
        GllResult result = new GllResult(this, this.bsr);
        result.setParseTime(timer.duration());
        return result;
    }

    @Override
    public boolean hasMoreInput() {
        return this.moreInput;
    }

    @Override
    public int getOffset() {
        this.computeOffsets();
        return this.offset;
    }

    @Override
    public int getLineNumber() {
        this.computeOffsets();
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        this.computeOffsets();
        return this.columnNumber;
    }

    private void computeOffsets() {
        if (this.offset >= 0) {
            return;
        }
        this.offset = 0;
        this.lineNumber = 1;
        this.columnNumber = 1;
        for (int pos = 0; pos < this.highwater; ++pos) {
            ++this.offset;
            ++this.columnNumber;
            if (this.I[pos] instanceof TokenCharacter && ((TokenCharacter)this.I[pos]).getCodepoint() == 10) {
                ++this.lineNumber;
                this.columnNumber = 1;
            }
            if (this.I[pos].hasAttribute("https://nineml.org/attr/line")) {
                this.lineNumber = Integer.parseInt(this.I[pos].getAttributeValue("https://nineml.org/attr/line", "error"));
            }
            if (this.I[pos].hasAttribute("https://nineml.org/attr/column")) {
                this.columnNumber = Integer.parseInt(this.I[pos].getAttributeValue("https://nineml.org/attr/column", "error"));
            }
            if (!this.I[pos].hasAttribute("https://nineml.org/attr/offset")) continue;
            this.offset = Integer.parseInt(this.I[pos].getAttributeValue("https://nineml.org/attr/offset", "error"));
        }
    }

    private void compile() {
        this.compileStatements.add(new MLabel(State.L0));
        this.compileStatements.add(new MNextDescriptor());
        for (Rule rule : this.grammar.getRulesForSymbol(this.grammar.getSeed())) {
            this.compile(rule);
        }
        for (NonterminalSymbol symbol : this.grammar.getSymbols()) {
            if (symbol.equals(this.grammar.getSeed())) continue;
            for (Rule rule : this.grammar.getRulesForSymbol(symbol)) {
                this.compile(rule);
            }
        }
    }

    private void compile(Rule rule) {
        ArrayList slots = new ArrayList(this.ruleSlots.get(rule));
        this.compileStatements.add(new MLabel((State)slots.get(0)));
        int pos = 0;
        for (State slot : slots) {
            this.compile(slot);
            if (pos > 0 && pos < slot.rhs.length) {
                this.compileStatements.add(new MTestSelect(slot));
            }
            ++pos;
        }
        this.compileStatements.add(new MFollow(rule.symbol));
        this.compileStatements.add(new MGoto(State.L0));
    }

    private void compile(State slot) {
        if (slot.position == 0) {
            if (slot.rhs.isEmpty()) {
                this.compileEpsilon(slot);
            }
            return;
        }
        Symbol prev = slot.prevSymbol();
        if (prev instanceof TerminalSymbol) {
            this.compileTerminal(slot);
        } else {
            this.compileNonterminal(slot);
        }
    }

    private void compileEpsilon(State slot) {
        this.compileStatements.add(new MBsrAdd(slot, true));
    }

    private void compileTerminal(State slot) {
        this.compileStatements.add(new MBsrAdd(slot));
        this.compileStatements.add(new MIncrementCI());
    }

    private void compileNonterminal(State slot) {
        this.compileStatements.add(new MCall(slot));
        this.compileStatements.add(new MGoto(State.L0));
        this.compileStatements.add(new MLabel(slot));
    }

    private void execute() {
        this.nextInstruction = 1;
        this.done = false;
        ProgressMonitor monitor = this.options.getProgressMonitor();
        if (monitor != null) {
            this.progressCount = this.progressSize = monitor.starting(this, this.I.length);
        }
        while (!this.done) {
            if (this.bsr.getRightExtent() > this.highwater) {
                this.highwater = this.bsr.getRightExtent();
            }
            if (monitor != null) {
                --this.progressCount;
                if (this.progressCount <= 0) {
                    monitor.workingSet(this, this.R.size(), this.highwater);
                    this.progressCount = this.progressSize;
                }
            }
            this.instructionPointer = this.nextInstruction++;
            MStatement stmt = this.compileStatements.get(this.instructionPointer);
            stmt.execute(this);
        }
        if (monitor != null) {
            monitor.finished(this);
        }
    }

    protected void nextDescriptor() {
        this.done = this.R.isEmpty();
        if (this.done) {
            this.logger.trace(gllexecution, "%4d exit", this.instructionPointer);
        } else {
            Descriptor desc = this.R.remove(0);
            this.c_U = desc.k;
            this.c_I = desc.j;
            this.nextInstruction = desc.slot.getInstructionPointer();
            this.logger.trace(gllexecution, "%4d c_U = %d; c_I = %d; goto %d", 1, this.c_U, this.c_I, this.nextInstruction);
        }
    }

    protected void jump(State label) {
        this.nextInstruction = label.getInstructionPointer();
        this.logger.trace(gllexecution, "%4d goto %d", this.instructionPointer, this.nextInstruction);
    }

    protected void incrementC_I() {
        ++this.c_I;
        this.logger.trace(gllexecution, "%4d c_I = %d", this.instructionPointer, this.c_I);
    }

    protected void follow(NonterminalSymbol symbol) {
        Token token = this.c_I >= this.I.length ? null : this.I[this.c_I];
        boolean inFollow = false;
        for (Symbol sym : this.grammar.getFollow(symbol)) {
            if (!sym.matches(token)) continue;
            inFollow = true;
            break;
        }
        if (inFollow) {
            this.logger.trace(gllexecution, "%4d if (%s \u2208 follow(%s)) then rtn(%s, %d, %d)", this.instructionPointer, token, symbol, symbol, this.c_U, this.c_I);
            this.rtn(symbol, this.c_U, this.c_I);
        } else {
            this.logger.trace(gllexecution, "%4d if (%s \u2209 follow(%s)) then nop", this.instructionPointer, token, symbol);
        }
    }

    protected void ntAdd(NonterminalSymbol X, int j) {
        for (State slot : this.grammarSlots) {
            if (!X.equals(slot.symbol) || slot.position != 0 || !this.testSelect(this.I[j], X, slot)) continue;
            this.dscAdd(slot, j, j);
        }
    }

    protected void testSelect(State slot) {
        String expr = "";
        if (this.logger.getLogLevel(gllexecution) >= 5) {
            StringBuilder sb = new StringBuilder();
            sb.append("testSelect(").append(this.I[this.c_I]).append(", ").append(slot.symbol).append(", ");
            for (int pos = slot.position; pos < slot.rhs.length; ++pos) {
                if (pos > slot.position) {
                    sb.append(" ");
                }
                sb.append(slot.rhs.get(pos));
            }
            expr = sb.toString();
        }
        if (this.testSelect(this.I[this.c_I], slot.symbol, slot)) {
            this.logger.trace(gllexecution, "%4d if (%s) then nop", this.instructionPointer, expr);
        } else {
            this.logger.trace(gllexecution, "%4d if (!%s) then goto %d", this.instructionPointer, expr, State.L0.getInstructionPointer());
            this.jump(State.L0);
        }
    }

    protected boolean testSelect(Token b, NonterminalSymbol X, State alpha) {
        boolean hasEpsilon = false;
        for (Symbol symbol : alpha.getFirst(this.grammar)) {
            if (symbol.matches(b)) {
                return true;
            }
            hasEpsilon = hasEpsilon || symbol == TerminalSymbol.EPSILON;
        }
        if (hasEpsilon) {
            for (Symbol symbol : this.grammar.getFollow(X)) {
                if (!symbol.matches(b)) continue;
                return true;
            }
        }
        return false;
    }

    protected void dscAdd(State slot, int k, int i) {
        Descriptor desc = slot.getDescriptor(k, i);
        if (!this.U.contains(desc)) {
            this.U.add(desc);
            this.R.add(desc);
        }
    }

    private ClusterNode getClusterNode(NonterminalSymbol X, int k) {
        if (!this.clusterNodes.containsKey(X)) {
            this.clusterNodes.put(X, new HashMap());
        }
        if (!this.clusterNodes.get(X).containsKey(k)) {
            this.clusterNodes.get(X).put(k, new ClusterNode(X, k));
        }
        return this.clusterNodes.get(X).get(k);
    }

    protected void rtn(NonterminalSymbol X, int k, int j) {
        PoppedNode pn = new PoppedNode(X, k, j);
        if (!this.P.contains(pn)) {
            this.P.add(pn);
            ClusterNode Xk = this.getClusterNode(X, k);
            if (this.crf.containsKey(Xk)) {
                for (CrfNode v : this.crf.get(Xk)) {
                    this.dscAdd(v.slot, v.i, j);
                    this.bsrAdd(v.slot, v.i, k, j);
                }
            } else {
                this.logger.trace(logcategory, "No key " + Xk + " in crf", new Object[0]);
            }
        }
    }

    protected void bsrAdd(State L, int i, int k, int j) {
        TerminalSymbol sym;
        if (this.instructionPointer >= 0) {
            this.logger.trace(gllexecution, "%4d bsrAdd(%s, %d, %d, %d)", this.instructionPointer, L, i, k, j);
        } else {
            this.logger.trace(gllexecution, "---- bsrAdd(%s, %d, %d, %d)", L, i, k, j);
        }
        int rightExtent = j;
        if (L.rhs.symbols[L.position - 1] instanceof TerminalSymbol && (sym = (TerminalSymbol)L.rhs.symbols[L.position - 1]).getToken() instanceof TokenRegex) {
            boolean done;
            TokenRegex token = (TokenRegex)sym.getToken();
            int pos = this.c_I;
            StringBuilder sb = new StringBuilder();
            sb.appendCodePoint(((TokenCharacter)this.I[pos]).getCodepoint());
            String consumed = sb.toString();
            boolean bl = done = pos >= this.I.length || !token.matches(sb.toString());
            while (!done) {
                consumed = sb.toString();
                if (this.I[++pos] instanceof TokenCharacter) {
                    sb.appendCodePoint(((TokenCharacter)this.I[pos]).getCodepoint());
                    done = pos >= this.I.length || !token.matches(sb.toString());
                    continue;
                }
                done = true;
            }
            this.c_I += consumed.length() - 1;
            rightExtent += consumed.length() - 1;
            this.bsr.regexMatches.put(i, consumed);
        }
        this.bsr.add(L, i, k, rightExtent);
    }

    protected void bsrAddEpsilon(State L, int i) {
        if (this.instructionPointer >= 0) {
            this.logger.trace(gllexecution, "%4d bsrAdd(%s, %d, %d, %d)", this.instructionPointer, L, i, i, i);
        } else {
            this.logger.trace(gllexecution, "---- bsrAdd(%s, %d, %d, %d)", L, i, i, i);
        }
        this.bsr.addEpsilon(L, i);
    }

    private CrfNode getCrfNode(State L, int i) {
        if (!this.crfNodes.containsKey(L)) {
            this.crfNodes.put(L, new HashMap());
        }
        if (!this.crfNodes.get(L).containsKey(i)) {
            this.crfNodes.get(L).put(i, new CrfNode(L, i));
        }
        return this.crfNodes.get(L).get(i);
    }

    protected void call(State L, int i, int j) {
        this.logger.trace(gllexecution, "%4d call(%s, %d, %d)", this.instructionPointer, L, i, j);
        CrfNode u = this.getCrfNode(L, i);
        NonterminalSymbol X = (NonterminalSymbol)L.prevSymbol();
        ClusterNode ndV = this.getClusterNode(X, j);
        if (!this.crf.containsKey(ndV)) {
            this.crf.put(ndV, new ArrayList());
            this.crf.get(ndV).add(u);
            this.ntAdd(X, j);
        } else {
            List v = this.crf.get(ndV);
            if (!this.edgeExists(v, u)) {
                this.crf.get(ndV).add(u);
                for (PoppedNode pnd : this.P) {
                    if (!X.equals(pnd.symbol) || j != pnd.k) continue;
                    this.dscAdd(L, i, pnd.j);
                    this.bsrAdd(L, i, j, pnd.j);
                }
            }
        }
    }

    private boolean edgeExists(List<CrfNode> nodes, CrfNode target) {
        for (CrfNode node : nodes) {
            if (!node.equals(target)) continue;
            return true;
        }
        return false;
    }

    public boolean succeeded() {
        return this.done && this.bsr.succeeded(this.moreInput);
    }
}

