/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.nineml.coffeegrinder.parser.EarleyItem;

public class EarleyChart {
    private final ArrayList<ArrayList<EarleyItem>> chart = new ArrayList();
    private final ArrayList<HashSet<EarleyItem>> rowmaps = new ArrayList();

    protected EarleyChart() {
    }

    public int size() {
        return this.chart.size();
    }

    public List<EarleyItem> get(int row) {
        this.assureRow(row);
        return this.chart.get(row);
    }

    public boolean contains(int row, EarleyItem item) {
        this.assureRow(row);
        return this.rowmaps.get(row).contains(item);
    }

    protected void clear() {
        this.chart.clear();
        this.rowmaps.clear();
    }

    protected ArrayList<ArrayList<EarleyItem>> rows() {
        return this.chart;
    }

    protected void add(int row, EarleyItem item) {
        this.assureRow(row);
        this.rowmaps.get(row).add(item);
        this.chart.get(row).add(item);
    }

    private void assureRow(int row) {
        if (this.chart.size() <= row) {
            this.chart.add(new ArrayList());
            this.rowmaps.add(new HashSet());
        }
    }
}

