/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.nineml.coffeegrinder.exceptions.ParseException;
import org.nineml.coffeegrinder.parser.EarleyChart;
import org.nineml.coffeegrinder.parser.EarleyItem;
import org.nineml.coffeegrinder.parser.EarleyResult;
import org.nineml.coffeegrinder.parser.ForestNode;
import org.nineml.coffeegrinder.parser.ForestNodeSet;
import org.nineml.coffeegrinder.parser.GearleyParser;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.ParseForest;
import org.nineml.coffeegrinder.parser.ParserGrammar;
import org.nineml.coffeegrinder.parser.ParserOptions;
import org.nineml.coffeegrinder.parser.ParserType;
import org.nineml.coffeegrinder.parser.ProgressMonitor;
import org.nineml.coffeegrinder.parser.Rule;
import org.nineml.coffeegrinder.parser.State;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.parser.TerminalSymbol;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.tokens.TokenCharacter;
import org.nineml.coffeegrinder.tokens.TokenString;
import org.nineml.coffeegrinder.util.StopWatch;

public class EarleyParser
implements GearleyParser {
    public static final String logcategory = "Parser";
    private final EarleyChart chart = new EarleyChart();
    private final ForestNodeSet V;
    private final ParserGrammar grammar;
    private final ParseForest graph;
    private final NonterminalSymbol S;
    private final HashMap<NonterminalSymbol, List<Rule>> Rho;
    protected Token[] input = null;
    protected int inputPos = 0;
    protected int offset = -1;
    protected int lineNumber = -1;
    protected int columnNumber = -1;
    protected boolean restartable = false;
    protected int restartPos = 0;
    private boolean moreInput = false;
    protected final ParserOptions options;
    protected ProgressMonitor monitor = null;
    protected int progressSize = 0;
    protected int progressCount = 0;

    protected EarleyParser(ParserGrammar grammar, ParserOptions options) {
        this.grammar = grammar;
        this.options = options;
        List<Rule> usefulRules = this.usefulSubset(grammar.getRules());
        HashSet<NonterminalSymbol> nulled = new HashSet<NonterminalSymbol>();
        this.Rho = new HashMap();
        for (Rule rule : usefulRules) {
            if (!this.Rho.containsKey(rule.getSymbol())) {
                this.Rho.put(rule.getSymbol(), new ArrayList());
            }
            this.Rho.get(rule.getSymbol()).add(rule);
            if (!rule.getRhs().isEmpty()) continue;
            nulled.add(rule.getSymbol());
        }
        for (NonterminalSymbol symbol : this.Rho.keySet()) {
            if (!grammar.isNullable(symbol) || nulled.contains(symbol)) continue;
            this.Rho.get(symbol).add(new Rule(symbol, new Symbol[0]));
        }
        this.S = grammar.getSeed();
        if (!this.Rho.containsKey(this.S)) {
            throw ParseException.seedNotInGrammar(this.S.toString());
        }
        this.graph = new ParseForest(options);
        this.V = new ForestNodeSet(this.graph);
    }

    @Override
    public ParserType getParserType() {
        return ParserType.Earley;
    }

    private List<Rule> usefulSubset(List<Rule> initiallist) {
        ArrayList<Rule> currentList = new ArrayList<Rule>();
        ArrayList<Rule> rules = new ArrayList<Rule>(initiallist);
        boolean done = false;
        while (!done) {
            done = true;
            currentList.clear();
            currentList.addAll(rules);
            rules.clear();
            HashSet<NonterminalSymbol> defined = new HashSet<NonterminalSymbol>();
            for (Rule rule : currentList) {
                defined.add(rule.getSymbol());
            }
            for (Rule rule : currentList) {
                boolean exclude = false;
                for (Symbol symbol : rule.getRhs().symbols) {
                    if (!(symbol instanceof NonterminalSymbol) || defined.contains(symbol)) continue;
                    this.options.getLogger().debug(logcategory, "Ignoring rule with undefined symbol: %s", rule);
                    exclude = true;
                    done = false;
                    break;
                }
                if (exclude) continue;
                rules.add(rule);
            }
        }
        return rules;
    }

    @Override
    public ParserGrammar getGrammar() {
        return this.grammar;
    }

    @Override
    public NonterminalSymbol getSeed() {
        return this.S;
    }

    @Override
    public EarleyResult parse(String input) {
        int[] codepoints = input.codePoints().toArray();
        this.input = new Token[codepoints.length];
        for (int pos = 0; pos < codepoints.length; ++pos) {
            this.input[pos] = TokenCharacter.get(codepoints[pos]);
        }
        return this.parseInput();
    }

    @Override
    public EarleyResult parse(Token[] input) {
        this.input = input;
        return this.parseInput();
    }

    @Override
    public EarleyResult parse(Iterator<Token> input) {
        ArrayList<Token> list = new ArrayList<Token>();
        while (input.hasNext()) {
            list.add(input.next());
        }
        this.input = new Token[list.size()];
        for (int pos = 0; pos < list.size(); ++pos) {
            this.input[pos] = (Token)list.get(pos);
        }
        return this.parseInput();
    }

    private EarleyResult parseInput() {
        return this.parseInput(0);
    }

    private EarleyResult parseInput(int startPos) {
        EarleyResult result;
        this.inputPos = startPos;
        this.restartable = false;
        this.monitor = this.options.getProgressMonitor();
        if (this.monitor != null) {
            this.progressCount = this.progressSize = this.monitor.starting(this, this.input.length - this.inputPos);
        }
        ArrayList Q = new ArrayList();
        ArrayList<EarleyItem> Qprime = new ArrayList<EarleyItem>();
        int tokenCount = 0;
        Token lastInputToken = null;
        boolean emptyInput = true;
        Token currentToken = null;
        if (this.inputPos < this.input.length) {
            emptyInput = false;
            currentToken = this.input[this.inputPos];
        }
        for (Rule rule : this.Rho.get(this.S)) {
            State state;
            Symbol alpha = rule.getRhs().getFirst();
            if (alpha == null || alpha instanceof NonterminalSymbol) {
                state = new State(rule);
                this.chart.add(0, new EarleyItem(state, 0, null));
            }
            if (!(alpha instanceof TerminalSymbol) || !alpha.matches(currentToken)) continue;
            state = new State(rule);
            Qprime.add(new EarleyItem(state, 0, null));
        }
        Token nextToken = currentToken;
        boolean consumedInput = true;
        boolean done = false;
        boolean lastToken = false;
        int checkpoint = -1;
        int i = 0;
        this.options.getLogger().info(logcategory, "Parsing %,d tokens with Earley parser.", this.input.length - startPos);
        StopWatch timer = new StopWatch();
        ArrayList<Hitem> H = new ArrayList<Hitem>();
        ArrayList<ForestNode> localRoots = new ArrayList<ForestNode>();
        String greedy = null;
        while (!done) {
            currentToken = nextToken;
            boolean bl = consumedInput = currentToken == null;
            if (this.progressSize > 0) {
                if (this.progressCount == 0) {
                    this.monitor.progress(this, tokenCount);
                    this.progressCount = this.progressSize - 1;
                } else {
                    --this.progressCount;
                }
            }
            if (currentToken != null) {
                lastInputToken = currentToken;
                tokenCount = i + 1;
            }
            H.clear();
            ArrayList<EarleyItem> R = new ArrayList<EarleyItem>(this.chart.get(i));
            Q.clear();
            Q.addAll(Qprime);
            Qprime.clear();
            while (!R.isEmpty()) {
                EarleyItem item;
                Iterator Lambda = R.remove(0);
                if (((EarleyItem)((Object)Lambda)).state != null && ((EarleyItem)((Object)Lambda)).state.nextSymbol() instanceof NonterminalSymbol) {
                    NonterminalSymbol C = (NonterminalSymbol)((EarleyItem)((Object)Lambda)).state.nextSymbol();
                    for (Rule rule : this.Rho.get(C)) {
                        Symbol delta = rule.getRhs().getFirst();
                        if ((delta == null || delta instanceof NonterminalSymbol) && !this.chart.contains(i, item = new EarleyItem(new State(rule), i, null))) {
                            this.chart.add(i, item);
                            R.add(item);
                        }
                        if (!(delta instanceof TerminalSymbol) || !delta.matches(currentToken) || Q.contains(item = new EarleyItem(new State(rule), i, null))) continue;
                        Q.add(item);
                        consumedInput = true;
                        Symbol symbol = item.state.nextSymbol();
                        greedy = symbol.getAttributeValue("regex", null);
                    }
                    for (Hitem hitem : H) {
                        if (!hitem.symbol.equals(C)) continue;
                        State newState = ((EarleyItem)((Object)Lambda)).state.advance();
                        ForestNode y = this.make_node(newState, ((EarleyItem)((Object)Lambda)).j, i, ((EarleyItem)((Object)Lambda)).w, hitem.w);
                        Symbol Beta = newState.nextSymbol();
                        EarleyItem item2 = new EarleyItem(newState, ((EarleyItem)((Object)Lambda)).j, y);
                        if ((Beta == null || Beta instanceof NonterminalSymbol) && !this.chart.contains(i, item2)) {
                            this.chart.add(i, item2);
                            R.add(item2);
                        }
                        if (!(Beta instanceof TerminalSymbol) || !Beta.matches(currentToken) || Q.contains(item2)) continue;
                        Q.add(item2);
                        consumedInput = true;
                    }
                }
                if (((EarleyItem)((Object)Lambda)).state == null || !((EarleyItem)((Object)Lambda)).state.completed()) continue;
                ForestNode w = ((EarleyItem)((Object)Lambda)).w;
                int h = ((EarleyItem)((Object)Lambda)).j;
                NonterminalSymbol D = ((EarleyItem)((Object)Lambda)).state.getSymbol();
                if (w == null) {
                    w = this.V.conditionallyCreateNode(D, ((EarleyItem)((Object)Lambda)).state, i, i);
                    w.addFamily(null);
                }
                if (h == i) {
                    H.add(new Hitem(D, w));
                }
                for (int hpos = 0; hpos < this.chart.get(h).size(); ++hpos) {
                    item = this.chart.get(h).get(hpos);
                    if (item.state == null || !D.equals(item.state.nextSymbol())) continue;
                    State newState = item.state.advance();
                    ForestNode y = this.make_node(newState, item.j, i, item.w, w);
                    Symbol delta = newState.nextSymbol();
                    EarleyItem nextItem = new EarleyItem(newState, item.j, y);
                    if ((delta == null || delta instanceof NonterminalSymbol) && !this.chart.contains(i, nextItem)) {
                        this.chart.add(i, nextItem);
                        R.add(nextItem);
                    }
                    if (!(delta instanceof TerminalSymbol) || !delta.matches(currentToken)) continue;
                    Q.add(nextItem);
                    consumedInput = true;
                }
            }
            if (this.options.getPrefixParsing() && this.chart.size() > 0) {
                localRoots.clear();
                for (EarleyItem item : this.chart.get(this.chart.size() - 1)) {
                    if (!item.state.completed() || item.j != 0 || !item.state.getSymbol().equals(this.S)) continue;
                    if (item.w != null) {
                        localRoots.add(item.w);
                    }
                    checkpoint = this.graph.size();
                    if (!consumedInput) continue;
                    this.restartPos = this.inputPos + 1;
                    this.restartable = true;
                }
                if (!localRoots.isEmpty()) {
                    this.graph.clearRoots();
                    for (ForestNode node : localRoots) {
                        this.graph.root(node);
                    }
                }
            }
            Token peek = null;
            this.V.clear();
            ForestNode v = null;
            if (currentToken != null) {
                if (greedy != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(currentToken.getValue());
                    Pattern patn = Pattern.compile(greedy);
                    while (this.inputPos < this.input.length) {
                        String s;
                        if (patn.matcher(s = (nextToken = this.input[this.inputPos++]).getValue()).matches()) {
                            sb.append(s);
                            continue;
                        }
                        peek = nextToken;
                        break;
                    }
                    currentToken = TokenString.get(sb.toString());
                    this.options.getLogger().trace(logcategory, "Regex matched: " + sb.toString(), new Object[0]);
                }
                v = this.graph.createNode(new TerminalSymbol(currentToken), i, i + 1);
            }
            done = lastToken;
            if (peek != null || this.inputPos + 1 < this.input.length) {
                nextToken = peek == null ? this.input[++this.inputPos] : peek;
            } else {
                nextToken = null;
                lastToken = true;
            }
            while (!Q.isEmpty()) {
                EarleyItem nextItem;
                EarleyItem Lambda = (EarleyItem)Q.remove(0);
                State nextState = Lambda.state.advance();
                ForestNode y = this.make_node(nextState, Lambda.j, i + 1, Lambda.w, v);
                Symbol Beta = nextState.nextSymbol();
                if ((Beta == null || Beta instanceof NonterminalSymbol) && !this.chart.contains(i + 1, nextItem = new EarleyItem(nextState, Lambda.j, y))) {
                    this.chart.add(i + 1, nextItem);
                }
                if (!(Beta instanceof TerminalSymbol) || !Beta.matches(nextToken)) continue;
                Qprime.add(new EarleyItem(nextState, Lambda.j, y));
            }
            done = done || this.chart.get(++i).isEmpty() && Qprime.isEmpty();
        }
        timer.stop();
        if (this.monitor != null) {
            if (this.progressSize > 0) {
                this.monitor.progress(this, tokenCount);
            }
            this.monitor.finished(this);
        }
        boolean success = this.inputPos == this.input.length || this.inputPos + 1 == this.input.length && consumedInput && lastToken;
        boolean bl = this.moreInput = !success;
        if (success) {
            int index;
            success = false;
            localRoots.clear();
            for (index = this.chart.size() - 1; index > 0 && this.chart.get(index).isEmpty(); --index) {
            }
            for (EarleyItem item : this.chart.get(index)) {
                if (!item.state.completed() || !item.state.getSymbol().equals(this.S) || item.j != 0) continue;
                success = true;
                if (item.w == null) continue;
                localRoots.add(item.w);
            }
            if (emptyInput && localRoots.isEmpty() && !this.graph.graph.isEmpty()) {
                localRoots.add(this.graph.graph.get(0));
            }
            if (!localRoots.isEmpty()) {
                this.options.getLogger().debug(logcategory, "Resetting graph roots, %d new roots", localRoots.size());
                this.graph.clearRoots();
                for (ForestNode node : localRoots) {
                    this.graph.root(node);
                }
            }
        }
        if (success) {
            if (tokenCount == 0 || timer.duration() == 0L) {
                this.options.getLogger().info(logcategory, "Parse succeeded", new Object[0]);
            } else {
                this.options.getLogger().info(logcategory, "Parse succeeded, %,d tokens in %s (%s tokens/sec)", tokenCount, timer.elapsed(), timer.perSecond(tokenCount));
            }
            this.graph.prune();
            if (this.options.getReturnChart()) {
                result = new EarleyResult(this, this.chart, this.graph, success, tokenCount, lastInputToken);
            } else {
                this.chart.clear();
                result = new EarleyResult(this, this.graph, success, tokenCount, lastInputToken);
            }
        } else {
            if (timer.duration() == 0L) {
                this.options.getLogger().info(logcategory, "Parse failed after %,d tokens", tokenCount);
            } else {
                this.options.getLogger().info(logcategory, "Parse failed after %,d tokens in %s (%s tokens/sec)", tokenCount, timer.elapsed(), timer.perSecond(tokenCount));
            }
            if (this.options.getPrefixParsing() && checkpoint >= 0) {
                this.graph.rollback(checkpoint);
                this.graph.prune();
            }
            result = new EarleyResult(this, this.chart, this.graph, success, tokenCount, lastInputToken);
            result.addPredicted(this.V.openPredictions());
        }
        result.setParseTime(timer.duration());
        return result;
    }

    protected EarleyResult continueParsing(EarleyParser parser) {
        parser.input = this.input;
        return parser.parseInput(this.restartPos);
    }

    @Override
    public boolean hasMoreInput() {
        return this.moreInput;
    }

    @Override
    public int getLineNumber() {
        this.computeOffsets();
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        this.computeOffsets();
        return this.columnNumber;
    }

    @Override
    public int getOffset() {
        this.computeOffsets();
        return this.offset;
    }

    private void computeOffsets() {
        if (this.offset >= 0) {
            return;
        }
        this.offset = 0;
        this.lineNumber = 1;
        this.columnNumber = 1;
        for (int pos = 0; pos < this.inputPos; ++pos) {
            ++this.offset;
            ++this.columnNumber;
            if (this.input[pos] instanceof TokenCharacter && ((TokenCharacter)this.input[pos]).getCodepoint() == 10) {
                ++this.lineNumber;
                this.columnNumber = 1;
            }
            if (this.input[pos].hasAttribute("https://nineml.org/attr/line")) {
                this.lineNumber = Integer.parseInt(this.input[pos].getAttributeValue("https://nineml.org/attr/line", "error"));
            }
            if (this.input[pos].hasAttribute("https://nineml.org/attr/column")) {
                this.columnNumber = Integer.parseInt(this.input[pos].getAttributeValue("https://nineml.org/attr/column", "error"));
            }
            if (!this.input[pos].hasAttribute("https://nineml.org/attr/offset")) continue;
            this.offset = Integer.parseInt(this.input[pos].getAttributeValue("https://nineml.org/attr/offset", "error"));
        }
    }

    private ForestNode make_node(State B, int j, int i, ForestNode w, ForestNode v) {
        ForestNode y;
        if (B.completed()) {
            NonterminalSymbol s = B.getSymbol();
            y = this.V.conditionallyCreateNode(s, B, j, i);
            if (w == null) {
                y.addFamily(v);
            } else {
                y.addFamily(w, v);
            }
        } else {
            State s = B;
            if (B.getPosition() == 1 && !B.completed()) {
                y = v;
            } else {
                y = this.V.conditionallyCreateNode(s, j, i);
                if (w == null) {
                    y.addFamily(v);
                } else {
                    y.addFamily(w, v);
                }
            }
        }
        return y;
    }

    private static final class Hitem {
        public final NonterminalSymbol symbol;
        public final ForestNode w;

        public Hitem(NonterminalSymbol symbol, ForestNode w) {
            this.symbol = symbol;
            this.w = w;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Hitem) {
                Hitem other = (Hitem)obj;
                if (this.w == null) {
                    if (other.w != null) {
                        return false;
                    }
                    return this.symbol.equals(other.symbol);
                }
                return this.symbol.equals(other.symbol) && this.w.equals(other.w);
            }
            return false;
        }

        public int hashCode() {
            return this.symbol.hashCode() + (this.w == null ? 0 : 19 * this.w.hashCode());
        }

        public String toString() {
            return this.symbol + ", " + this.w;
        }
    }
}

