/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.nineml.coffeegrinder.exceptions.ParseException;
import org.nineml.coffeegrinder.parser.EarleyChart;
import org.nineml.coffeegrinder.parser.EarleyItem;
import org.nineml.coffeegrinder.parser.EarleyParser;
import org.nineml.coffeegrinder.parser.GearleyResult;
import org.nineml.coffeegrinder.parser.ParseForest;
import org.nineml.coffeegrinder.parser.ParseTree;
import org.nineml.coffeegrinder.parser.ParserOptions;
import org.nineml.coffeegrinder.parser.TerminalSymbol;
import org.nineml.coffeegrinder.parser.TreeBuilder;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.util.ParseTreeBuilder;

public class EarleyResult
implements GearleyResult {
    private final EarleyParser parser;
    private final EarleyChart chart;
    private final ParseForest graph;
    private final boolean success;
    private final int tokenCount;
    private final Token lastToken;
    private final int offset;
    private final int lineNumber;
    private final int columnNumber;
    private final ParserOptions options;
    private final HashSet<TerminalSymbol> predicted = new HashSet();
    private long parseTime = -1L;

    protected EarleyResult(EarleyParser parser, EarleyChart chart, ParseForest graph, boolean success, int tokenCount, Token lastToken) {
        this.parser = parser;
        this.chart = chart;
        this.graph = graph;
        this.success = success;
        this.tokenCount = tokenCount;
        this.lastToken = lastToken;
        this.options = parser.options;
        this.offset = parser.getOffset();
        this.lineNumber = parser.getLineNumber();
        this.columnNumber = parser.getColumnNumber();
    }

    protected EarleyResult(EarleyParser parser, ParseForest graph, boolean success, int tokenCount, Token lastToken) {
        this.parser = parser;
        this.chart = null;
        this.graph = graph;
        this.success = success;
        this.tokenCount = tokenCount;
        this.lastToken = lastToken;
        this.options = parser.options;
        this.offset = parser.getOffset();
        this.lineNumber = parser.getLineNumber();
        this.columnNumber = parser.getColumnNumber();
    }

    @Override
    public long getParseTime() {
        return this.parseTime;
    }

    protected void setParseTime(long time) {
        this.parseTime = time;
    }

    @Override
    public EarleyParser getParser() {
        return this.parser;
    }

    public EarleyChart getChart() {
        return this.chart;
    }

    @Override
    public ParseForest getForest() {
        return this.graph;
    }

    @Override
    public ParseTree getTree() {
        ParseTreeBuilder builder = new ParseTreeBuilder();
        this.getTree(builder);
        return builder.getParseTree();
    }

    @Override
    public void getTree(TreeBuilder builder) {
        this.graph.getTree(builder);
    }

    @Override
    public boolean isAmbiguous() {
        return this.graph != null && this.graph.isAmbiguous();
    }

    @Override
    public boolean isInfinitelyAmbiguous() {
        return this.graph != null && this.graph.isInfinitelyAmbiguous();
    }

    @Override
    public boolean succeeded() {
        return this.success;
    }

    @Override
    public boolean prefixSucceeded() {
        if (this.success || !this.parser.getGrammar().getParserOptions().getPrefixParsing()) {
            return false;
        }
        if (this.chart != null && this.chart.size() > 1) {
            for (EarleyItem item : this.chart.get(this.chart.size() - 2)) {
                if (!item.state.completed() || !item.state.getSymbol().equals(this.parser.getSeed()) || item.j != 0) continue;
                return true;
            }
        }
        return false;
    }

    public Token[] getSuffix() {
        if (!this.prefixSucceeded()) {
            return null;
        }
        Token[] tokens = new Token[this.parser.input.length - this.parser.restartPos];
        System.arraycopy(this.parser.input, this.parser.restartPos, tokens, 0, tokens.length);
        return tokens;
    }

    @Override
    public EarleyResult continueParsing() {
        if (!this.prefixSucceeded()) {
            throw ParseException.attemptToContinueInvalidParse();
        }
        EarleyParser newParser = (EarleyParser)this.parser.getGrammar().getParser(this.options);
        return this.parser.continueParsing(newParser);
    }

    @Override
    public int getTokenCount() {
        return this.tokenCount;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    protected void addPredicted(Set<TerminalSymbol> symbols) {
        this.predicted.addAll(symbols);
    }

    @Override
    public Set<TerminalSymbol> getPredictedTerminals() {
        return this.predicted;
    }

    private static final class PrefixIterator<Token>
    implements Iterator<Token> {
        private ArrayList<Token> buffer = null;
        private Iterator<Token> iterator = null;

        public PrefixIterator(List<Token> buffer, Iterator<Token> iterator) {
            this.buffer = new ArrayList<Token>(buffer);
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return !this.buffer.isEmpty() || this.iterator.hasNext();
        }

        @Override
        public Token next() {
            if (this.buffer.isEmpty()) {
                return this.iterator.next();
            }
            Token t = this.buffer.get(0);
            this.buffer.remove(0);
            return t;
        }
    }
}

