/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import org.nineml.coffeegrinder.exceptions.ParseException;
import org.nineml.coffeegrinder.parser.ForestNode;
import org.nineml.coffeegrinder.parser.RuleChoice;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.parser.TerminalSymbol;

public class Family
implements RuleChoice {
    public ForestNode v;
    public ForestNode w;
    private Symbol[] combinedRHS = null;

    protected Family(ForestNode v) {
        this.v = v;
        this.w = null;
    }

    protected Family(ForestNode w, ForestNode v) {
        if (w == null) {
            throw ParseException.internalError("Attempt to create family with null 'w'");
        }
        this.w = w;
        this.v = v;
    }

    @Override
    public Symbol getSymbol() {
        if (this.v == null) {
            return TerminalSymbol.EPSILON;
        }
        if (this.w == null) {
            if (this.v.symbol == null) {
                return this.v.state.symbol;
            }
            return this.v.symbol;
        }
        if (this.w.symbol == null) {
            return this.w.state.symbol;
        }
        return this.w.symbol;
    }

    @Override
    public Symbol[] getRightHandSide() {
        Symbol symbol;
        int n;
        int n2;
        Symbol[] symbolArray;
        int slength;
        if (this.combinedRHS != null) {
            return this.combinedRHS;
        }
        if (this.v == null) {
            this.combinedRHS = new Symbol[0];
            return this.combinedRHS;
        }
        if (this.w == null) {
            this.combinedRHS = this.v.state == null ? new Symbol[0] : this.v.state.getRhs().symbols;
            return this.combinedRHS;
        }
        if (this.v.state != null && this.w.state != null && this.v.state.rhs == this.w.state.rhs) {
            this.combinedRHS = this.v.state.getRhs().symbols;
            return this.combinedRHS;
        }
        int n3 = slength = this.w.state == null ? 0 : this.w.state.getRhs().symbols.length;
        if (this.v.state != null) {
            slength += this.v.state.getRhs().symbols.length;
        }
        this.combinedRHS = new Symbol[slength];
        int pos = 0;
        if (this.w.state != null) {
            symbolArray = this.w.state.getRhs().symbols;
            n2 = symbolArray.length;
            for (n = 0; n < n2; ++n) {
                this.combinedRHS[pos] = symbol = symbolArray[n];
                ++pos;
            }
        }
        if (this.v.state != null) {
            symbolArray = this.v.state.getRhs().symbols;
            n2 = symbolArray.length;
            for (n = 0; n < n2; ++n) {
                this.combinedRHS[pos] = symbol = symbolArray[n];
                ++pos;
            }
        }
        return this.combinedRHS;
    }

    @Override
    public ForestNode getLeftNode() {
        return this.w;
    }

    @Override
    public ForestNode getRightNode() {
        return this.v;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Family) {
            Family other = (Family)obj;
            if (this.v == null) {
                return other.v == null;
            }
            if (this.w == null) {
                return other.w == null && this.v.equals(other.v);
            }
            return this.w.equals(other.w) && this.v.equals(other.v);
        }
        return false;
    }

    public int hashCode() {
        if (this.v == null) {
            return 19;
        }
        if (this.w == null) {
            return this.v.hashCode();
        }
        return 31 * this.w.hashCode() + this.v.hashCode();
    }

    public String toString() {
        if (this.v == null) {
            return "\u03b5";
        }
        if (this.w == null) {
            return this.v.toString();
        }
        return this.w + " / " + this.v;
    }
}

