/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.nineml.coffeegrinder.parser.Family;
import org.nineml.coffeegrinder.parser.ParseForest;
import org.nineml.coffeegrinder.parser.RuleChoice;
import org.nineml.coffeegrinder.parser.State;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.util.ParserAttribute;

public class ForestNode
implements RuleChoice {
    public static final String logcategory = "ForestNode";
    private static int nextNodeId = 0;
    protected final ParseForest graph;
    public final Symbol symbol;
    public final State state;
    public final int rightExtent;
    public final int leftExtent;
    public final int id;
    protected final ArrayList<Family> families = new ArrayList();
    protected final ArrayList<Family> loops = new ArrayList();
    protected boolean reachable = false;
    protected Integer nodeHash = null;

    protected ForestNode(ParseForest graph, Symbol symbol, int leftExtent, int rightExtent) {
        this.graph = graph;
        this.symbol = symbol;
        this.state = null;
        this.rightExtent = rightExtent;
        this.leftExtent = leftExtent;
        this.id = nextNodeId++;
    }

    protected ForestNode(ParseForest graph, State state, int leftExtent, int rightExtent) {
        this.graph = graph;
        this.symbol = null;
        this.state = state;
        this.rightExtent = rightExtent;
        this.leftExtent = leftExtent;
        this.id = nextNodeId++;
    }

    protected ForestNode(ParseForest graph, Symbol symbol, State state, int leftExtent, int rightExtent) {
        this.graph = graph;
        this.symbol = symbol;
        this.state = state;
        this.rightExtent = rightExtent;
        this.leftExtent = leftExtent;
        this.id = nextNodeId++;
    }

    @Override
    public Symbol getSymbol() {
        return this.symbol;
    }

    public State getState() {
        return this.state;
    }

    public List<Family> getFamilies() {
        return this.families;
    }

    public List<Family> getLoops() {
        return this.loops;
    }

    public void addFamily(ForestNode v) {
        for (Family family : this.families) {
            if (family.w != null || (v != null || family.v != null) && (v == null || !v.equals(family.v))) continue;
            return;
        }
        this.families.add(new Family(v));
    }

    public void addFamily(ForestNode w, ForestNode v) {
        for (Family family : this.families) {
            if ((v != null || family.v != null) && (v == null || !v.equals(family.v)) || (w != null || family.w != null) && (w == null || !w.equals(family.w))) continue;
            return;
        }
        this.families.add(new Family(w, v));
    }

    protected void reach() {
        ArrayList<ForestNode> pending = new ArrayList<ForestNode>();
        HashSet<ForestNode> seen = new HashSet<ForestNode>();
        pending.add(this);
        while (!pending.isEmpty()) {
            ForestNode check = (ForestNode)pending.remove(0);
            check.reach(pending, seen);
        }
    }

    protected void reach(ArrayList<ForestNode> pending, HashSet<ForestNode> seen) {
        if (seen.contains(this)) {
            return;
        }
        seen.add(this);
        if (!this.reachable) {
            this.reachable = true;
            for (Family family : this.families) {
                if (family.v != null && family.w != null && family.v.leftExtent != family.v.rightExtent && family.w.leftExtent != family.w.rightExtent && (family.v.leftExtent == family.w.leftExtent || family.v.rightExtent == family.w.rightExtent)) {
                    this.graph.options.getLogger().debug(logcategory, "Ambiguity detected; overlap: %d,%d :: %d,%d", family.v.leftExtent, family.v.rightExtent, family.w.leftExtent, family.w.rightExtent);
                }
                if (family.v != null) {
                    pending.add(family.v);
                }
                if (family.w == null) continue;
                pending.add(family.w);
            }
        }
    }

    protected boolean trimEpsilon() {
        if (this.nodeHash != null) {
            return false;
        }
        if (this.families.isEmpty()) {
            this.nodeHash = this.getSymbol().hashCode();
            return false;
        }
        this.nodeHash = 0;
        for (Family family : this.families) {
            if ((family.w == null || family.w.nodeHash == null) && (family.v == null || family.v.nodeHash == null)) continue;
            this.loops.add(family);
        }
        for (Family family : this.families) {
            if (family.w != null) {
                family.w.trimEpsilon();
            }
            if (family.v == null || !family.v.trimEpsilon() || family.w != null) continue;
            this.graph.graph.remove(family.v);
            family.v = null;
        }
        this.nodeHash = this.getSymbol() == null ? Integer.valueOf(this.getState().hashCode()) : Integer.valueOf(this.getSymbol().hashCode());
        for (Family family : this.families) {
            if (family.w != null) {
                this.nodeHash = this.nodeHash + 7 * family.w.nodeHash;
            }
            if (family.v == null) continue;
            this.nodeHash = this.nodeHash + 3 * family.v.nodeHash;
        }
        ArrayList<Family> newFamilies = new ArrayList<Family>();
        for (Family family : this.families) {
            boolean found = false;
            for (Family newfam : newFamilies) {
                found = true;
                if (newfam.w != family.w) {
                    found = newfam.w == null || family.w == null ? false : newfam.w.nodeHash.equals(family.w.nodeHash);
                }
                if (newfam.v == family.v) continue;
                if (newfam.v == null || family.v == null) {
                    found = false;
                    continue;
                }
                found = found && newfam.v.nodeHash.equals(family.v.nodeHash);
            }
            if (found) continue;
            newFamilies.add(family);
        }
        this.families.clear();
        this.families.addAll(newFamilies);
        if (this.getSymbol() == null) {
            return false;
        }
        ParserAttribute parserAttribute = this.getSymbol().getAttribute("https://nineml.org/attr/prune");
        if (parserAttribute == null || parserAttribute.getValue().equals(ParserAttribute.PRUNING_FORBIDDEN.getValue())) {
            return false;
        }
        if (this.families.size() == 1) {
            Family family;
            family = this.families.get(0);
            return family.w == null && family.v == null;
        }
        return false;
    }

    @Override
    public ForestNode getLeftNode() {
        return null;
    }

    @Override
    public ForestNode getRightNode() {
        return this;
    }

    @Override
    public Symbol[] getRightHandSide() {
        if (this.state != null) {
            return this.state.rhs.symbols;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ForestNode) {
            ForestNode other = (ForestNode)obj;
            if (this.state == null) {
                assert (this.symbol != null);
                return this.symbol.equals(other.symbol) && this.rightExtent == other.rightExtent && this.leftExtent == other.leftExtent;
            }
            return Objects.equals(this.symbol, other.symbol) && this.state.equals(other.state) && this.rightExtent == other.rightExtent && this.leftExtent == other.leftExtent;
        }
        return false;
    }

    public int hashCode() {
        int code = 17 * this.rightExtent + 31 * this.leftExtent;
        if (this.symbol != null) {
            code += 11 * this.symbol.hashCode();
        } else {
            assert (this.state != null);
            code += 13 * this.state.hashCode();
        }
        return code;
    }

    public String toString() {
        if (this.symbol == null) {
            return this.state + ", " + this.leftExtent + ", " + this.rightExtent;
        }
        return this.symbol + ", " + this.leftExtent + ", " + this.rightExtent;
    }
}

