/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.nineml.coffeegrinder.parser.ForestNode;
import org.nineml.coffeegrinder.parser.ParseForest;
import org.nineml.coffeegrinder.parser.State;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.parser.TerminalSymbol;

public class ForestNodeSet {
    private final HashMap<Symbol, HashMap<Long, ForestNode>> forestSymbolMap = new HashMap();
    private final HashMap<State, HashMap<Long, ForestNode>> forestStateMap = new HashMap();
    private final ParseForest graph;

    protected ForestNodeSet(ParseForest graph) {
        this.graph = graph;
    }

    protected void clear() {
        this.forestStateMap.clear();
        this.forestSymbolMap.clear();
    }

    protected ForestNode get(Symbol symbol, int j, int i) {
        long ji = ((long)j << 32) + (long)i;
        if (this.forestSymbolMap.containsKey(symbol)) {
            return this.forestSymbolMap.get(symbol).getOrDefault(ji, null);
        }
        this.forestSymbolMap.put(symbol, new HashMap());
        return null;
    }

    protected ForestNode get(State state, int j, int i) {
        long ji = ((long)j << 32) + (long)i;
        if (this.forestStateMap.containsKey(state)) {
            return this.forestStateMap.get(state).getOrDefault(ji, null);
        }
        this.forestStateMap.put(state, new HashMap());
        return null;
    }

    protected boolean contains(Symbol symbol, int j, int i) {
        return this.get(symbol, j, i) != null;
    }

    protected boolean contains(State state, int j, int i) {
        return this.get(state, j, i) != null;
    }

    protected ForestNode conditionallyCreateNode(Symbol symbol, int j, int i) {
        ForestNode node = this.get(symbol, j, i);
        if (node == null) {
            long ji = ((long)j << 32) + (long)i;
            node = this.graph.createNode(symbol, j, i);
            this.forestSymbolMap.get(symbol).put(ji, node);
        }
        return node;
    }

    protected ForestNode conditionallyCreateNode(Symbol symbol, State state, int j, int i) {
        ForestNode node = this.get(symbol, j, i);
        if (node == null) {
            long ji = ((long)j << 32) + (long)i;
            node = this.graph.createNode(symbol, state, j, i);
            this.forestSymbolMap.get(symbol).put(ji, node);
        }
        return node;
    }

    protected ForestNode conditionallyCreateNode(State state, int j, int i) {
        ForestNode node = this.get(state, j, i);
        if (node == null) {
            long ji = ((long)j << 32) + (long)i;
            node = this.graph.createNode(state, j, i);
            this.forestStateMap.get(state).put(ji, node);
        }
        return node;
    }

    protected Set<TerminalSymbol> openPredictions() {
        HashSet<TerminalSymbol> set = new HashSet<TerminalSymbol>();
        for (State state : this.forestStateMap.keySet()) {
            Symbol s;
            if (state.completed() || !((s = state.nextSymbol()) instanceof TerminalSymbol)) continue;
            set.add((TerminalSymbol)s);
        }
        return set;
    }
}

