/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.ParserGrammar;
import org.nineml.coffeegrinder.parser.Rule;
import org.nineml.coffeegrinder.parser.SourceGrammar;
import org.nineml.coffeegrinder.parser.Symbol;

public class HygieneReport {
    public static final String logcategory = "Hygiene";
    private final SourceGrammar grammar;
    private final ParserGrammar parserGrammar;
    private final HashSet<Rule> unproductiveRules = new HashSet();
    private final HashSet<NonterminalSymbol> unproductiveSymbols = new HashSet();
    private final HashSet<NonterminalSymbol> unreachableSymbols = new HashSet();
    private final HashSet<NonterminalSymbol> undefinedSymbols = new HashSet();
    private ArrayList<Rule> rules = null;

    protected HygieneReport(ParserGrammar grammar) {
        this.parserGrammar = grammar;
        this.grammar = null;
        this.checkGrammar(grammar.getSeed());
    }

    protected HygieneReport(SourceGrammar grammar, NonterminalSymbol seed) {
        this.parserGrammar = null;
        this.grammar = grammar;
        this.checkGrammar(seed);
    }

    private void checkGrammar(NonterminalSymbol seed) {
        Map<NonterminalSymbol, List<Rule>> rulesBySymbol;
        if (this.parserGrammar != null && this.rules != null) {
            return;
        }
        this.rules = new ArrayList();
        if (this.grammar != null) {
            this.rules.addAll(this.grammar.getRules());
            rulesBySymbol = this.grammar.getRulesBySymbol();
        } else {
            assert (this.parserGrammar != null);
            this.rules.addAll(this.parserGrammar.getRules());
            rulesBySymbol = this.parserGrammar.getRulesBySymbol();
        }
        HashSet<NonterminalSymbol> reachable = new HashSet<NonterminalSymbol>();
        this.walk(seed, reachable);
        for (Rule rule : this.rules) {
            if (reachable.contains(rule.getSymbol())) continue;
            this.addUnreachable(rule.getSymbol());
        }
        for (NonterminalSymbol nt : this.undefinedSymbols()) {
            this.addUndefined(nt);
        }
        HashSet<NonterminalSymbol> productiveNT = new HashSet<NonterminalSymbol>();
        HashSet<Rule> productiveRule = new HashSet<Rule>();
        int psize = -1;
        int rsize = -1;
        while (psize != productiveNT.size() || rsize != productiveRule.size()) {
            psize = productiveNT.size();
            rsize = productiveRule.size();
            for (NonterminalSymbol nt : rulesBySymbol.keySet()) {
                boolean isProductiveSymbol = false;
                for (Rule rule : this.rules) {
                    boolean isProductiveRule;
                    if (!nt.equals(rule.getSymbol()) || (isProductiveRule = productiveRule.contains(rule))) continue;
                    isProductiveRule = true;
                    for (Symbol s : rule.getRhs().symbols) {
                        if (!(s instanceof NonterminalSymbol) || productiveNT.contains((NonterminalSymbol)s)) continue;
                        isProductiveRule = false;
                        break;
                    }
                    if (!isProductiveRule) continue;
                    productiveRule.add(rule);
                    isProductiveSymbol = true;
                }
                if (!isProductiveSymbol) continue;
                productiveNT.add(nt);
            }
        }
        for (NonterminalSymbol s : rulesBySymbol.keySet()) {
            if (productiveNT.contains(s)) continue;
            this.addUnproductive(s);
        }
        for (Rule rule : this.rules) {
            if (productiveRule.contains(rule)) continue;
            this.addUnproductive(rule);
        }
    }

    private void walk(NonterminalSymbol symbol, HashSet<NonterminalSymbol> reachable) {
        reachable.add(symbol);
        for (Rule rule : this.rules) {
            if (!rule.getSymbol().equals(symbol)) continue;
            for (Symbol s : rule.getRhs().symbols) {
                NonterminalSymbol nt;
                if (!(s instanceof NonterminalSymbol) || reachable.contains(nt = (NonterminalSymbol)s)) continue;
                this.walk(nt, reachable);
            }
        }
    }

    protected List<NonterminalSymbol> undefinedSymbols() {
        HashSet<NonterminalSymbol> definedNames = new HashSet<NonterminalSymbol>();
        HashSet<NonterminalSymbol> usedNames = new HashSet<NonterminalSymbol>();
        for (Rule rule : this.rules) {
            definedNames.add(rule.getSymbol());
            for (Symbol s : rule.getRhs().symbols) {
                if (!(s instanceof NonterminalSymbol)) continue;
                usedNames.add((NonterminalSymbol)s);
            }
        }
        ArrayList<NonterminalSymbol> unused = new ArrayList<NonterminalSymbol>();
        for (NonterminalSymbol nt : usedNames) {
            if (definedNames.contains(nt)) continue;
            unused.add(nt);
        }
        return unused;
    }

    public boolean isClean() {
        return this.unproductiveRules.isEmpty() && this.unproductiveSymbols.isEmpty() && this.unreachableSymbols.isEmpty() && this.undefinedSymbols.isEmpty();
    }

    public ParserGrammar getCompiledGrammar() {
        return this.parserGrammar;
    }

    public Set<Rule> getUnproductiveRules() {
        return this.unproductiveRules;
    }

    public Set<NonterminalSymbol> getUnproductiveSymbols() {
        return this.unproductiveSymbols;
    }

    public Set<NonterminalSymbol> getUnreachableSymbols() {
        return this.unreachableSymbols;
    }

    public Set<NonterminalSymbol> getUndefinedSymbols() {
        return this.undefinedSymbols;
    }

    protected void addUnreachable(NonterminalSymbol symbol) {
        if (this.unreachableSymbols.contains(symbol)) {
            return;
        }
        this.unreachableSymbols.add(symbol);
        if (this.parserGrammar != null) {
            this.parserGrammar.getParserOptions().getLogger().warn(logcategory, "Unreachable symbol: %s", symbol);
        }
    }

    protected void addUndefined(NonterminalSymbol symbol) {
        if (this.undefinedSymbols.contains(symbol)) {
            return;
        }
        this.undefinedSymbols.add(symbol);
        if (this.parserGrammar != null) {
            this.parserGrammar.getParserOptions().getLogger().warn(logcategory, "Undefined symbol: %s", symbol);
        }
    }

    protected void addUnproductive(NonterminalSymbol symbol) {
        if (this.unproductiveSymbols.contains(symbol)) {
            return;
        }
        this.unproductiveSymbols.add(symbol);
        if (this.parserGrammar != null) {
            this.parserGrammar.getParserOptions().getLogger().warn(logcategory, "Unproductive symbol: %s", symbol);
        }
    }

    protected void addUnproductive(Rule rule) {
        if (this.unproductiveRules.contains(rule)) {
            return;
        }
        this.unproductiveRules.add(rule);
        if (this.parserGrammar != null) {
            this.parserGrammar.getParserOptions().getLogger().warn(logcategory, "Unproductive rule: %s", rule);
        }
    }
}

