/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.nineml.coffeegrinder.exceptions.ForestException;
import org.nineml.coffeegrinder.parser.Family;
import org.nineml.coffeegrinder.parser.ForestNode;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.ParseTree;
import org.nineml.coffeegrinder.parser.ParserOptions;
import org.nineml.coffeegrinder.parser.RuleChoice;
import org.nineml.coffeegrinder.parser.State;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.parser.TerminalSymbol;
import org.nineml.coffeegrinder.parser.TreeBuilder;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.util.NopTreeBuilder;
import org.nineml.coffeegrinder.util.ParseTreeBuilder;
import org.nineml.coffeegrinder.util.ParserAttribute;
import org.nineml.coffeegrinder.util.StopWatch;

public class ParseForest {
    public static final String logcategory = "Forest";
    protected final ArrayList<ForestNode> graph = new ArrayList();
    protected final ArrayList<ForestNode> roots = new ArrayList();
    protected final HashSet<Integer> graphIds = new HashSet();
    protected final HashSet<Integer> rootIds = new HashSet();
    protected final ParserOptions options;
    protected Boolean ambiguous = null;
    protected Boolean infinitelyAmbiguous = null;
    private Stack<PendingAction> pendingActions = null;

    public ParseForest(ParserOptions options) {
        this.options = options;
    }

    public boolean isAmbiguous() {
        if (this.ambiguous == null) {
            this.ambiguous = this.roots.size() > 1;
            NopTreeBuilder builder = new NopTreeBuilder();
            this.getTree(builder);
            this.ambiguous = this.ambiguous != false || builder.isAmbiguous();
            this.infinitelyAmbiguous = builder.isInfinitelyAmbiguous();
        }
        return this.ambiguous;
    }

    public boolean isInfinitelyAmbiguous() {
        return this.infinitelyAmbiguous;
    }

    public int size() {
        return this.graph.size();
    }

    public List<ForestNode> getNodes() {
        return this.graph;
    }

    public List<ForestNode> getRoots() {
        return this.roots;
    }

    public ParserOptions getOptions() {
        return this.options;
    }

    public ParseTree getTree() {
        ParseTreeBuilder parseTreeBuilder = new ParseTreeBuilder();
        this.getTree(parseTreeBuilder);
        return parseTreeBuilder.getParseTree();
    }

    public void getTree(TreeBuilder builder) {
        ForestNode root;
        if (this.roots.isEmpty()) {
            return;
        }
        builder.startTree();
        ArrayList<RuleChoice> rootChoice = new ArrayList<RuleChoice>(this.roots);
        if (this.roots.size() > 1) {
            int idx = builder.startAlternative(rootChoice);
            if (idx < 0 || idx >= this.roots.size()) {
                throw new IllegalStateException("Invalid alternative selected");
            }
            root = this.roots.get(idx);
        } else {
            root = this.roots.get(0);
        }
        this.constructTree(builder, root);
        if (this.roots.size() > 1) {
            builder.endAlternative(root);
        }
        builder.endTree();
        this.ambiguous = builder.isAmbiguous();
        this.infinitelyAmbiguous = builder.isInfinitelyAmbiguous();
    }

    public void constructTree(TreeBuilder builder, ForestNode root) {
        this.pendingActions = new Stack();
        this.pendingActions.push(new PendingTree(root, null));
        HashSet<Family> seen = new HashSet<Family>();
        block6: while (!this.pendingActions.isEmpty()) {
            PendingAction top = this.pendingActions.pop();
            switch (top.action) {
                case START: {
                    PendingStart start = (PendingStart)top;
                    builder.startNonterminal(start.symbol, start.attributes, start.leftExtent, start.rightExtent);
                    continue block6;
                }
                case END: {
                    PendingEnd end = (PendingEnd)top;
                    builder.endNonterminal(end.symbol, end.attributes, end.leftExtent, end.rightExtent);
                    continue block6;
                }
                case TREE: {
                    PendingTree tree = (PendingTree)top;
                    this.constructTree(builder, tree.tree, tree.xsymbol, seen);
                    continue block6;
                }
                case END_ALTERNATIVES: {
                    builder.endAlternative(((PendingEndAlternatives)top).selectedAlternative);
                    continue block6;
                }
            }
            throw new IllegalStateException("Unexpected pending action: " + (Object)((Object)top.action));
        }
    }

    private void constructTree(TreeBuilder builder, ForestNode tree, Symbol xsymbol, HashSet<Family> selected) {
        Map<String, String> atts;
        Symbol symbol;
        ArrayList<Family> families;
        HashMap<Family, Integer> edgeCounts;
        ForestNode child0 = null;
        Symbol child0Symbol = null;
        ForestNode child1 = null;
        Symbol child1Symbol = null;
        assert (tree != null);
        State state = tree.getState();
        int index = 0;
        boolean alternatives = false;
        int lowest = Integer.MAX_VALUE;
        RuleChoice selectedAlternative = null;
        switch (tree.families.size()) {
            case 0: 
            case 1: {
                edgeCounts = null;
                families = tree.families;
                break;
            }
            default: {
                edgeCounts = builder.getEdgeCounts(tree);
                for (Integer count : edgeCounts.values()) {
                    if (count >= lowest) continue;
                    lowest = count;
                }
                families = new ArrayList();
                for (Family family : tree.families) {
                    if (family.v == null && family.w == null) {
                        families.add(family);
                        continue;
                    }
                    if (selected.contains(family)) {
                        builder.loop(family.v);
                    }
                    if (edgeCounts.get(family) != lowest) continue;
                    families.add(family);
                }
                if (families.size() <= 1) break;
                ArrayList<RuleChoice> choices = new ArrayList<RuleChoice>(families);
                index = builder.startAlternative(choices);
                if (index < 0 || index >= choices.size()) {
                    throw new IllegalStateException("Invalid alternative selected");
                }
                selectedAlternative = families.get(index);
                alternatives = true;
            }
        }
        if (!families.isEmpty()) {
            Family family = families.get(index);
            if (edgeCounts != null && (family.v != null || family.w != null)) {
                edgeCounts.put(family, lowest + 1);
            }
            selected.add(family);
            if (family.w == null) {
                child0 = family.v;
            } else {
                child0 = family.w;
                child1 = family.v;
            }
        }
        if ("Earley".equals(this.options.getParserType()) || tree.getSymbol() == null || tree.getSymbol().equals(state.getSymbol())) {
            int pos;
            if (child1 != null) {
                int pos2 = this.getSymbol(child1.getSymbol(), state, state.getPosition());
                if (pos2 >= 0) {
                    child1Symbol = state.getRhs().get(pos2);
                } else {
                    pos2 = state.getPosition();
                }
                pos2 = this.getSymbol(child0.getSymbol(), state, pos2);
                if (pos2 >= 0) {
                    child0Symbol = state.getRhs().get(pos2);
                }
            } else if (child0 != null && (pos = this.getSymbol(child0.getSymbol(), state, state.getPosition())) >= 0) {
                child0Symbol = state.getRhs().get(pos);
            }
        }
        if ((symbol = tree.getSymbol()) == null) {
            assert (child0 != null);
            if (alternatives) {
                this.pendingActions.push(new PendingEndAlternatives(selectedAlternative));
            }
            if (child1 != null) {
                this.pendingActions.push(new PendingTree(child1, child1Symbol));
            }
            this.pendingActions.push(new PendingTree(child0, child0Symbol));
            return;
        }
        if (symbol.getAttributes().isEmpty() && (xsymbol == null || xsymbol.getAttributes().isEmpty())) {
            atts = Collections.emptyMap();
        } else {
            HashMap<String, String> xatts = new HashMap<String, String>(symbol.getAttributesMap());
            if (xsymbol != null) {
                xatts.putAll(xsymbol.getAttributesMap());
            }
            atts = xatts;
        }
        boolean prunable = false;
        if (!this.pendingActions.isEmpty() && !this.options.getExposePrunableNonterminals()) {
            prunable = "allowed".equals(atts.getOrDefault("https://nineml.org/attr/prune", "forbidden"));
        }
        if (symbol instanceof TerminalSymbol) {
            Token token = ((TerminalSymbol)symbol).getToken();
            builder.token(token, atts);
        } else {
            if (alternatives) {
                this.pendingActions.push(new PendingEndAlternatives(selectedAlternative));
            }
            if (!prunable) {
                this.pendingActions.push(new PendingEnd((NonterminalSymbol)symbol, atts, tree.leftExtent, tree.rightExtent));
            }
            if (child1 != null) {
                this.pendingActions.push(new PendingTree(child1, child1Symbol));
            }
            if (child0 != null) {
                this.pendingActions.push(new PendingTree(child0, child0Symbol));
            }
            if (!prunable) {
                this.pendingActions.push(new PendingStart((NonterminalSymbol)symbol, atts, tree.leftExtent, tree.rightExtent));
            }
        }
    }

    private int getSymbol(Symbol seek, State state, int maxPos) {
        int found = -1;
        if (seek instanceof TerminalSymbol) {
            Token token = ((TerminalSymbol)seek).getToken();
            for (int pos = 0; pos < maxPos; ++pos) {
                if (!state.getRhs().get(pos).matches(token)) continue;
                found = pos;
            }
        } else {
            for (int pos = 0; pos < maxPos; ++pos) {
                if (!state.getRhs().get(pos).equals(seek)) continue;
                found = pos;
            }
        }
        return found;
    }

    public String serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.serialize(ps);
        try {
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Unexpected (i.e. impossible) unsupported encoding exception", ex);
        }
    }

    public void serialize(PrintStream stream) {
        stream.println("<sppf>");
        int count = 0;
        for (ForestNode node : this.graph) {
            stream.printf("  <u%d id='%s'", count, this.id(node.hashCode()));
            stream.printf(" hash='%d'", node.nodeHash);
            String symstr = null;
            String stastr = null;
            if (node.symbol != null) {
                symstr = node.symbol.toString().replace("&", "&amp;");
                symstr = symstr.replace("<", "&lt;").replace("\"", "&quot;");
            }
            if (node.state != null && (node.families.size() != 1 || node.families.get((int)0).v != null)) {
                stastr = node.state.toString().replace("&", "&amp;");
                stastr = stastr.replace("<", "&lt;").replace("\"", "&quot;");
            }
            StringBuilder attrs = new StringBuilder();
            if (node.symbol == null) {
                assert (node.state != null);
                stream.printf(" label=\"%s\"", stastr);
                stream.print(" type='state'");
            } else {
                if (stastr == null) {
                    stream.printf(" label=\"%s\"", symstr);
                } else {
                    stream.printf(" label=\"%s\" state=\"%s\"", symstr, stastr);
                }
                if (node.symbol instanceof TerminalSymbol) {
                    stream.print(" type='terminal'");
                } else {
                    stream.print(" type='nonterminal'");
                }
                Collection<ParserAttribute> pattrs = node.symbol instanceof TerminalSymbol ? ((TerminalSymbol)node.symbol).getToken().getAttributes() : node.symbol.getAttributes();
                for (ParserAttribute attr : pattrs) {
                    attrs.append("    <attr name=\"").append(attr.getName());
                    attrs.append("\" value=\"").append(attr.getValue()).append("\"/>\n");
                }
            }
            stream.printf(" leftExtent='%d' rightExtent='%d'", node.leftExtent, node.rightExtent);
            if (!node.families.isEmpty()) {
                stream.printf(" trees='%d'", node.families.size());
            }
            if (node.families.isEmpty()) {
                if ("".equals(attrs.toString())) {
                    stream.println("/>");
                } else {
                    stream.println(">");
                    stream.print(attrs);
                    stream.printf("  </u%d>\n", count);
                }
            } else {
                stream.println(">");
                for (Family family : node.families) {
                    if (family.w != null) {
                        if (family.v != null) {
                            stream.println("    <pair>");
                            stream.printf("      <link target='%s'/>\n", this.id(family.w.hashCode()));
                            stream.printf("      <link target='%s'/>\n", this.id(family.v.hashCode()));
                            stream.println("    </pair>");
                            continue;
                        }
                        stream.printf("      <link target='%s'/>\n", this.id(family.w.hashCode()));
                        continue;
                    }
                    if (family.v == null) {
                        stream.println("    <epsilon/>");
                        continue;
                    }
                    stream.printf("    <link target='%s'/>\n", this.id(family.v.hashCode()));
                }
                stream.printf("  </u%d>\n", count);
            }
            ++count;
        }
        stream.println("</sppf>");
    }

    public void serialize(String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            PrintStream stream = new PrintStream(fos);
            this.serialize(stream);
            stream.close();
            fos.close();
        }
        catch (IOException ex) {
            throw ForestException.ioError(filename, ex);
        }
    }

    protected ForestNode createNode(Symbol symbol, int j, int i) {
        ForestNode node = new ForestNode(this, symbol, j, i);
        this.graph.add(node);
        this.graphIds.add(node.id);
        return node;
    }

    protected ForestNode createNode(Symbol symbol, State state, int j, int i) {
        ForestNode node = new ForestNode(this, symbol, state, j, i);
        this.graph.add(node);
        this.graphIds.add(node.id);
        return node;
    }

    protected ForestNode createNode(State state, int j, int i) {
        ForestNode node = new ForestNode(this, state, j, i);
        this.graph.add(node);
        this.graphIds.add(node.id);
        return node;
    }

    protected void root(ForestNode w) {
        if (this.rootIds.contains(w.id)) {
            return;
        }
        if (this.graphIds.contains(w.id)) {
            this.roots.add(w);
            this.rootIds.add(w.id);
            return;
        }
        throw ForestException.noSuchNode(w.toString());
    }

    protected void clearRoots() {
        this.roots.clear();
        this.rootIds.clear();
    }

    protected void prune() {
        StopWatch timer = new StopWatch();
        for (ForestNode root : this.roots) {
            root.reach();
        }
        int count = 0;
        ArrayList<ForestNode> prunedGraph = new ArrayList<ForestNode>();
        HashSet<Integer> prunedMap = new HashSet<Integer>();
        for (ForestNode node : this.graph) {
            if (node.reachable) {
                prunedGraph.add(node);
                prunedMap.add(node.id);
                continue;
            }
            ++count;
        }
        this.graph.clear();
        this.graph.addAll(prunedGraph);
        this.graphIds.clear();
        this.graphIds.addAll(prunedMap);
        timer.stop();
        this.options.getLogger().debug(logcategory, "Pruned %,d unreachable nodes from graph in %,dms; %,d remain", count, timer.duration(), this.graph.size());
    }

    private String id(int code) {
        if (code < 0) {
            return "id_" + Math.abs(code);
        }
        return "id" + code;
    }

    protected void rollback(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Cannot rollback to less than zero nodes");
        }
        while (this.graph.size() > size) {
            ForestNode node = this.graph.remove(this.graph.size() - 1);
            this.graphIds.remove(node.id);
            this.rootIds.remove(node.id);
        }
    }

    private static class PendingEndAlternatives
    extends PendingAction {
        public final RuleChoice selectedAlternative;

        public PendingEndAlternatives(RuleChoice selectedAlternative) {
            super(PendingType.END_ALTERNATIVES);
            this.selectedAlternative = selectedAlternative;
        }
    }

    private static class PendingTree
    extends PendingAction {
        public final ForestNode tree;
        public final Symbol xsymbol;

        public PendingTree(ForestNode tree, Symbol xsymbol) {
            super(PendingType.TREE);
            this.tree = tree;
            this.xsymbol = xsymbol;
        }
    }

    private static class PendingEnd
    extends PendingAction {
        public final NonterminalSymbol symbol;
        public final Map<String, String> attributes;
        public final int leftExtent;
        public final int rightExtent;

        public PendingEnd(NonterminalSymbol symbol, Map<String, String> attributes, int leftExtent, int rightExtent) {
            super(PendingType.END);
            this.symbol = symbol;
            this.attributes = attributes;
            this.leftExtent = leftExtent;
            this.rightExtent = rightExtent;
        }
    }

    private static class PendingStart
    extends PendingAction {
        public final NonterminalSymbol symbol;
        public final Map<String, String> attributes;
        public final int leftExtent;
        public final int rightExtent;

        public PendingStart(NonterminalSymbol symbol, Map<String, String> attributes, int leftExtent, int rightExtent) {
            super(PendingType.START);
            this.symbol = symbol;
            this.attributes = attributes;
            this.leftExtent = leftExtent;
            this.rightExtent = rightExtent;
        }
    }

    private static abstract class PendingAction {
        private final PendingType action;

        public PendingAction(PendingType action) {
            this.action = action;
        }
    }

    private static enum PendingType {
        START,
        END,
        TREE,
        END_ALTERNATIVES;

    }
}

