/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.nineml.coffeegrinder.parser.Family;
import org.nineml.coffeegrinder.parser.ForestNode;
import org.nineml.coffeegrinder.parser.ForestNodeGLL;
import org.nineml.coffeegrinder.parser.ParseForest;
import org.nineml.coffeegrinder.parser.ParserGrammar;
import org.nineml.coffeegrinder.parser.ParserOptions;
import org.nineml.coffeegrinder.parser.State;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.parser.TerminalSymbol;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.tokens.TokenRegex;
import org.nineml.coffeegrinder.tokens.TokenString;
import org.nineml.coffeegrinder.util.ParserAttribute;

public class ParseForestGLL
extends ParseForest {
    private final HashSet<ForestNodeGLL> extendedLeaves;
    private final ArrayList<ForestNodeGLL> candidateLeaves;
    private final HashMap<Symbol, PrefixTrie> intermediate;
    private final HashMap<Symbol, PrefixTrie> slotPrefixes;
    private final HashMap<Symbol, HashMap<Integer, HashMap<Integer, ArrayList<ForestNodeGLL>>>> nodes;
    private final HashMap<PrefixTrie, HashMap<Integer, HashMap<Integer, ArrayList<ForestNodeGLL>>>> slots;
    private final ParserGrammar grammar;
    private final int rightExtent;
    private final Token[] inputTokens;
    private final Map<Integer, String> regexMatches;

    public ParseForestGLL(ParserOptions options, ParserGrammar grammar, int rightExtent, Token[] inputTokens, Map<Integer, String> regexMatches) {
        super(options);
        this.grammar = grammar;
        this.rightExtent = rightExtent;
        this.inputTokens = inputTokens;
        this.regexMatches = regexMatches;
        this.intermediate = new HashMap();
        this.slotPrefixes = new HashMap();
        this.nodes = new HashMap();
        this.slots = new HashMap();
        this.extendedLeaves = new HashSet();
        this.candidateLeaves = new ArrayList();
    }

    public ForestNodeGLL findOrCreate(State state, Symbol symbol, int leftExtent, int rightExtent) {
        if (symbol instanceof TerminalSymbol) {
            ArrayList<ParserAttribute> attr;
            if (((TerminalSymbol)symbol).getToken() instanceof TokenRegex) {
                attr = new ArrayList<ParserAttribute>(symbol.getAttributes());
                attr.addAll(this.inputTokens[leftExtent].getAttributes());
                symbol = new TerminalSymbol((Token)TokenString.get(this.regexMatches.get(leftExtent)), attr);
            } else if (leftExtent + 1 == rightExtent) {
                attr = new ArrayList<ParserAttribute>(symbol.getAttributes());
                attr.addAll(this.inputTokens[leftExtent].getAttributes());
                symbol = new TerminalSymbol(this.inputTokens[leftExtent], attr);
            }
        }
        if (!this.nodes.containsKey(symbol)) {
            this.nodes.put(symbol, new HashMap());
        }
        if (!this.nodes.get(symbol).containsKey(leftExtent)) {
            this.nodes.get(symbol).put(leftExtent, new HashMap());
        }
        if (!this.nodes.get(symbol).get(leftExtent).containsKey(rightExtent)) {
            ForestNodeGLL node = new ForestNodeGLL(this, symbol, state, leftExtent, rightExtent);
            if (!(symbol instanceof TerminalSymbol) && !this.extendedLeaves.contains(node)) {
                this.candidateLeaves.add(node);
            }
            this.graph.add(node);
            this.graphIds.add(node.id);
            ArrayList<ForestNodeGLL> list = new ArrayList<ForestNodeGLL>();
            list.add(node);
            this.nodes.get(symbol).get(leftExtent).put(rightExtent, list);
            return node;
        }
        return this.nodes.get(symbol).get(leftExtent).get(rightExtent).get(0);
    }

    protected ForestNodeGLL findOrCreate(State slot, int leftExtent, int rightExtent) {
        PrefixTrie trie = this.getPrefix(slot, this.slotPrefixes);
        if (!this.slots.containsKey(trie)) {
            this.slots.put(trie, new HashMap());
        }
        if (!this.slots.get(trie).containsKey(leftExtent)) {
            this.slots.get(trie).put(leftExtent, new HashMap());
        }
        if (!this.slots.get(trie).get(leftExtent).containsKey(rightExtent)) {
            ForestNodeGLL node = new ForestNodeGLL((ParseForest)this, slot, leftExtent, rightExtent);
            if (!this.extendedLeaves.contains(node)) {
                this.candidateLeaves.add(node);
            }
            this.graph.add(node);
            this.graphIds.add(node.id);
            ArrayList<ForestNodeGLL> list = new ArrayList<ForestNodeGLL>();
            list.add(node);
            this.slots.get(trie).get(leftExtent).put(rightExtent, list);
            return node;
        }
        return this.slots.get(trie).get(leftExtent).get(rightExtent).get(0);
    }

    public ForestNodeGLL extendableLeaf() {
        if (this.candidateLeaves.isEmpty()) {
            return null;
        }
        ForestNodeGLL leaf = this.candidateLeaves.remove(0);
        this.extendedLeaves.add(leaf);
        return leaf;
    }

    protected ForestNodeGLL create(State slot, int pivot) {
        PrefixTrie trie = this.getPrefix(slot, this.intermediate);
        if (!trie.nodes.containsKey(pivot)) {
            trie.nodes.put(pivot, new ArrayList());
        }
        ForestNodeGLL node = new ForestNodeGLL(this, slot, pivot);
        trie.nodes.get(pivot).add(node);
        return node;
    }

    private PrefixTrie getPrefix(State slot, HashMap<Symbol, PrefixTrie> root) {
        Symbol start = slot.position == 0 ? TerminalSymbol.EPSILON : slot.rhs.get(0);
        if (!root.containsKey(start)) {
            root.put(start, new PrefixTrie(start));
        }
        PrefixTrie trie = root.get(start);
        for (int pos = 1; pos < slot.position; ++pos) {
            trie = trie.child(slot.rhs.get(pos));
        }
        return trie;
    }

    public ForestNodeGLL mkPN(State slot, int leftExtent, int pivot, int rightExtent) {
        ForestNodeGLL y = this.create(slot, pivot);
        if (slot.position == 0) {
            this.mkN(slot, TerminalSymbol.EPSILON, leftExtent, leftExtent, y);
        }
        if (slot.position > 0) {
            Symbol x = slot.prevSymbol();
            this.mkN(slot, x, pivot, rightExtent, y);
            if (slot.position == 2) {
                this.mkN(slot, slot.rhs.get(0), leftExtent, pivot, y);
            } else if (slot.position > 2) {
                assert (slot.rule != null);
                State newSlot = new State(slot.rule, slot.position - 1);
                this.mkN(newSlot, leftExtent, pivot, y);
            }
        }
        return y;
    }

    protected void mkN(State state, Symbol symbol, int leftExtent, int rightExtent, ForestNodeGLL parent) {
        ForestNodeGLL node = this.findOrCreate(state, symbol, leftExtent, rightExtent);
        parent.addEdge(node);
    }

    protected void mkN(State slot, int leftExtent, int rightExtent, ForestNodeGLL parent) {
        ForestNodeGLL node = this.findOrCreate(slot, leftExtent, rightExtent);
        parent.addEdge(node);
    }

    @Override
    public void prune() {
        ForestNode epsilon = null;
        for (ForestNode fnode : this.graph) {
            for (Family family : fnode.families) {
                if (family.w != null || family.v.symbol != TerminalSymbol.EPSILON) continue;
                family.v = null;
            }
            if (fnode.symbol == TerminalSymbol.EPSILON) {
                epsilon = fnode;
            }
            if (!this.grammar.getSeed().equals(fnode.symbol) || fnode.leftExtent != 0 || fnode.rightExtent != this.rightExtent) continue;
            this.roots.add(fnode);
            this.rootIds.add(fnode.id);
        }
        if (epsilon != null) {
            this.graph.remove(epsilon);
        }
        super.prune();
    }

    private static class PrefixTrie {
        public final Symbol symbol;
        public final HashMap<Symbol, PrefixTrie> children;
        public final HashMap<Integer, ArrayList<ForestNodeGLL>> nodes;

        public PrefixTrie(Symbol symbol) {
            this.symbol = symbol;
            this.children = new HashMap();
            this.nodes = new HashMap();
        }

        public PrefixTrie child(Symbol symbol) {
            if (this.children.containsKey(symbol)) {
                return this.children.get(symbol);
            }
            PrefixTrie newchild = new PrefixTrie(symbol);
            this.children.put(symbol, newchild);
            return newchild;
        }
    }
}

