/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nineml.coffeegrinder.exceptions.ForestException;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.parser.TerminalSymbol;
import org.nineml.coffeegrinder.tokens.Token;

public class ParseTree {
    private final NonterminalSymbol symbol;
    private final Token token;
    public ArrayList<ParseTree> children = null;
    private ParseTree parent = null;
    private HashMap<String, String> attributes = null;

    public ParseTree(NonterminalSymbol symbol, Map<String, String> attrs) {
        this.symbol = symbol;
        this.token = null;
        if (!attrs.isEmpty()) {
            this.attributes = new HashMap<String, String>(attrs);
        }
    }

    public ParseTree(Token token, Map<String, String> attrs) {
        this.symbol = null;
        this.token = token;
        if (!attrs.isEmpty()) {
            this.attributes = new HashMap<String, String>(attrs);
        }
    }

    public ParseTree addChild(NonterminalSymbol symbol, Map<String, String> attrs) {
        return this.addChild(new ParseTree(symbol, attrs));
    }

    public void addChild(Token token, Map<String, String> attrs) {
        this.addChild(new ParseTree(token, attrs));
    }

    private ParseTree addChild(ParseTree child) {
        if (this.symbol == null) {
            throw new IllegalStateException("Cannot add children to a leaf node.");
        }
        child.parent = this;
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        return child;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public Token getToken() {
        return this.token;
    }

    public String getAttribute(String name, String defaultValue) {
        return this.attributes == null ? defaultValue : this.attributes.getOrDefault(name, defaultValue);
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return this.attributes;
    }

    public ParseTree getParent() {
        return this.parent;
    }

    public List<ParseTree> getChildren() {
        return this.children;
    }

    public String serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.serialize(ps);
        try {
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Unexpected (i.e. impossible) unsupported encoding exception", ex);
        }
    }

    public void serialize(PrintStream stream) {
        boolean nonterminal = true;
        if (this.symbol != null) {
            nonterminal = !(this.getSymbol() instanceof TerminalSymbol);
            String xml = this.getSymbol().toString().replace("&", "&amp;");
            xml = xml.replace("<", "&lt;").replace("\"", "&quot;");
            stream.printf("<symbol label=\"%s\"", xml);
            if (this.children == null) {
                stream.printf("><epsilon/></symbol>%n", new Object[0]);
            } else {
                stream.print(">");
                for (ParseTree child : this.children) {
                    child.serialize(stream);
                }
                stream.printf("</symbol>%n", new Object[0]);
            }
        } else {
            stream.print("DATA");
        }
    }

    public void serialize(String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            PrintStream stream = new PrintStream(fos);
            this.serialize(stream);
            stream.close();
            fos.close();
        }
        catch (IOException ex) {
            throw ForestException.ioError(filename, ex);
        }
    }

    public String toString() {
        if (this.symbol == null) {
            return this.token.getValue();
        }
        return this.symbol.toString();
    }
}

