/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nineml.coffeegrinder.gll.GllParser;
import org.nineml.coffeegrinder.parser.EarleyParser;
import org.nineml.coffeegrinder.parser.GearleyParser;
import org.nineml.coffeegrinder.parser.Grammar;
import org.nineml.coffeegrinder.parser.HygieneReport;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.ParserOptions;
import org.nineml.coffeegrinder.parser.ParserType;
import org.nineml.coffeegrinder.parser.Rule;
import org.nineml.coffeegrinder.parser.SourceGrammar;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.parser.TerminalSymbol;
import org.nineml.coffeegrinder.util.RegexCompiler;

public class ParserGrammar
extends Grammar {
    private final ParserType parserType;
    private final NonterminalSymbol seed;
    private final HashSet<Symbol> nullable;
    private final ParserOptions options;
    private final HashMap<NonterminalSymbol, HashSet<Symbol>> firstSets = new HashMap();
    private final HashMap<NonterminalSymbol, HashSet<Symbol>> followSets = new HashMap();
    private boolean computedSets = false;

    protected ParserGrammar(SourceGrammar grammar, ParserType parserType, NonterminalSymbol seed) {
        this.parserType = parserType;
        this.seed = seed;
        this.rules.addAll(grammar.getRules());
        this.metadata.putAll(grammar.getMetadataProperies());
        for (Rule rule : this.rules) {
            if (!this.rulesBySymbol.containsKey(rule.symbol)) {
                this.rulesBySymbol.put(rule.symbol, new ArrayList());
            }
            ((List)this.rulesBySymbol.get(rule.symbol)).add(rule);
        }
        this.options = grammar.getParserOptions();
        this.nullable = new HashSet();
        if (parserType == ParserType.Earley) {
            this.computeEarleyNullable();
        } else {
            this.computeGllNullable();
        }
    }

    public NonterminalSymbol getSeed() {
        return this.seed;
    }

    public ParserOptions getParserOptions() {
        return this.options;
    }

    public GearleyParser getParser(ParserOptions options) {
        if (this.parserType == ParserType.Earley) {
            return new EarleyParser(this, options);
        }
        return new GllParser(this, options);
    }

    @Override
    public boolean isNullable(Symbol symbol) {
        if (symbol instanceof NonterminalSymbol) {
            return this.nullable.contains(symbol);
        }
        return false;
    }

    public HygieneReport getHygieneReport() {
        return new HygieneReport(this);
    }

    public Set<Symbol> getFirst(Symbol symbol) {
        this.computeFirstAndFollowSets();
        HashSet<Symbol> firstSet = symbol instanceof NonterminalSymbol && this.firstSets.containsKey(symbol) ? this.firstSets.get(symbol) : new HashSet<Symbol>();
        if (!(symbol instanceof NonterminalSymbol)) {
            firstSet.add(symbol);
        }
        return firstSet;
    }

    public Set<Symbol> getFollow(Symbol symbol) {
        this.computeFirstAndFollowSets();
        HashSet<Symbol> followSet = symbol instanceof NonterminalSymbol && this.followSets.containsKey(symbol) ? this.followSets.get(symbol) : new HashSet<Symbol>();
        return followSet;
    }

    private void computeFirstAndFollowSets() {
        HashSet<Symbol> first;
        if (this.computedSets) {
            return;
        }
        if (this.seed == null) {
            throw new NullPointerException("Start symbol is null");
        }
        this.computedSets = true;
        this.firstSets.clear();
        this.followSets.clear();
        block0: for (Rule rule : this.rules) {
            if (!this.firstSets.containsKey(rule.symbol)) {
                this.firstSets.put(rule.symbol, new HashSet());
                this.followSets.put(rule.symbol, new HashSet());
            }
            if (rule.epsilonRule()) {
                this.firstSets.get(rule.symbol).add(TerminalSymbol.EPSILON);
            }
            first = this.firstSets.get(rule.symbol);
            for (Symbol symbol : rule.rhs.symbols) {
                first.add(symbol);
                if (!this.nullable.contains(symbol)) continue block0;
            }
        }
        for (NonterminalSymbol symbol : this.firstSets.keySet()) {
            first = this.expandFirstSet(symbol, new HashSet<NonterminalSymbol>());
            this.firstSets.get(symbol).clear();
            this.firstSets.get(symbol).addAll(first);
        }
        this.followSets.get(this.seed).add(TerminalSymbol.EOF);
        for (Rule rule : this.rules) {
            for (int pos = 0; pos < rule.rhs.length; ++pos) {
                NonterminalSymbol prev = pos > 0 && rule.rhs.get(pos - 1) instanceof NonterminalSymbol ? (NonterminalSymbol)rule.rhs.get(pos - 1) : null;
                Symbol symbol = rule.rhs.get(pos);
                if (prev != null) {
                    this.computeFollow(rule, pos, prev);
                }
                if (pos + 1 != rule.rhs.length || !(symbol instanceof NonterminalSymbol)) continue;
                NonterminalSymbol nt = (NonterminalSymbol)symbol;
                HashSet<Symbol> followSet = this.followSets.get(nt);
                if (followSet == null) {
                    followSet = new HashSet();
                    followSet.add(rule.symbol);
                    this.followSets.put(nt, followSet);
                    continue;
                }
                followSet.add(rule.symbol);
            }
        }
        for (NonterminalSymbol symbol : this.followSets.keySet()) {
            HashSet<Symbol> follow = this.expandFollowSet(symbol, new HashSet<NonterminalSymbol>());
            this.followSets.get(symbol).clear();
            this.followSets.get(symbol).addAll(follow);
        }
    }

    private void computeFollow(Rule rule, int pos, NonterminalSymbol symbol) {
        Symbol current = rule.rhs.get(pos);
        if (current instanceof TerminalSymbol) {
            this.followSets.get(symbol).add(current);
            return;
        }
        if (!this.firstSets.containsKey((NonterminalSymbol)current)) {
            return;
        }
        Set first = this.firstSets.get((NonterminalSymbol)current);
        if (!first.contains(TerminalSymbol.EPSILON)) {
            if (this.followSets.containsKey(symbol)) {
                this.followSets.get(symbol).addAll(first);
            }
            return;
        }
        for (Symbol fs : first) {
            if (fs == TerminalSymbol.EPSILON) continue;
            this.followSets.get(symbol).add(fs);
        }
        if (pos + 1 == rule.rhs.length) {
            if (this.followSets.containsKey(symbol)) {
                this.followSets.get(symbol).add(rule.symbol);
            }
        } else {
            this.computeFollow(rule, pos + 1, symbol);
        }
    }

    private HashSet<Symbol> expandFirstSet(NonterminalSymbol symbol, HashSet<NonterminalSymbol> seen) {
        HashSet<Symbol> combined = new HashSet<Symbol>();
        if (!seen.contains(symbol)) {
            seen.add(symbol);
            if (this.firstSets.containsKey(symbol)) {
                for (Symbol first : this.firstSets.get(symbol)) {
                    if (first instanceof TerminalSymbol) {
                        combined.add(first);
                        continue;
                    }
                    combined.addAll(this.expandFirstSet((NonterminalSymbol)first, seen));
                }
            }
        }
        return combined;
    }

    private HashSet<Symbol> expandFollowSet(NonterminalSymbol symbol, HashSet<NonterminalSymbol> seen) {
        HashSet<Symbol> combined = new HashSet<Symbol>();
        if (!seen.contains(symbol)) {
            seen.add(symbol);
            if (this.followSets.containsKey(symbol)) {
                for (Symbol follow : this.followSets.get(symbol)) {
                    if (follow instanceof TerminalSymbol) {
                        combined.add(follow);
                        continue;
                    }
                    combined.addAll(this.expandFollowSet((NonterminalSymbol)follow, seen));
                }
            }
        }
        return combined;
    }

    private void computeEarleyNullable() {
        this.nullable.clear();
        for (Rule rule : this.rules) {
            if (!rule.rhs.isEmpty()) continue;
            this.nullable.add(rule.symbol);
        }
    }

    private void computeGllNullable() {
        this.computeEarleyNullable();
        HashSet<NonterminalSymbol> notNullable = new HashSet<NonterminalSymbol>();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Rule rule : this.rules) {
                if (this.nullable.contains(rule.symbol) || notNullable.contains(rule.symbol)) continue;
                if (rule.rhs.isEmpty()) {
                    this.nullable.add(rule.symbol);
                    changed = true;
                    continue;
                }
                boolean canBeNull = true;
                for (Symbol symbol : rule.rhs.symbols) {
                    if (symbol instanceof TerminalSymbol || notNullable.contains(symbol)) {
                        notNullable.add(rule.symbol);
                        changed = true;
                        canBeNull = false;
                        continue;
                    }
                    if (this.nullable.contains(symbol)) continue;
                    canBeNull = false;
                }
                if (!canBeNull) continue;
                this.nullable.add(rule.symbol);
                changed = true;
            }
        }
    }

    private String compileRegex(NonterminalSymbol start, List<Rule> sourceRules) {
        RegexCompiler compiler = new RegexCompiler(sourceRules);
        return compiler.compile(start);
    }
}

