/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import org.nineml.coffeegrinder.parser.ProgressMonitor;
import org.nineml.logging.DefaultLogger;
import org.nineml.logging.Logger;

public class ParserOptions {
    private Logger logger;
    private String parserType = "Earley";
    private boolean returnChart = false;
    private boolean prefixParsing = false;
    private boolean exposePrunableNonterminals = false;
    private ProgressMonitor monitor = null;

    public ParserOptions() {
        this.logger = new DefaultLogger();
        this.logger.readSystemProperties();
        String ptype = System.getProperty("org.nineml.coffeegrinder.parser", "Earley");
        try {
            this.setParserType(ptype);
        }
        catch (IllegalArgumentException ex) {
            this.logger.error("Grammar", "Invalid parser type in org.nineml.coffeegrinder.parser system property: " + ptype, new Object[0]);
        }
    }

    public ParserOptions(Logger logger) {
        this.logger = logger;
    }

    public ParserOptions(ParserOptions copy) {
        this.logger = copy.logger;
        this.parserType = copy.parserType;
        this.returnChart = copy.returnChart;
        this.prefixParsing = copy.prefixParsing;
        this.exposePrunableNonterminals = copy.exposePrunableNonterminals;
        this.monitor = copy.monitor;
    }

    public String getParserType() {
        return this.parserType;
    }

    public void setParserType(String parserType) {
        if (!"Earley".equals(parserType) && !"GLL".equals(parserType)) {
            throw new IllegalArgumentException("Unrecognized parser type: " + parserType);
        }
        this.parserType = parserType;
    }

    public boolean getReturnChart() {
        return this.returnChart;
    }

    public void setReturnChart(boolean returnChart) {
        this.returnChart = returnChart;
    }

    public boolean getPrefixParsing() {
        return this.prefixParsing;
    }

    public void setPrefixParsing(boolean prefixParsing) {
        this.prefixParsing = prefixParsing;
    }

    public boolean getExposePrunableNonterminals() {
        return this.exposePrunableNonterminals;
    }

    public void setExposePrunableNonterminals(boolean exposePrunable) {
        this.exposePrunableNonterminals = exposePrunable;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("Logger must not be null");
        }
        this.logger = logger;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

