/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.Arrays;
import java.util.List;
import org.nineml.coffeegrinder.parser.Symbol;

public class RightHandSide {
    public final Symbol[] symbols;
    private final int hcode;
    public final int length;

    public RightHandSide(Symbol[] symbols) {
        this.symbols = symbols;
        this.length = this.symbols.length;
        this.hcode = Arrays.hashCode(this.symbols);
    }

    public RightHandSide(List<Symbol> symbols) {
        this.symbols = new Symbol[symbols.size()];
        symbols.toArray(this.symbols);
        this.length = this.symbols.length;
        this.hcode = Arrays.hashCode(this.symbols);
    }

    public Symbol get(int pos) {
        if (pos < 0 || pos >= this.symbols.length) {
            throw new IndexOutOfBoundsException("No " + pos + " item in symbol list");
        }
        return this.symbols[pos];
    }

    public Symbol getFirst() {
        if (this.symbols.length == 0) {
            return null;
        }
        return this.symbols[0];
    }

    public boolean isEmpty() {
        return this.symbols.length == 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RightHandSide) {
            RightHandSide other = (RightHandSide)obj;
            if (this.symbols.length != other.symbols.length) {
                return false;
            }
            for (int pos = 0; pos < this.symbols.length; ++pos) {
                if (this.symbols[pos].equals(other.symbols[pos])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.hcode;
    }
}

