/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.ArrayList;
import java.util.List;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.RightHandSide;
import org.nineml.coffeegrinder.parser.State;
import org.nineml.coffeegrinder.parser.Symbol;

public class Rule {
    public final NonterminalSymbol symbol;
    public final RightHandSide rhs;

    public Rule(NonterminalSymbol symbol, Symbol ... rhs) {
        if (symbol == null) {
            throw new NullPointerException("Rule name cannot be null");
        }
        this.symbol = symbol;
        this.rhs = new RightHandSide(rhs);
    }

    public Rule(NonterminalSymbol symbol, List<Symbol> rhs) {
        if (symbol == null) {
            throw new NullPointerException("Rule name cannot be null");
        }
        this.symbol = symbol;
        this.rhs = new RightHandSide(rhs);
    }

    public NonterminalSymbol getSymbol() {
        return this.symbol;
    }

    public RightHandSide getRhs() {
        return this.rhs;
    }

    public boolean epsilonRule() {
        return this.rhs.isEmpty();
    }

    public List<State> getSlots() {
        ArrayList<State> ruleSlots = new ArrayList<State>();
        for (int pos = 0; pos <= this.rhs.length; ++pos) {
            ruleSlots.add(new State(this, pos));
        }
        return ruleSlots;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rule) {
            Rule other = (Rule)obj;
            if (this.symbol != other.symbol) {
                return false;
            }
            return this.rhs.equals(other.rhs);
        }
        return false;
    }

    public int hashCode() {
        return this.symbol.hashCode() + this.rhs.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.symbol);
        sb.append(" ::= ");
        int count = 0;
        for (Symbol symbol : this.rhs.symbols) {
            if (count > 0) {
                sb.append(", ");
            }
            sb.append(symbol.toString());
            ++count;
        }
        return sb.toString();
    }
}

