/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nineml.coffeegrinder.exceptions.GrammarException;
import org.nineml.coffeegrinder.gll.GllParser;
import org.nineml.coffeegrinder.parser.EarleyParser;
import org.nineml.coffeegrinder.parser.GearleyParser;
import org.nineml.coffeegrinder.parser.Grammar;
import org.nineml.coffeegrinder.parser.HygieneReport;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.ParserGrammar;
import org.nineml.coffeegrinder.parser.ParserOptions;
import org.nineml.coffeegrinder.parser.ParserType;
import org.nineml.coffeegrinder.parser.Rule;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.util.ParserAttribute;

public class SourceGrammar
extends Grammar {
    public static final String logcategory = "Grammar";
    private static int nextGrammarId = 0;
    private NonterminalSymbol seed = null;
    private ParserOptions options;
    protected final int id = nextGrammarId++;
    protected final ParserType defaultParserType;

    public SourceGrammar() {
        this(new ParserOptions());
    }

    public SourceGrammar(ParserOptions options) {
        this.options = options;
        this.defaultParserType = "Earley".equals(options.getParserType()) ? ParserType.Earley : ParserType.GLL;
        options.getLogger().debug(logcategory, "Created grammar %d", this.id);
    }

    public SourceGrammar(SourceGrammar current) {
        this.options = current.options;
        this.defaultParserType = current.defaultParserType;
        this.seed = null;
        this.options.getLogger().debug(logcategory, "Created grammar %d", this.id);
    }

    public NonterminalSymbol getNonterminal(String name) {
        ArrayList<ParserAttribute> attr = new ArrayList<ParserAttribute>();
        return this.getNonterminal(name, attr);
    }

    public NonterminalSymbol getNonterminal(String name, ParserAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Nonterminal symbol attribute must not be null");
        }
        return this.getNonterminal(name, Collections.singletonList(attribute));
    }

    public NonterminalSymbol getNonterminal(String name, Collection<ParserAttribute> attributes) {
        this.options.getLogger().trace(logcategory, "Creating nonterminal %s for grammar %d", name, this.id);
        return new NonterminalSymbol(this, name, attributes);
    }

    public void addRule(Rule rule) {
        if (this.seed != null) {
            throw GrammarException.grammarIsClosed();
        }
        if (this.contains(rule)) {
            this.options.getLogger().trace(logcategory, "Ignoring duplicate rule: %s", rule);
        } else {
            this.options.getLogger().trace(logcategory, "Adding rule: %s", rule);
            this.rules.add(rule);
            if (!this.rulesBySymbol.containsKey(rule.symbol)) {
                this.rulesBySymbol.put(rule.symbol, new ArrayList());
            }
            ((List)this.rulesBySymbol.get(rule.symbol)).add(rule);
        }
    }

    public void addRule(NonterminalSymbol nonterminal, Symbol ... rhs) {
        this.addRule(new Rule(nonterminal, rhs));
    }

    public void addRule(NonterminalSymbol nonterminal, List<Symbol> rhs) {
        this.addRule(new Rule(nonterminal, rhs));
    }

    @Override
    public boolean isNullable(Symbol symbol) {
        if (symbol instanceof NonterminalSymbol && this.rulesBySymbol.containsKey(symbol)) {
            for (Rule rule : (List)this.rulesBySymbol.get(symbol)) {
                if (!rule.rhs.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public GearleyParser getParser(ParserOptions options, String seed) {
        return this.getParser(options, this.getNonterminal(seed));
    }

    public ParserGrammar getCompiledGrammar(NonterminalSymbol seed) {
        return new ParserGrammar(this, this.defaultParserType, seed);
    }

    public ParserGrammar getCompiledGrammar(ParserType parserType, NonterminalSymbol seed) {
        return new ParserGrammar(this, parserType, seed);
    }

    public GearleyParser getParser(ParserOptions options, NonterminalSymbol seed) {
        ParserType parserType;
        if ("Earley".equals(options.getParserType())) {
            parserType = ParserType.Earley;
        } else if ("GLL".equals(options.getParserType())) {
            parserType = ParserType.GLL;
        } else {
            throw new IllegalStateException("Unexpected parser type: " + options.getParserType());
        }
        ParserGrammar compiled = this.getCompiledGrammar(parserType, seed);
        if (parserType == ParserType.Earley) {
            return new EarleyParser(compiled, options);
        }
        return new GllParser(compiled, options);
    }

    public ParserOptions getParserOptions() {
        return this.options;
    }

    public HygieneReport getHygieneReport(NonterminalSymbol seed) {
        return new HygieneReport(this, seed);
    }

    public boolean contains(Rule candidate) {
        for (Rule rule : this.rules) {
            if (!rule.getSymbol().equals(candidate.getSymbol()) || rule.getRhs().length != candidate.getRhs().length) continue;
            boolean same = true;
            for (int pos = 0; pos < rule.getRhs().length; ++pos) {
                Symbol symbol = rule.getRhs().get(pos);
                Symbol csym = candidate.getRhs().get(pos);
                if (symbol instanceof NonterminalSymbol) {
                    if (csym instanceof NonterminalSymbol) {
                        same = same && ((NonterminalSymbol)symbol).getName().equals(((NonterminalSymbol)csym).getName());
                        continue;
                    }
                    same = false;
                    continue;
                }
                same = same && symbol.equals(csym);
            }
            if (!same) continue;
            return true;
        }
        return false;
    }

    public void setMetadataProperty(String name, String value) {
        if (name == null) {
            throw new NullPointerException("Name must not be null");
        }
        if (value == null) {
            this.metadata.remove(name);
        } else {
            this.metadata.put(name, value);
        }
    }
}

