/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.HashSet;
import java.util.Set;
import org.nineml.coffeegrinder.exceptions.ParseException;
import org.nineml.coffeegrinder.gll.Descriptor;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.ParserGrammar;
import org.nineml.coffeegrinder.parser.RightHandSide;
import org.nineml.coffeegrinder.parser.Rule;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.parser.TerminalSymbol;

public class State {
    public static final State L0 = new State(0);
    private static int nextStateId = 0;
    public final int label;
    public final Rule rule;
    public final NonterminalSymbol symbol;
    public final int position;
    public final RightHandSide rhs;
    private final HashSet<Descriptor> descriptors;
    private int instructionPointer = -1;
    private Integer cachedCode = null;
    private HashSet<Symbol> firstSet = null;

    private State(int num) {
        this.symbol = null;
        this.rule = null;
        this.position = 0;
        this.rhs = new RightHandSide(new Symbol[0]);
        this.label = num;
        nextStateId = num + 1;
        this.descriptors = null;
    }

    public State(Rule rule) {
        this.rule = rule;
        this.symbol = rule.getSymbol();
        this.rhs = rule.getRhs();
        this.position = 0;
        this.label = nextStateId++;
        this.descriptors = new HashSet();
    }

    public State(State other, int position) {
        this.rule = other.rule;
        this.symbol = other.symbol;
        this.rhs = other.rhs;
        this.position = position;
        this.label = nextStateId++;
        this.descriptors = new HashSet();
    }

    public State(Rule rule, int position) {
        this.rule = rule;
        this.symbol = rule.symbol;
        this.rhs = rule.rhs;
        this.position = position;
        this.label = nextStateId++;
        this.descriptors = new HashSet();
    }

    public Symbol nextSymbol() {
        if (this.position >= this.rhs.length) {
            return null;
        }
        return this.rhs.get(this.position);
    }

    public Symbol prevSymbol() {
        if (this.position == 0) {
            return null;
        }
        return this.rhs.get(this.position - 1);
    }

    public void setInstructionPointer(int ip) {
        if (ip < 0) {
            throw new IllegalArgumentException("Instruction pointer must be non-negative");
        }
        if (this.instructionPointer >= 0) {
            throw new IllegalStateException("Cannot move the instruction pointer");
        }
        this.instructionPointer = ip;
    }

    public int getInstructionPointer() {
        return this.instructionPointer;
    }

    public Descriptor getDescriptor(int k, int i) {
        return new Descriptor(this, k, i);
    }

    public NonterminalSymbol getSymbol() {
        return this.symbol;
    }

    public Rule getRule() {
        return this.rule;
    }

    public RightHandSide getRhs() {
        return this.rhs;
    }

    public int getPosition() {
        return this.position;
    }

    public State advance() {
        if (this.position < this.rhs.length) {
            return new State(this, this.position + 1);
        }
        throw ParseException.internalError("Cannot advance a completed state");
    }

    public boolean completed() {
        return this.position == this.rhs.length;
    }

    public Set<Symbol> getFirst(ParserGrammar grammar) {
        if (this.firstSet == null) {
            boolean keepGoing;
            this.firstSet = new HashSet();
            int spos = this.position;
            boolean bl = keepGoing = spos < this.rhs.length;
            while (keepGoing) {
                Set<Symbol> first = grammar.getFirst(this.rhs.get(spos));
                this.firstSet.addAll(first);
                keepGoing = this.firstSet.contains(TerminalSymbol.EPSILON);
                if (grammar.isNullable(this.rhs.get(spos))) {
                    first.add(TerminalSymbol.EPSILON);
                    keepGoing = true;
                }
                if (!keepGoing) {
                    return this.firstSet;
                }
                keepGoing = ++spos < this.rhs.length;
            }
            if (spos == 0 && this.rhs.length == 0) {
                this.firstSet.add(TerminalSymbol.EPSILON);
            }
        }
        return this.firstSet;
    }

    public boolean equals(Object obj) {
        if (obj instanceof State) {
            State other = (State)obj;
            return this.symbol.equals(other.symbol) && this.position == other.position && this.rhs.equals(other.rhs);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedCode == null) {
            this.cachedCode = this.symbol.hashCode() + 13 * this.position + this.rhs.hashCode();
        }
        return this.cachedCode;
    }

    public String toString() {
        if (this == L0) {
            return "L\u2080";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.symbol);
        sb.append(" \u21d2 ");
        int count = 0;
        for (Symbol symbol : this.rhs.symbols) {
            if (count > 0) {
                sb.append(" ");
            }
            if (count == this.position) {
                sb.append("\u2022 ");
            }
            sb.append(symbol.toString());
            ++count;
        }
        if (count == this.position) {
            if (count > 0) {
                sb.append(" ");
            }
            sb.append("\u2022");
        }
        return sb.toString();
    }
}

