/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.tokens.TokenCharacter;
import org.nineml.coffeegrinder.tokens.TokenEOF;
import org.nineml.coffeegrinder.tokens.TokenEPSILON;
import org.nineml.coffeegrinder.tokens.TokenRegex;
import org.nineml.coffeegrinder.tokens.TokenString;
import org.nineml.coffeegrinder.util.ParserAttribute;

public class TerminalSymbol
extends Symbol {
    public static final TerminalSymbol EPSILON = new TerminalSymbol(TokenEPSILON.EPSILON);
    public static final TerminalSymbol EOF = new TerminalSymbol(TokenEOF.EOF);
    protected Token token;

    public TerminalSymbol(Token token) {
        if (token == null) {
            throw new NullPointerException("Token must not be null");
        }
        this.token = token;
    }

    public TerminalSymbol(Token token, ParserAttribute attribute) {
        this(token, Collections.singletonList(attribute));
    }

    public TerminalSymbol(Token token, Collection<ParserAttribute> attributes) {
        super(attributes);
        if (token == null) {
            throw new NullPointerException("Token must not be null");
        }
        this.token = token;
    }

    public static TerminalSymbol s(String terminal) {
        return new TerminalSymbol(TokenString.get(terminal));
    }

    public static TerminalSymbol ch(char terminal) {
        return new TerminalSymbol(TokenCharacter.get(terminal));
    }

    public static TerminalSymbol regex(String regex) {
        return new TerminalSymbol(TokenRegex.get(regex));
    }

    public Token getToken() {
        return this.token;
    }

    @Override
    public boolean matches(Token input) {
        return this.token.matches(input);
    }

    @Override
    public final boolean matches(Symbol input) {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TerminalSymbol) {
            TerminalSymbol other = (TerminalSymbol)obj;
            if (!this.token.equals(other.token) || this.getAttributes().size() != other.getAttributes().size()) {
                return false;
            }
            if (this.getAttributes().isEmpty()) {
                return true;
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            for (ParserAttribute attr : this.getAttributes()) {
                attrs.put(attr.getName(), attr.getValue());
            }
            for (ParserAttribute attr : other.getAttributes()) {
                if (attrs.containsKey(attr.getName()) && attr.getValue().equals(attrs.get(attr.getName()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 3 * this.token.hashCode() + 31 * this.getAttributes().size();
    }

    public String toString() {
        return this.token.toString();
    }
}

