/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nineml.coffeegrinder.parser.Family;
import org.nineml.coffeegrinder.parser.ForestNode;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.RuleChoice;
import org.nineml.coffeegrinder.tokens.Token;

public abstract class TreeBuilder {
    protected final Split root = new Split();
    protected final HashMap<ForestNode, HashMap<Family, Integer>> nodeEdgeCounts = new HashMap();
    private Split current = null;
    protected boolean ambiguous = false;
    protected boolean infinitelyAmbiguous = false;
    protected int parseCount = 0;
    protected int revealedParses = 0;
    protected int currentParses = 0;

    public boolean isAmbiguous() {
        return this.ambiguous;
    }

    public boolean isInfinitelyAmbiguous() {
        return this.infinitelyAmbiguous;
    }

    public void loop(RuleChoice alternative) {
        this.ambiguous = true;
        this.infinitelyAmbiguous = true;
    }

    public boolean moreParses() {
        return this.parseCount == 0 || this.parseCount < this.revealedParses;
    }

    public int getRevealedParses() {
        return this.revealedParses;
    }

    public int getParseCount() {
        return this.parseCount;
    }

    public HashMap<Family, Integer> getEdgeCounts(ForestNode node) {
        HashMap<Object, Object> edgeCounts;
        if (this.nodeEdgeCounts.containsKey(node)) {
            edgeCounts = this.nodeEdgeCounts.get(node);
            if (edgeCounts.size() != node.families.size()) {
                throw new IllegalStateException("Edge counts have changed on " + node + " (" + edgeCounts.size() + " != " + node.families.size() + ")");
            }
        } else {
            edgeCounts = new HashMap();
            for (Family family : node.families) {
                edgeCounts.put(family, 0);
            }
            this.nodeEdgeCounts.put(node, edgeCounts);
        }
        return edgeCounts;
    }

    public int chooseFromRemaining(List<RuleChoice> alternatives) {
        return 0;
    }

    public int chooseFromAll(List<RuleChoice> alternatives, List<Boolean> moreParses) {
        ArrayList<Integer> indexMap = new ArrayList<Integer>();
        ArrayList<RuleChoice> remaining = new ArrayList<RuleChoice>();
        for (int index = 0; index < alternatives.size(); ++index) {
            if (!moreParses.get(index).booleanValue()) continue;
            indexMap.add(index);
            remaining.add(alternatives.get(index));
        }
        int selected = this.chooseFromRemaining(remaining);
        if (selected < 0 || selected > remaining.size()) {
            throw new IllegalStateException("Invalid alternative selected");
        }
        return (Integer)indexMap.get(selected);
    }

    public int startAlternative(List<RuleChoice> alternatives) {
        this.currentParses += alternatives.size();
        this.ambiguous = true;
        int selected = this.current.choose(alternatives);
        this.current = this.current.paths.get(selected);
        return selected;
    }

    public void endAlternative(RuleChoice alternative) {
    }

    public void reset() {
        this.root.reset();
        this.parseCount = 0;
        this.revealedParses = 0;
        this.currentParses = 0;
        this.current = null;
    }

    public void startTree() {
        if (this.parseCount > 0 && this.parseCount >= this.revealedParses) {
            this.reset();
        }
        ++this.parseCount;
        if (this.revealedParses == 0) {
            this.revealedParses = 1;
        }
        this.currentParses = 0;
        this.root.reset();
        this.current = this.root;
    }

    public void endTree() {
        if (this.currentParses > this.revealedParses) {
            this.revealedParses = this.currentParses;
        }
        Split parent = this.current.parent;
        while (parent != null) {
            parent.pathCount.put(this.current.selection, this.current.size);
            parent.size = 0;
            for (int pos = 0; pos < parent.pathCount.size(); ++pos) {
                parent.size += parent.pathCount.get(pos).intValue();
            }
            this.current = parent;
            parent = this.current.parent;
        }
    }

    public abstract void startNonterminal(NonterminalSymbol var1, Map<String, String> var2, int var3, int var4);

    public abstract void endNonterminal(NonterminalSymbol var1, Map<String, String> var2, int var3, int var4);

    public abstract void token(Token var1, Map<String, String> var2);

    private class Split {
        private final Split parent;
        public final HashMap<Integer, Integer> pathCount;
        public final HashMap<Integer, Split> paths;
        public final int selection;
        public int size = 0;

        public Split() {
            this(null, -1);
        }

        public Split(Split parent, int selected) {
            this.parent = parent;
            this.selection = selected;
            this.pathCount = new HashMap();
            this.paths = new HashMap();
        }

        private void reset() {
            this.pathCount.clear();
            this.paths.clear();
        }

        public int choose(List<RuleChoice> alternatives) {
            if (this.paths.isEmpty()) {
                this.size = alternatives.size();
                for (int count = 0; count < alternatives.size(); ++count) {
                    this.pathCount.put(count, 1);
                }
            }
            assert (alternatives.size() == this.pathCount.size());
            ArrayList<Boolean> more = new ArrayList<Boolean>();
            for (int count = 0; count < alternatives.size(); ++count) {
                more.add(this.pathCount.get(count) > 0);
            }
            int selected = TreeBuilder.this.chooseFromAll(alternatives, more);
            if (selected < 0 || selected >= alternatives.size()) {
                throw new IllegalStateException("Invalid alternative selected");
            }
            if (!this.paths.containsKey(selected)) {
                this.paths.put(selected, new Split(this, selected));
            }
            return selected;
        }
    }
}

