/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.parser;

import java.util.ArrayList;
import java.util.List;
import org.nineml.coffeegrinder.gll.BinarySubtree;
import org.nineml.coffeegrinder.parser.EarleyChart;
import org.nineml.coffeegrinder.parser.EarleyItem;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.ParserGrammar;
import org.nineml.coffeegrinder.parser.ParserOptions;
import org.nineml.coffeegrinder.parser.ParserType;
import org.nineml.coffeegrinder.parser.Rule;
import org.nineml.coffeegrinder.parser.SourceGrammar;
import org.nineml.coffeegrinder.parser.State;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.parser.TerminalSymbol;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.tokens.TokenCharacter;
import org.nineml.logging.Logger;

public class XEarleyParser {
    public static final String logcategory = "Parser";
    public final ParserGrammar grammar;
    private final NonterminalSymbol seedPrime;
    private final ArrayList<State> grammarSlots;
    private final EarleyChart S = new EarleyChart();
    private final EarleyChart R = new EarleyChart();
    private final ArrayList<EarleyItem> openItems = new ArrayList();
    private final BinarySubtree bsr;
    private ParserOptions options = null;
    protected Logger logger = null;
    protected Token[] input = null;

    private XEarleyParser(SourceGrammar sourceGrammar, NonterminalSymbol seed) {
        SourceGrammar modifiedGrammar = new SourceGrammar(sourceGrammar);
        this.seedPrime = modifiedGrammar.getNonterminal("$$");
        modifiedGrammar.addRule(this.seedPrime, seed);
        this.grammar = new ParserGrammar(modifiedGrammar, ParserType.Earley, this.seedPrime);
        this.bsr = new BinarySubtree(this.grammar.getSeed(), this.options);
        this.options = this.grammar.getParserOptions();
        this.logger = this.options.getLogger();
        this.grammarSlots = new ArrayList();
        for (NonterminalSymbol symbol : this.grammar.getSymbols()) {
            for (Rule rule : this.grammar.getRulesForSymbol(symbol)) {
                List<State> slots = rule.getSlots();
                this.grammarSlots.addAll(slots);
            }
        }
    }

    public void parse(String input) {
        Token[] tokens = new Token[input.length()];
        for (int pos = 0; pos < input.length(); ++pos) {
            tokens[pos] = TokenCharacter.get(input.charAt(pos));
        }
        this.parse(tokens);
    }

    public void parse(Token[] input) {
        this.logger = this.options.getLogger();
        this.input = input;
        for (State slot : this.grammarSlots) {
            if (!this.seedPrime.equals(slot.symbol) || slot.position != 0) continue;
            EarleyItem start = new EarleyItem(slot, 0);
            this.openItems.add(start);
            this.S.add(0, start);
            this.R.add(0, start);
        }
        int pos = 0;
        while (!this.openItems.isEmpty()) {
            while (!this.openItems.isEmpty()) {
                EarleyItem item = this.openItems.remove(0);
                Symbol symbol = item.state.nextSymbol();
                if (symbol == null) {
                    this.complete(item, pos);
                    continue;
                }
                if (symbol instanceof TerminalSymbol) {
                    this.scan(item, pos);
                    continue;
                }
                this.predict(item, pos);
            }
            this.openItems.addAll(this.R.get(++pos));
        }
    }

    private void predict(EarleyItem item, int j) {
        Symbol next = item.state.nextSymbol();
        if (next == null || next instanceof TerminalSymbol) {
            return;
        }
        for (State slot : this.grammarSlots) {
            EarleyItem predict;
            if (!next.equals(slot.symbol) || slot.position != 0 || this.S.contains(j, predict = new EarleyItem(slot, j))) continue;
            this.S.add(j, predict);
            this.R.add(j, predict);
            this.openItems.add(predict);
        }
        for (EarleyItem complete : this.S.get(j)) {
            EarleyItem advance;
            if (!next.equals(complete.state.symbol) || complete.state.nextSymbol() != null || this.S.contains(j, advance = new EarleyItem(item.state, item.j))) continue;
            this.S.add(j, complete);
            this.R.add(j, complete);
            this.openItems.add(complete);
            this.bsr.add(complete.state, item.j, j, j);
        }
    }

    private void complete(EarleyItem item, int j) {
        ArrayList<EarleyItem> items = new ArrayList<EarleyItem>(this.S.get(item.j));
        for (EarleyItem cstate : items) {
            if (!item.state.symbol.equals(cstate.state.nextSymbol())) continue;
            EarleyItem complete = new EarleyItem(cstate.state.advance(), cstate.j);
            if (!this.S.contains(j, complete)) {
                this.S.add(j, complete);
                this.R.add(j, complete);
                this.openItems.add(complete);
            }
            this.bsr.add(item.state, item.j, cstate.j, j);
        }
    }

    private void scan(EarleyItem item, int j) {
        EarleyItem complete;
        TerminalSymbol b;
        if (item.state.nextSymbol() instanceof TerminalSymbol && j < this.input.length && (b = (TerminalSymbol)item.state.nextSymbol()).matches(this.input[j]) && !this.S.contains(j + 1, complete = new EarleyItem(item.state.advance(), item.j))) {
            this.S.add(j + 1, complete);
            this.R.add(j + 1, complete);
            this.bsr.add(complete.state, item.j, j, j + 1);
        }
    }
}

