/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.tokens;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.nineml.coffeegrinder.exceptions.GrammarException;
import org.nineml.coffeegrinder.util.CodepointToString;

public class CharacterSet {
    private String charClass = null;
    private Pattern pattern = null;
    private String literal = null;
    private Set<Integer> codepoints = null;
    private int first = 0;
    private int last = 0;

    private CharacterSet(int first, int last) {
        if (first < 0 || last < 0) {
            throw new IllegalArgumentException("Character ranges cannot contain negative characters");
        }
        if (last < first) {
            throw new IllegalArgumentException("Last character in a range must not precede the first character");
        }
        this.first = first;
        this.last = last;
    }

    public boolean isRange() {
        return this.charClass == null && this.codepoints == null;
    }

    public int getRangeFrom() {
        return this.first;
    }

    public int getRangeTo() {
        return this.last;
    }

    private CharacterSet(String literal) {
        if (literal == null) {
            throw new NullPointerException("Literal string cannot be null");
        }
        if ("".equals(literal)) {
            throw new IllegalArgumentException("Literal string must contain at least one character.");
        }
        HashSet<Integer> cps = new HashSet<Integer>();
        literal.codePoints().forEach(cps::add);
        this.codepoints = cps;
        this.literal = literal;
    }

    public boolean isSetOfCharacters() {
        return this.codepoints != null;
    }

    public String getCharacters() {
        if (this.codepoints == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int cp : this.codepoints) {
            sb.appendCodePoint(cp);
        }
        return sb.toString();
    }

    private CharacterSet(Character charclass, Character subclass) {
        if (charclass == null) {
            throw new NullPointerException("null charclass");
        }
        this.charClass = subclass == null ? charclass.toString() : charclass.toString() + subclass;
        String patn = String.format("\\p%s%s%s", "{", this.charClass, "}");
        try {
            this.pattern = Pattern.compile(patn);
        }
        catch (PatternSyntaxException ex) {
            throw GrammarException.invalidCharacterClass(this.charClass);
        }
    }

    public boolean isUnicodeCharacterClass() {
        return this.charClass != null;
    }

    public String getUnicodeCharacterClass() {
        return this.charClass;
    }

    public static CharacterSet literal(String literal) {
        return new CharacterSet(literal);
    }

    public static CharacterSet range(int first, int last) {
        return new CharacterSet(first, last);
    }

    public static CharacterSet unicodeClass(String charClass) {
        if (charClass == null) {
            throw new NullPointerException("Null charClass");
        }
        if (charClass.length() < 1 || charClass.length() > 2) {
            throw new IllegalArgumentException("The charClass must be one or two characters");
        }
        Character ch1 = Character.valueOf(charClass.charAt(0));
        Character ch2 = null;
        if (charClass.length() > 1) {
            ch2 = Character.valueOf(charClass.charAt(1));
        }
        return new CharacterSet(ch1, ch2);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CharacterSet) {
            CharacterSet range = (CharacterSet)obj;
            return this.first == range.first && this.last == range.last && (this.pattern == null && range.pattern == null || this.pattern != null && this.pattern.equals(range.pattern)) && (this.codepoints == null && range.codepoints == null || this.codepoints != null && this.codepoints.equals(range.codepoints));
        }
        return false;
    }

    public boolean matches(int codepoint) {
        if (this.pattern != null) {
            String str = new StringBuilder().appendCodePoint(codepoint).toString();
            return this.pattern.matcher(str).matches();
        }
        if (this.codepoints != null) {
            return this.codepoints.contains(codepoint);
        }
        return codepoint >= this.first && codepoint <= this.last;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.pattern != null) {
            sb.append(this.charClass);
        } else if (this.codepoints != null) {
            sb.append("'");
            sb.append(this.literal.replaceAll("'", "''"));
            sb.append("'");
        } else {
            sb.append(CodepointToString.of(this.first));
            if (this.first != this.last) {
                sb.append("-");
                sb.append(CodepointToString.of(this.last));
            }
        }
        return sb.toString();
    }
}

