/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.tokens;

import java.util.Collection;
import java.util.Collections;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.tokens.TokenString;
import org.nineml.coffeegrinder.util.CodepointToString;
import org.nineml.coffeegrinder.util.ParserAttribute;

public class TokenCharacter
extends Token {
    private final String chstr;
    private final int codepoint;

    private TokenCharacter(int codepoint, Collection<ParserAttribute> attributes) {
        super(attributes);
        this.codepoint = codepoint;
        StringBuilder sb = new StringBuilder();
        sb.appendCodePoint(codepoint);
        this.chstr = sb.toString();
    }

    public static TokenCharacter get(int ch) {
        return new TokenCharacter(ch, null);
    }

    public static TokenCharacter get(int ch, ParserAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Token attribute must not be null");
        }
        return new TokenCharacter(ch, Collections.singletonList(attribute));
    }

    public static TokenCharacter get(int ch, Collection<ParserAttribute> attributes) {
        return new TokenCharacter(ch, attributes);
    }

    @Override
    public String getValue() {
        return this.chstr;
    }

    public int getCodepoint() {
        return this.codepoint;
    }

    @Override
    public boolean matches(Token input) {
        if (input instanceof TokenCharacter) {
            return this.codepoint == ((TokenCharacter)input).codepoint;
        }
        if (input instanceof TokenString) {
            return this.chstr.equals(input.getValue());
        }
        return false;
    }

    public boolean matches(String input) {
        return this.chstr.equals(input);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TokenCharacter) {
            return this.codepoint == ((TokenCharacter)obj).codepoint;
        }
        return false;
    }

    public int hashCode() {
        return this.codepoint;
    }

    public String toString() {
        return CodepointToString.of(this.codepoint);
    }
}

