/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.tokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nineml.coffeegrinder.tokens.CharacterSet;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.tokens.TokenCharacter;
import org.nineml.coffeegrinder.util.ParserAttribute;

public class TokenCharacterSet
extends Token {
    private final List<CharacterSet> ranges;
    private final boolean inclusion;

    private TokenCharacterSet(List<CharacterSet> ranges, Collection<ParserAttribute> attributes, boolean inclusion) {
        super(attributes);
        this.ranges = ranges;
        this.inclusion = inclusion;
    }

    public static TokenCharacterSet inclusion(CharacterSet range) {
        return new TokenCharacterSet(Collections.singletonList(range), null, true);
    }

    public static TokenCharacterSet inclusion(CharacterSet range, Collection<ParserAttribute> attributes) {
        return new TokenCharacterSet(Collections.singletonList(range), attributes, true);
    }

    public static TokenCharacterSet inclusion(List<CharacterSet> range) {
        return new TokenCharacterSet(range, null, true);
    }

    public static TokenCharacterSet inclusion(List<CharacterSet> range, Collection<ParserAttribute> attributes) {
        return new TokenCharacterSet(range, attributes, true);
    }

    public static TokenCharacterSet inclusion(CharacterSet ... ranges) {
        ArrayList<CharacterSet> sets = new ArrayList<CharacterSet>();
        Collections.addAll(sets, ranges);
        return new TokenCharacterSet(sets, null, true);
    }

    public static TokenCharacterSet exclusion(CharacterSet range) {
        return new TokenCharacterSet(Collections.singletonList(range), null, false);
    }

    public static TokenCharacterSet exclusion(CharacterSet range, Collection<ParserAttribute> attributes) {
        return new TokenCharacterSet(Collections.singletonList(range), attributes, false);
    }

    public static TokenCharacterSet exclusion(List<CharacterSet> range) {
        return new TokenCharacterSet(range, null, false);
    }

    public static TokenCharacterSet exclusion(List<CharacterSet> range, Collection<ParserAttribute> attributes) {
        return new TokenCharacterSet(range, attributes, false);
    }

    public static TokenCharacterSet exclusion(CharacterSet ... ranges) {
        ArrayList<CharacterSet> sets = new ArrayList<CharacterSet>();
        Collections.addAll(sets, ranges);
        return new TokenCharacterSet(sets, null, false);
    }

    public boolean isInclusion() {
        return this.inclusion;
    }

    public List<CharacterSet> getCharacterSets() {
        return this.ranges;
    }

    @Override
    public boolean matches(Token token) {
        if (token instanceof TokenCharacter) {
            int cp = ((TokenCharacter)token).getCodepoint();
            boolean found = false;
            for (CharacterSet range : this.ranges) {
                found = found || range.matches(cp);
            }
            if (this.inclusion) {
                return found;
            }
            return !found;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TokenCharacterSet) {
            TokenCharacterSet other = (TokenCharacterSet)obj;
            if (this.inclusion == other.inclusion && this.ranges.size() == other.ranges.size()) {
                for (CharacterSet range : this.ranges) {
                    boolean same = false;
                    for (CharacterSet otherRange : other.ranges) {
                        if (!range.equals(otherRange)) continue;
                        same = true;
                        break;
                    }
                    if (same) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.inclusion) {
            sb.append("~");
        }
        sb.append("[");
        boolean first = true;
        for (CharacterSet range : this.ranges) {
            if (!first) {
                sb.append("; ");
            }
            first = false;
            sb.append(range);
        }
        sb.append("]");
        return sb.toString();
    }
}

