/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.tokens;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.tokens.TokenCharacter;
import org.nineml.coffeegrinder.tokens.TokenString;
import org.nineml.coffeegrinder.util.ParserAttribute;

public class TokenRegex
extends Token {
    private final Pattern regex;
    private final String expr;

    private TokenRegex(String expr, Collection<ParserAttribute> attributes) {
        super(attributes);
        if (expr == null) {
            throw new NullPointerException("TokenString value must not be null");
        }
        this.expr = expr;
        this.regex = Pattern.compile(expr);
    }

    public static TokenRegex get(String expr) {
        return new TokenRegex(expr, null);
    }

    public static TokenRegex get(String expr, ParserAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Token parser attribute must not be null");
        }
        return new TokenRegex(expr, Collections.singletonList(attribute));
    }

    public static TokenRegex get(String expr, Collection<ParserAttribute> attributes) {
        return new TokenRegex(expr, attributes);
    }

    @Override
    public String getValue() {
        return this.expr;
    }

    @Override
    public final boolean matches(Token input) {
        if (input instanceof TokenCharacter) {
            return this.regex.matcher("" + input.getValue()).matches();
        }
        if (input instanceof TokenString) {
            return this.regex.matcher(input.getValue()).matches();
        }
        return false;
    }

    public final boolean matches(String input) {
        return this.regex.matcher(input).matches();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TokenRegex) {
            return ((TokenRegex)obj).expr.equals(this.expr);
        }
        return false;
    }

    public int hashCode() {
        return 11 + 31 * this.expr.hashCode();
    }

    public String toString() {
        return this.regex.toString();
    }
}

