/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.tokens;

import java.util.Collection;
import java.util.Collections;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.tokens.TokenCharacter;
import org.nineml.coffeegrinder.util.ParserAttribute;

public class TokenString
extends Token {
    private final String value;

    private TokenString(String value, Collection<ParserAttribute> attributes) {
        super(attributes);
        if (value == null) {
            throw new NullPointerException("TokenString value must not be null");
        }
        this.value = value;
    }

    public static TokenString get(String value) {
        return new TokenString(value, null);
    }

    public static TokenString get(String value, ParserAttribute attribute) {
        return new TokenString(value, Collections.singletonList(attribute));
    }

    public static TokenString get(String value, Collection<ParserAttribute> attributes) {
        return new TokenString(value, attributes);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean matches(Token input) {
        if (input instanceof TokenString || input instanceof TokenCharacter) {
            return this.value.equals(input.getValue());
        }
        return false;
    }

    public boolean matches(char input) {
        return this.value.length() == 1 && this.value.charAt(0) == input;
    }

    public boolean matches(String input) {
        return this.value.equals(input);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TokenString) {
            return this.value.equals(((TokenString)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return 3 * this.value.hashCode();
    }

    public String toString() {
        String output = this.value.replaceAll("\"", "\"\"");
        output = output.replaceAll("[\t]", "\\t");
        output = output.replaceAll("[\r]", "\\r");
        output = output.replaceAll("[\n]", "\\n");
        return "\"" + output + "\"";
    }
}

