/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.util;

public class CodepointToString {
    public static boolean useHex = true;
    public static boolean uppercase = true;
    public static boolean quotePrintableCharacters = true;

    public static String of(int codepoint) {
        if (useHex) {
            return CodepointToString.hexOf(codepoint);
        }
        return CodepointToString.backslashOf(codepoint);
    }

    public static String of(String text) {
        StringBuilder sb = new StringBuilder();
        String comma = "";
        for (int cp : text.codePoints().toArray()) {
            sb.append(comma);
            sb.append(CodepointToString.of(cp));
            comma = ", ";
        }
        return sb.toString();
    }

    private static String hexOf(int codepoint) {
        String format;
        String string = format = uppercase ? "#%X" : "#%x";
        if (Character.isISOControl(codepoint) || (codepoint != 32 || !quotePrintableCharacters) && Character.isWhitespace(codepoint) || codepoint == 160 || codepoint == 8199 || codepoint == 8239) {
            return String.format(format, codepoint);
        }
        if (Character.isBmpCodePoint(codepoint)) {
            if (!quotePrintableCharacters) {
                return "" + (char)codepoint;
            }
            if (codepoint == 39) {
                return "\"" + (char)codepoint + "\"";
            }
            return "'" + (char)codepoint + "'";
        }
        StringBuilder sb = new StringBuilder();
        if (quotePrintableCharacters) {
            sb.append("'");
            sb.appendCodePoint(codepoint);
            sb.append("'");
        } else {
            sb.appendCodePoint(codepoint);
        }
        return sb.toString();
    }

    private static String backslashOf(int codepoint) {
        String format;
        String string = format = uppercase ? "\\u%04X" : "\\u%04x";
        if (Character.isISOControl(codepoint) || (codepoint != 32 || !quotePrintableCharacters) && Character.isWhitespace(codepoint) || codepoint == 160 || codepoint == 8199 || codepoint == 8239) {
            switch (codepoint) {
                case 7: {
                    return "\\a";
                }
                case 8: {
                    return "\\b";
                }
                case 27: {
                    return "\\e";
                }
                case 12: {
                    return "\\f";
                }
                case 10: {
                    return "\\n";
                }
                case 13: {
                    return "\\r";
                }
                case 9: {
                    return "\\t";
                }
                case 11: {
                    return "\\v";
                }
            }
            return String.format(format, codepoint);
        }
        if (Character.isBmpCodePoint(codepoint)) {
            if (!quotePrintableCharacters) {
                return "" + (char)codepoint;
            }
            if (codepoint == 39) {
                return "\"" + (char)codepoint + "\"";
            }
            return "'" + (char)codepoint + "'";
        }
        StringBuilder sb = new StringBuilder();
        if (quotePrintableCharacters) {
            sb.append("'");
            sb.appendCodePoint(codepoint);
            sb.append("'");
        } else {
            sb.appendCodePoint(codepoint);
        }
        return sb.toString();
    }
}

