/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nineml.coffeegrinder.exceptions.AttributeException;
import org.nineml.coffeegrinder.util.ParserAttribute;

public abstract class Decoratable {
    private HashMap<String, ParserAttribute> attributes = null;
    private HashMap<String, String> attrmap = null;

    public Decoratable() {
    }

    public Decoratable(Collection<ParserAttribute> attributes) {
        this.addAttributes(attributes);
    }

    public final boolean hasAttribute(String name) {
        return this.attributes != null && this.attributes.containsKey(name);
    }

    public final ParserAttribute getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.getOrDefault(name, null);
        }
        return null;
    }

    public final String getAttributeValue(String name, String defaultValue) {
        if (this.attributes != null && this.attributes.containsKey(name)) {
            return this.attributes.get(name).getValue();
        }
        return defaultValue;
    }

    public final Collection<ParserAttribute> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyList();
        }
        return this.attributes.values();
    }

    public final Map<String, String> getAttributesMap() {
        if (this.attrmap == null) {
            return Collections.emptyMap();
        }
        return this.attrmap;
    }

    public final void addAttribute(ParserAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Attribute must not be null");
        }
        this.addAttributes(Collections.singletonList(attribute));
    }

    public final void addAttributes(Collection<ParserAttribute> attrcoll) {
        if (attrcoll == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
            this.attrmap = new HashMap();
        }
        for (ParserAttribute attr : attrcoll) {
            if (attr.getName().equals("https://nineml.org/attr/prune") && !"allowed".equals(attr.getValue()) && !"forbidden".equals(attr.getValue())) {
                throw AttributeException.invalidPRUNING(attr.getValue());
            }
            if (this.attributes.containsKey(attr.getName())) {
                if (this.attributes.get(attr.getName()).getValue().equals(attr.getValue())) continue;
                throw AttributeException.immutable(attr.getName(), attr.getValue());
            }
            this.attributes.put(attr.getName(), attr);
            this.attrmap.put(attr.getName(), attr.getValue());
        }
    }
}

