/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.util;

import java.util.Calendar;
import org.nineml.coffeegrinder.parser.GearleyParser;
import org.nineml.coffeegrinder.parser.ParserType;
import org.nineml.coffeegrinder.parser.ProgressMonitor;

public class DefaultProgressMonitor
implements ProgressMonitor {
    public static int earleyFrequency = 100;
    public static int gllFrequency = 10000;
    public static long minimumTimeInterval = 1L;
    private long lastUpdateTime;

    @Override
    public int starting(GearleyParser parser, int tokens) {
        this.lastUpdateTime = Calendar.getInstance().getTimeInMillis();
        if (parser.getParserType() == ParserType.GLL) {
            return gllFrequency;
        }
        return earleyFrequency;
    }

    @Override
    public void progress(GearleyParser parser, int tokens) {
        System.out.printf("Processed %,d tokens.%n", tokens);
    }

    @Override
    public void workingSet(GearleyParser parser, int size, int highwater) {
        long now = Calendar.getInstance().getTimeInMillis();
        if (now - this.lastUpdateTime < minimumTimeInterval * 1000L) {
            return;
        }
        this.lastUpdateTime = now;
        System.out.printf("%,d items remain (seen %d tokens).%n", size, highwater);
    }

    @Override
    public void finished(GearleyParser parser) {
    }
}

