/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.nineml.coffeegrinder.exceptions.CompilerException;
import org.nineml.coffeegrinder.parser.NonterminalSymbol;
import org.nineml.coffeegrinder.parser.ParserGrammar;
import org.nineml.coffeegrinder.parser.ParserOptions;
import org.nineml.coffeegrinder.parser.Rule;
import org.nineml.coffeegrinder.parser.SourceGrammar;
import org.nineml.coffeegrinder.parser.Symbol;
import org.nineml.coffeegrinder.parser.TerminalSymbol;
import org.nineml.coffeegrinder.tokens.CharacterSet;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.tokens.TokenCharacter;
import org.nineml.coffeegrinder.tokens.TokenCharacterSet;
import org.nineml.coffeegrinder.tokens.TokenRegex;
import org.nineml.coffeegrinder.tokens.TokenString;
import org.nineml.coffeegrinder.util.ParserAttribute;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GrammarCompiler {
    private static final String formatVersion = "1.99.8";
    private static final char nameEscape = 'E';
    private static final String NS = "http://nineml.org/coffeegrinder/ns/grammar/compiled";
    private static final HashMap<Character, String> entities = new HashMap();
    private final HashMap<String, Collection<ParserAttribute>> agroups = new HashMap();
    private StringBuilder sb = null;
    private MessageDigest xdigest = null;
    private ParserOptions options = null;
    private HashMap<String, String> properties = new HashMap();

    public GrammarCompiler() {
        this(new ParserOptions());
    }

    public GrammarCompiler(ParserOptions options) {
        this.options = options;
    }

    private void initializeDigest() {
        try {
            this.xdigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw CompilerException.messageDigestError("SHA-256", ex.getMessage());
        }
    }

    private void updateDigest(String value) {
        this.xdigest.update(value.getBytes(StandardCharsets.UTF_8));
    }

    private void updateDigest(char value) {
        this.updateDigest("" + value);
    }

    public String compile(ParserGrammar grammar) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.compile(grammar, ps);
        try {
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Unexpected (i.e. impossible) unsupported encoding exception", ex);
        }
    }

    public void compile(ParserGrammar grammar, PrintStream ps) {
        this.initializeDigest();
        this.agroups.clear();
        this.sb = new StringBuilder();
        this.sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.sb.append("<grammar xmlns=\"").append(NS).append("\"");
        this.sb.append(" version=\"").append(formatVersion).append("\">\n");
        ArrayList<String> names = new ArrayList<String>(grammar.getMetadataProperies().keySet());
        Collections.sort(names);
        for (String name : names) {
            if ("".equals(name)) continue;
            this.sb.append("<meta name='").append(this.xmlString(name));
            this.sb.append("' value='");
            this.sb.append(this.xmlString(grammar.getMetadataProperies().get(name)));
            this.sb.append("'/>\n");
        }
        this.initializeDigest();
        this.updateDigest(formatVersion);
        for (Rule rule : grammar.getRules()) {
            this.atgroup(rule.getSymbol().getAttributes());
            for (Symbol symbol : rule.getRhs().symbols) {
                this.atgroup(symbol.getAttributes());
                if (!(symbol instanceof TerminalSymbol)) continue;
                this.atgroup(((TerminalSymbol)symbol).getToken().getAttributes());
            }
            this.sb.append("<r n=\"").append(this.xmlString(rule.getSymbol().getName())).append("\"");
            this.standardAttributes(rule.getSymbol().getAttributes());
            this.sb.append(" ag=\"").append(this.atgroup(rule.getSymbol().getAttributes())).append("\"");
            this.sb.append(">");
            for (Symbol symbol : rule.getRhs().symbols) {
                if (symbol instanceof TerminalSymbol) {
                    String str;
                    this.sb.append("<t");
                    this.standardAttributes(symbol.getAttributes());
                    this.sb.append(" ag=\"").append(this.atgroup(symbol.getAttributes())).append("\"");
                    this.sb.append(">");
                    Token token = ((TerminalSymbol)symbol).getToken();
                    if (token instanceof TokenCharacterSet) {
                        this.sb.append("<cs");
                        this.standardAttributes(token.getAttributes());
                        this.sb.append(" ag=\"").append(this.atgroup(token.getAttributes())).append("\"");
                        TokenCharacterSet tcs = (TokenCharacterSet)token;
                        if (tcs.isInclusion()) {
                            this.sb.append(" inclusion=\"");
                            this.updateDigest("inclusion");
                        } else {
                            this.sb.append(" exclusion=\"");
                            this.updateDigest("exclusion");
                        }
                        StringBuilder csvalue = new StringBuilder();
                        boolean csfirst = true;
                        for (CharacterSet cs : tcs.getCharacterSets()) {
                            if (!csfirst) {
                                csvalue.append(";");
                            }
                            csfirst = false;
                            if (cs.isRange()) {
                                if (cs.getRangeFrom() == cs.getRangeTo()) {
                                    csvalue.append(String.format("'%s'", Character.valueOf((char)cs.getRangeFrom())));
                                    continue;
                                }
                                csvalue.append(String.format("'%s'-'%s'", Character.valueOf((char)cs.getRangeFrom()), Character.valueOf((char)cs.getRangeTo())));
                                continue;
                            }
                            if (cs.isUnicodeCharacterClass()) {
                                csvalue.append(cs.getUnicodeCharacterClass());
                                continue;
                            }
                            if (cs.isSetOfCharacters()) {
                                String value = cs.getCharacters().replace("&", "&amp;").replace("\"", "&quot;");
                                csvalue.append('\"').append(value).append('\"');
                                continue;
                            }
                            throw CompilerException.unexpectedCharacterSet(cs.toString());
                        }
                        this.sb.append(this.xmlString(csvalue.toString()));
                        this.sb.append("\"/>");
                    } else if (token instanceof TokenCharacter) {
                        str = ((TokenCharacter)token).getValue();
                        this.sb.append("<c");
                        this.standardAttributes(token.getAttributes());
                        this.sb.append(" ag=\"").append(this.atgroup(token.getAttributes())).append("\"");
                        this.sb.append(" v=\"").append(this.xmlChar(str)).append("\"/>");
                    } else if (token instanceof TokenString) {
                        str = token.getValue();
                        this.sb.append("<s");
                        this.standardAttributes(token.getAttributes());
                        this.sb.append(" ag=\"").append(this.atgroup(token.getAttributes())).append("\"");
                        this.sb.append(" v=\"").append(this.xmlString(str)).append("\"/>");
                    } else if (token instanceof TokenRegex) {
                        String regex = token.getValue();
                        this.sb.append("<re");
                        this.standardAttributes(token.getAttributes());
                        this.sb.append(" ag=\"").append(this.atgroup(token.getAttributes())).append("\"");
                        this.sb.append(" v=\"").append(this.xmlString(regex)).append("\"/>");
                    } else {
                        throw CompilerException.unexpectedTerminalTokenClass(token.toString());
                    }
                    this.sb.append("</t>");
                    continue;
                }
                NonterminalSymbol nt = (NonterminalSymbol)symbol;
                this.sb.append("<nt n=\"").append(this.xmlString(nt.getName())).append("\"");
                this.standardAttributes(nt.getAttributes());
                this.sb.append(" ag=\"").append(this.atgroup(symbol.getAttributes())).append("\"");
                this.sb.append("/>");
            }
            this.sb.append("</r>\n");
        }
        this.sb.append("<check sum=\"");
        byte[] hash = this.xdigest.digest();
        for (int pos = hash.length - 8; pos < hash.length; ++pos) {
            this.sb.append(Integer.toString((hash[pos] & 0xFF) + 256, 16).substring(1));
        }
        this.sb.append("\"/>\n</grammar>\n");
        ps.print(this.sb);
    }

    private String xmlString(String str) {
        if (str.length() == 1) {
            return this.xmlChar(str);
        }
        StringBuilder sb = new StringBuilder();
        for (int cp : str.codePoints().toArray()) {
            sb.append(this.xmlChar(cp));
        }
        return sb.toString();
    }

    private String xmlChar(int codepoint) {
        StringBuilder sb = new StringBuilder();
        sb.appendCodePoint(codepoint);
        return this.xmlChar(sb.toString());
    }

    private String xmlChar(String str) {
        this.updateDigest(str);
        char ch = str.charAt(0);
        if (entities.containsKey(Character.valueOf(ch))) {
            return entities.get(Character.valueOf(ch));
        }
        if (ch == '\\') {
            return "&#x5c;";
        }
        int codepoint = str.codePointAt(0);
        boolean ok = codepoint == 9 || codepoint == 10 || codepoint == 13;
        ok = ok || codepoint >= 32 && codepoint <= 55295;
        boolean bl = ok = ok || codepoint >= 57344 && codepoint <= 65533;
        if (ok) {
            if (codepoint < 32 || codepoint >= 128 && codepoint <= 159) {
                return String.format("&#x%x;", codepoint);
            }
            StringBuilder sb = new StringBuilder();
            sb.appendCodePoint(codepoint);
            return sb.toString();
        }
        return String.format("\\U+%04x;", codepoint);
    }

    private String unxmlString(String xml) {
        return this.unxmlString(xml, true);
    }

    private String unxmlString(String xml, boolean updateDigest) {
        String value = xml;
        for (char ch : entities.keySet()) {
            String esc = entities.get(Character.valueOf(ch));
            if (!value.contains(esc)) continue;
            value = value.replace(esc, "" + ch);
        }
        value = this.unescape("\\U+", value);
        value = this.unescape("&#x", value);
        if (updateDigest) {
            this.updateDigest(value);
        }
        return value;
    }

    private String unescape(String prefix, String value) {
        int pos = value.indexOf(prefix);
        if (pos >= 0) {
            StringBuilder nsb = new StringBuilder();
            while (pos >= 0) {
                nsb.append(value, 0, pos);
                value = value.substring(pos + prefix.length());
                pos = value.indexOf(";");
                if (pos <= 0) {
                    throw CompilerException.invalidNameEscaping(value, value);
                }
                String hex = value.substring(0, pos);
                nsb.appendCodePoint(Integer.parseInt(hex, 16));
                value = value.substring(pos + 1);
                pos = value.indexOf(prefix);
            }
            nsb.append(value);
            return nsb.toString();
        }
        return value;
    }

    private void standardAttributes(Collection<ParserAttribute> attributes) {
        String value = "";
        for (ParserAttribute attr : attributes) {
            if (!attr.getName().equals("https://nineml.org/attr/prune")) continue;
            if (attr.getValue().equals(ParserAttribute.PRUNING_ALLOWED.getValue())) {
                value = value + "p";
                continue;
            }
            value = value + "f";
        }
        if (!"".equals(value)) {
            this.sb.append(" a=\"").append(value).append("\"");
            this.updateDigest(value);
        }
    }

    private boolean sameCollection(Collection<ParserAttribute> group, Collection<ParserAttribute> candidate) {
        if (group.size() == candidate.size()) {
            for (ParserAttribute attr : candidate) {
                if (group.contains(attr)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String atgroup(Collection<ParserAttribute> attributes) {
        for (String gid : this.agroups.keySet()) {
            if (!this.sameCollection(this.agroups.get(gid), attributes)) continue;
            return gid;
        }
        String gid = "g" + (this.agroups.size() + 1);
        this.agroups.put(gid, attributes);
        this.outputAttributes(gid, attributes);
        return gid;
    }

    private void outputAttributes(String gid, Collection<ParserAttribute> attributes) {
        this.sb.append("<ag xml:id=\"").append(gid).append("\"");
        this.updateDigest(gid);
        for (ParserAttribute attr : attributes) {
            this.sb.append(" ").append(this.nameString(attr.getName())).append("=\"").append(this.xmlString(attr.getValue())).append("\"");
        }
        this.sb.append("/>\n");
    }

    private String nameString(String name) {
        this.updateDigest(name);
        StringBuilder nsb = new StringBuilder();
        for (int pos = 0; pos < name.length(); ++pos) {
            nsb.append(this.nameChar(name.charAt(pos), pos == 0));
        }
        return nsb.toString();
    }

    private String nameChar(char ch, boolean first) {
        if (ch == 'E' || !Character.isLetter(ch) && !Character.isDigit(ch) || first && !Character.isLetter(ch)) {
            return String.format("%s%x.", Character.valueOf('E'), (int)ch);
        }
        return "" + ch;
    }

    private String unnameString(String name) {
        return this.unnameString(name, true);
    }

    private String unnameString(String name, boolean updateDigest) {
        String value = name;
        StringBuilder nsb = new StringBuilder();
        int pos = value.indexOf(69);
        while (pos >= 0) {
            nsb.append(value, 0, pos);
            value = value.substring(pos + 1);
            pos = value.indexOf(".");
            if (pos <= 0) {
                throw CompilerException.invalidNameEscaping(value, name);
            }
            String hex = value.substring(0, pos);
            nsb.appendCodePoint(Integer.parseInt(hex, 16));
            value = value.substring(pos + 1);
            pos = value.indexOf(69);
        }
        nsb.append(value);
        if (updateDigest) {
            this.updateDigest(nsb.toString());
        }
        return nsb.toString();
    }

    public SourceGrammar parse(File compiled) throws IOException {
        if (compiled == null) {
            throw new NullPointerException("File must not be null");
        }
        return this.parse(Files.newInputStream(compiled.toPath(), new OpenOption[0]), compiled.toURI().toString());
    }

    public SourceGrammar parse(InputStream compiled, String systemId) throws IOException {
        if (compiled == null) {
            throw new NullPointerException("File must not be null");
        }
        InputSource source = new InputSource(compiled);
        source.setSystemId(systemId);
        return this.parse(source);
    }

    public SourceGrammar parse(String input) {
        if (input == null) {
            throw new NullPointerException("Input must not be null");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        return this.parse(new InputSource(bais));
    }

    private SourceGrammar parse(InputSource source) {
        SourceGrammar sourceGrammar = new SourceGrammar(this.options);
        this.properties = new HashMap();
        this.initializeDigest();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            GrammarContentHandler handler = new GrammarContentHandler(sourceGrammar);
            parser.parse(source, (DefaultHandler)handler);
            for (String name : this.properties.keySet()) {
                sourceGrammar.setMetadataProperty(name, this.properties.get(name));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw CompilerException.errorReadingGrammar(ex.getMessage());
        }
        return sourceGrammar;
    }

    static {
        entities.put(Character.valueOf('\"'), "&quot;");
        entities.put(Character.valueOf('&'), "&amp;");
        entities.put(Character.valueOf('<'), "&lt;");
        entities.put(Character.valueOf('>'), "&gt;");
    }

    private class GrammarContentHandler
    extends DefaultHandler {
        private final SourceGrammar grammar;
        private final Stack<String> elementStack;
        private final ArrayList<Symbol> symbolList;
        private final HashMap<String, Collection<ParserAttribute>> agroups;
        private NonterminalSymbol rulename = null;
        private Token token = null;
        private Collection<ParserAttribute> tspa = null;

        public GrammarContentHandler(SourceGrammar grammar) {
            this.grammar = grammar;
            this.elementStack = new Stack();
            this.symbolList = new ArrayList();
            this.agroups = new HashMap();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!GrammarCompiler.NS.equals(uri)) {
                if (this.elementStack.isEmpty()) {
                    throw CompilerException.notAGrammar(uri);
                }
                this.elementStack.push("-");
                return;
            }
            this.elementStack.push(localName);
            switch (localName) {
                case "r": {
                    this.handle_start_r(attributes);
                    break;
                }
                case "nt": {
                    this.handle_nt(attributes);
                    break;
                }
                case "t": {
                    this.handle_start_t(attributes);
                    break;
                }
                case "c": {
                    this.handle_c(attributes);
                    break;
                }
                case "s": {
                    this.handle_s(attributes);
                    break;
                }
                case "cs": {
                    this.handle_cs(attributes);
                    break;
                }
                case "re": {
                    this.handle_re(attributes);
                    break;
                }
                case "ag": {
                    this.handle_ag(attributes);
                    break;
                }
                case "meta": {
                    this.handle_meta(attributes);
                    break;
                }
                case "grammar": {
                    if (this.elementStack.size() != 1) {
                        throw CompilerException.unexpectedElement(localName);
                    }
                    String version = attributes.getValue("version");
                    if (version == null) {
                        throw CompilerException.noVersionProvided();
                    }
                    if (!GrammarCompiler.formatVersion.equals(version)) {
                        throw CompilerException.unsupportedVersion(version);
                    }
                    GrammarCompiler.this.updateDigest(version);
                    break;
                }
                case "check": {
                    String expected;
                    StringBuilder sb = new StringBuilder();
                    byte[] hash = GrammarCompiler.this.xdigest.digest();
                    for (int pos = hash.length - 8; pos < hash.length; ++pos) {
                        sb.append(Integer.toString((hash[pos] & 0xFF) + 256, 16).substring(1));
                    }
                    String checksum = sb.toString();
                    if (checksum.equals(expected = attributes.getValue("sum"))) break;
                    throw CompilerException.checkumFailed();
                }
                default: {
                    throw CompilerException.unexpectedElement(localName);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.elementStack.pop();
            if (!GrammarCompiler.NS.equals(uri)) {
                return;
            }
            switch (localName) {
                case "r": {
                    this.handle_end_r();
                    break;
                }
                case "t": {
                    this.handle_end_t();
                    break;
                }
                case "nt": 
                case "c": 
                case "s": 
                case "re": 
                case "cs": 
                case "ag": 
                case "grammar": 
                case "check": 
                case "meta": {
                    break;
                }
                default: {
                    throw CompilerException.unexpectedElement(localName);
                }
            }
        }

        private void handle_ag(Attributes attributes) {
            String id = attributes.getValue("xml:id");
            if (id == null) {
                throw CompilerException.missingXmlId("ag");
            }
            GrammarCompiler.this.updateDigest(id);
            ArrayList<ParserAttribute> pattrs = new ArrayList<ParserAttribute>();
            for (int pos = 0; pos < attributes.getLength(); ++pos) {
                if ("xml:id".equals(attributes.getQName(pos))) continue;
                String name = GrammarCompiler.this.unnameString(attributes.getQName(pos));
                String value = GrammarCompiler.this.unxmlString(attributes.getValue(pos));
                pattrs.add(new ParserAttribute(name, value));
            }
            this.agroups.put(id, pattrs);
        }

        private Collection<ParserAttribute> handleAttributes(String ag, String a) {
            ArrayList<Object> rattr = null;
            if (ag != null) {
                if (!this.agroups.containsKey(ag)) {
                    throw CompilerException.missingAttributeGroup(ag);
                }
                rattr = new ArrayList<ParserAttribute>(this.agroups.get(ag));
            }
            if (a != null) {
                if (rattr == null) {
                    rattr = new ArrayList();
                }
                block4: for (int pos = 0; pos < a.length(); ++pos) {
                    switch (a.charAt(pos)) {
                        case 'p': {
                            rattr.add(ParserAttribute.PRUNING_ALLOWED);
                            continue block4;
                        }
                        case 'f': {
                            rattr.add(ParserAttribute.PRUNING_FORBIDDEN);
                            continue block4;
                        }
                        default: {
                            throw CompilerException.unexpectedFlag("" + a.charAt(pos));
                        }
                    }
                }
                GrammarCompiler.this.updateDigest(a);
            }
            return rattr;
        }

        private void handle_start_r(Attributes attributes) {
            if (!this.symbolList.isEmpty()) {
                throw CompilerException.invalidGramamr("symbol list isn't empty");
            }
            String name = attributes.getValue("n");
            String ag = attributes.getValue("ag");
            String a = attributes.getValue("a");
            if (name == null) {
                throw CompilerException.invalidGramamr("r without @n");
            }
            name = GrammarCompiler.this.unxmlString(name);
            Collection<ParserAttribute> rattr = this.handleAttributes(ag, a);
            this.rulename = this.grammar.getNonterminal(name, rattr);
        }

        private void handle_end_r() {
            if (this.rulename == null) {
                throw CompilerException.invalidGramamr("no rule name");
            }
            this.grammar.addRule(this.rulename, this.symbolList);
            this.rulename = null;
            this.symbolList.clear();
        }

        private void handle_nt(Attributes attributes) {
            String name = attributes.getValue("n");
            String ag = attributes.getValue("ag");
            String a = attributes.getValue("a");
            if (name == null) {
                throw CompilerException.invalidGramamr("nt without @n");
            }
            name = GrammarCompiler.this.unxmlString(name);
            Collection<ParserAttribute> ntattr = this.handleAttributes(ag, a);
            this.symbolList.add(this.grammar.getNonterminal(name, ntattr));
        }

        private void handle_start_t(Attributes attributes) {
            if (this.token != null) {
                throw CompilerException.invalidGramamr("nested tokens");
            }
            String ag = attributes.getValue("ag");
            String a = attributes.getValue("a");
            this.tspa = this.handleAttributes(ag, a);
        }

        private void handle_end_t() {
            if (this.token == null) {
                throw CompilerException.invalidGramamr("no token in t");
            }
            this.symbolList.add(new TerminalSymbol(this.token, this.tspa));
            this.tspa = null;
            this.token = null;
        }

        private void handle_c(Attributes attributes) {
            String value = attributes.getValue("v");
            String ag = attributes.getValue("ag");
            String a = attributes.getValue("a");
            if (value == null) {
                throw CompilerException.invalidGramamr("c without @v");
            }
            if ((value = GrammarCompiler.this.unxmlString(value)).length() != 1) {
                throw CompilerException.invalidGramamr("bad value for c: " + value);
            }
            Collection<ParserAttribute> cattr = this.handleAttributes(ag, a);
            this.token = TokenCharacter.get((int)value.charAt(0), cattr);
        }

        private void handle_s(Attributes attributes) {
            String value = attributes.getValue("v");
            String ag = attributes.getValue("ag");
            String a = attributes.getValue("a");
            if (value == null) {
                throw CompilerException.invalidGramamr("s without @v");
            }
            value = GrammarCompiler.this.unxmlString(value);
            Collection<ParserAttribute> sattr = this.handleAttributes(ag, a);
            this.token = TokenString.get(value, sattr);
        }

        private void handle_cs(Attributes attributes) {
            boolean inclusion;
            String value = attributes.getValue("inclusion");
            if (value == null) {
                inclusion = false;
                value = attributes.getValue("exclusion");
                if (value == null) {
                    throw CompilerException.invalidGramamr("cs without value");
                }
                GrammarCompiler.this.updateDigest("exclusion");
            } else {
                inclusion = true;
                GrammarCompiler.this.updateDigest("inclusion");
            }
            String ag = attributes.getValue("ag");
            String a = attributes.getValue("a");
            GrammarCompiler.this.updateDigest(value);
            List<CharacterSet> sets = this.parseCharacterSets(value);
            Collection<ParserAttribute> sattr = this.handleAttributes(ag, a);
            this.token = inclusion ? TokenCharacterSet.inclusion(sets, sattr) : TokenCharacterSet.exclusion(sets, sattr);
        }

        private List<CharacterSet> parseCharacterSets(String value) {
            ArrayList<CharacterSet> ranges = new ArrayList<CharacterSet>();
            boolean done = false;
            while (!done) {
                String text;
                if (value.startsWith("\"")) {
                    int pos = (value = value.substring(1)).indexOf("\"");
                    if (pos <= 0) {
                        throw new RuntimeException("Invalid compiled grammar");
                    }
                    text = value.substring(0, pos);
                    text = text.replace("&quot;", "\"").replace("&amp;", "&");
                    value = value.substring(pos + 1);
                    CharacterSet set = CharacterSet.literal(text);
                    ranges.add(set);
                } else if (value.startsWith("'")) {
                    char from;
                    int pos = (value = value.substring(1)).indexOf("'");
                    if (pos <= 0) {
                        throw new RuntimeException("Invalid compiled grammar");
                    }
                    text = value.substring(0, pos);
                    value = value.substring(pos + 1);
                    char to = from = text.charAt(0);
                    if (value.startsWith("-'")) {
                        pos = (value = value.substring(2)).indexOf("'");
                        if (pos <= 0) {
                            throw new RuntimeException("Invalid compiled grammar");
                        }
                        text = value.substring(0, pos);
                        value = value.substring(pos + 1);
                        to = text.charAt(0);
                    }
                    CharacterSet set = CharacterSet.range(from, to);
                    ranges.add(set);
                } else {
                    String uclass = value.substring(0, 1);
                    if (!("".equals(value = value.substring(1)) || value.startsWith(";") || value.startsWith("]"))) {
                        uclass = uclass + value.substring(0, 1);
                        value = value.substring(1);
                    }
                    CharacterSet set = CharacterSet.unicodeClass(uclass);
                    ranges.add(set);
                }
                if (done = !value.startsWith(";")) continue;
                value = value.substring(1);
            }
            return ranges;
        }

        private void handle_re(Attributes attributes) {
            String value = attributes.getValue("v");
            String ag = attributes.getValue("ag");
            String a = attributes.getValue("a");
            if (value == null) {
                throw CompilerException.invalidGramamr("re without @v");
            }
            value = GrammarCompiler.this.unxmlString(value);
            Collection<ParserAttribute> reattr = this.handleAttributes(ag, a);
            this.token = TokenRegex.get(value, reattr);
        }

        private void handle_meta(Attributes attributes) {
            String name = attributes.getValue("name");
            String value = attributes.getValue("value");
            if (name == null || value == null) {
                return;
            }
            name = GrammarCompiler.this.unnameString(name, false);
            value = GrammarCompiler.this.unxmlString(value, false);
            GrammarCompiler.this.properties.put(name, value);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if ("-".equals(this.elementStack.peek())) {
                return;
            }
            String text = new String(ch, start, length);
            if (!"".equals(text.trim())) {
                throw CompilerException.textNotAllowed(text);
            }
        }
    }
}

