/*
 * Decompiled with CFR 0.152.
 */
package org.nineml.coffeegrinder.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.nineml.coffeegrinder.tokens.Token;
import org.nineml.coffeegrinder.tokens.TokenCharacter;
import org.nineml.coffeegrinder.tokens.TokenString;

public class Iterators {
    public static Iterator<Token> characterIterator(final CharSequence input) {
        return new Iterator<Token>(){
            private final CharSequence seq;
            private int pos;
            {
                this.seq = input;
                this.pos = 0;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.seq.length();
            }

            @Override
            public Token next() {
                TokenCharacter tok;
                if (this.pos >= this.seq.length()) {
                    throw new NoSuchElementException("No more characters");
                }
                char ch = this.seq.charAt(this.pos);
                if (ch >= '\ud800' && ch <= '\udfff' && this.pos + 1 < this.seq.length()) {
                    char ch2 = this.seq.charAt(this.pos + 1);
                    String s = "" + ch + ch2;
                    tok = TokenCharacter.get(s.codePointAt(0));
                    this.pos += 2;
                } else {
                    tok = TokenCharacter.get(ch);
                    ++this.pos;
                }
                return tok;
            }
        };
    }

    public static Iterator<Token> stringIterator(String ... input) {
        return Iterators.stringIterator(Arrays.asList(input), false);
    }

    public static Iterator<Token> stringIterator(List<String> input) {
        return Iterators.stringIterator(input, true);
    }

    private static Iterator<Token> stringIterator(List<String> input, boolean copy) {
        final Iterator<String> iter = copy ? new ArrayList<String>(input).iterator() : input.iterator();
        return new Iterator<Token>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Token next() {
                if (iter.hasNext()) {
                    return TokenString.get((String)iter.next());
                }
                throw new NoSuchElementException("No more characters");
            }
        };
    }

    public static Iterator<Token> fileIterator(String filename) throws IOException {
        final FileInputStream fis = new FileInputStream(filename);
        return new Iterator<Token>(){
            private boolean nextAvailable = false;
            private int next = 0;

            @Override
            public boolean hasNext() {
                if (this.nextAvailable || this.next < 0) {
                    return this.next >= 0;
                }
                this.nextAvailable = true;
                try {
                    this.next = fis.read();
                }
                catch (IOException ex) {
                    this.next = -1;
                }
                return this.next >= 0;
            }

            @Override
            public Token next() {
                if (this.hasNext()) {
                    this.nextAvailable = false;
                    return TokenCharacter.get((char)this.next);
                }
                throw new NoSuchElementException("No more characters");
            }
        };
    }
}

